/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextUtils;
import java.util.Locale;

public final class BidiFormatter {
    private static final int DEFAULT_FLAGS = 2;
    private static final BidiFormatter DEFAULT_LTR_INSTANCE;
    private static final BidiFormatter DEFAULT_RTL_INSTANCE;
    private static TextDirectionHeuristic DEFAULT_TEXT_DIRECTION_HEURISTIC;
    private static final int DIR_LTR = -1;
    private static final int DIR_RTL = 1;
    private static final int DIR_UNKNOWN = 0;
    private static final String EMPTY_STRING = "";
    private static final int FLAG_STEREO_RESET = 2;
    private static final char LRE = '\u202a';
    private static final char LRM = '\u200e';
    private static final String LRM_STRING;
    private static final char PDF = '\u202c';
    private static final char RLE = '\u202b';
    private static final char RLM = '\u200f';
    private static final String RLM_STRING;
    private final TextDirectionHeuristic mDefaultTextDirectionHeuristic;
    private final int mFlags;
    private final boolean mIsRtlContext;

    static {
        DEFAULT_TEXT_DIRECTION_HEURISTIC = TextDirectionHeuristics.FIRSTSTRONG_LTR;
        LRM_STRING = Character.toString('\u200e');
        RLM_STRING = Character.toString('\u200f');
        DEFAULT_LTR_INSTANCE = new BidiFormatter(false, 2, DEFAULT_TEXT_DIRECTION_HEURISTIC);
        DEFAULT_RTL_INSTANCE = new BidiFormatter(true, 2, DEFAULT_TEXT_DIRECTION_HEURISTIC);
    }

    private BidiFormatter(boolean bl, int n, TextDirectionHeuristic textDirectionHeuristic) {
        this.mIsRtlContext = bl;
        this.mFlags = n;
        this.mDefaultTextDirectionHeuristic = textDirectionHeuristic;
    }

    private static int getEntryDir(String string2) {
        return new DirectionalityEstimator(string2, false).getEntryDir();
    }

    private static int getExitDir(String string2) {
        return new DirectionalityEstimator(string2, false).getExitDir();
    }

    public static BidiFormatter getInstance() {
        return new Builder().build();
    }

    public static BidiFormatter getInstance(Locale locale) {
        return new Builder(locale).build();
    }

    public static BidiFormatter getInstance(boolean bl) {
        return new Builder(bl).build();
    }

    private static boolean isRtlLocale(Locale locale) {
        return TextUtils.getLayoutDirectionFromLocale(locale) == 1;
    }

    public boolean getStereoReset() {
        return (2 & this.mFlags) != 0;
    }

    public boolean isRtl(String string2) {
        return this.mDefaultTextDirectionHeuristic.isRtl(string2, 0, string2.length());
    }

    public boolean isRtlContext() {
        return this.mIsRtlContext;
    }

    public String markAfter(String string2, TextDirectionHeuristic textDirectionHeuristic) {
        boolean bl = textDirectionHeuristic.isRtl(string2, 0, string2.length());
        if (!this.mIsRtlContext && (bl || BidiFormatter.getExitDir(string2) == 1)) {
            return LRM_STRING;
        }
        if (this.mIsRtlContext && (!bl || BidiFormatter.getExitDir(string2) == -1)) {
            return RLM_STRING;
        }
        return EMPTY_STRING;
    }

    public String markBefore(String string2, TextDirectionHeuristic textDirectionHeuristic) {
        boolean bl = textDirectionHeuristic.isRtl(string2, 0, string2.length());
        if (!this.mIsRtlContext && (bl || BidiFormatter.getEntryDir(string2) == 1)) {
            return LRM_STRING;
        }
        if (this.mIsRtlContext && (!bl || BidiFormatter.getEntryDir(string2) == -1)) {
            return RLM_STRING;
        }
        return EMPTY_STRING;
    }

    public String unicodeWrap(String string2) {
        return this.unicodeWrap(string2, this.mDefaultTextDirectionHeuristic, true);
    }

    public String unicodeWrap(String string2, TextDirectionHeuristic textDirectionHeuristic) {
        return this.unicodeWrap(string2, textDirectionHeuristic, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String unicodeWrap(String string2, TextDirectionHeuristic textDirectionHeuristic, boolean bl) {
        boolean bl2 = textDirectionHeuristic.isRtl(string2, 0, string2.length());
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getStereoReset() && bl) {
            TextDirectionHeuristic textDirectionHeuristic2 = bl2 ? TextDirectionHeuristics.RTL : TextDirectionHeuristics.LTR;
            stringBuilder.append(this.markBefore(string2, textDirectionHeuristic2));
        }
        if (bl2 != this.mIsRtlContext) {
            char c = bl2 ? (char)'\u202b' : '\u202a';
            stringBuilder.append(c);
            stringBuilder.append(string2);
            stringBuilder.append('\u202c');
        } else {
            stringBuilder.append(string2);
        }
        if (bl) {
            TextDirectionHeuristic textDirectionHeuristic3 = bl2 ? TextDirectionHeuristics.RTL : TextDirectionHeuristics.LTR;
            stringBuilder.append(this.markAfter(string2, textDirectionHeuristic3));
        }
        return stringBuilder.toString();
    }

    public String unicodeWrap(String string2, boolean bl) {
        return this.unicodeWrap(string2, this.mDefaultTextDirectionHeuristic, bl);
    }

    public static final class Builder {
        private int mFlags;
        private boolean mIsRtlContext;
        private TextDirectionHeuristic mTextDirectionHeuristic;

        public Builder() {
            this.initialize(BidiFormatter.isRtlLocale(Locale.getDefault()));
        }

        public Builder(Locale locale) {
            this.initialize(BidiFormatter.isRtlLocale(locale));
        }

        public Builder(boolean bl) {
            this.initialize(bl);
        }

        private static BidiFormatter getDefaultInstanceFromContext(boolean bl) {
            if (bl) {
                return DEFAULT_RTL_INSTANCE;
            }
            return DEFAULT_LTR_INSTANCE;
        }

        private void initialize(boolean bl) {
            this.mIsRtlContext = bl;
            this.mTextDirectionHeuristic = DEFAULT_TEXT_DIRECTION_HEURISTIC;
            this.mFlags = 2;
        }

        public BidiFormatter build() {
            if (this.mFlags == 2 && this.mTextDirectionHeuristic == DEFAULT_TEXT_DIRECTION_HEURISTIC) {
                return Builder.getDefaultInstanceFromContext(this.mIsRtlContext);
            }
            return new BidiFormatter(this.mIsRtlContext, this.mFlags, this.mTextDirectionHeuristic);
        }

        public Builder setTextDirectionHeuristic(TextDirectionHeuristic textDirectionHeuristic) {
            this.mTextDirectionHeuristic = textDirectionHeuristic;
            return this;
        }

        public Builder stereoReset(boolean bl) {
            if (bl) {
                this.mFlags = 2 | this.mFlags;
                return this;
            }
            this.mFlags = 0xFFFFFFFD & this.mFlags;
            return this;
        }
    }

    private static class DirectionalityEstimator {
        private static final byte[] DIR_TYPE_CACHE = new byte[1792];
        private static final int DIR_TYPE_CACHE_SIZE = 1792;
        private int charIndex;
        private final boolean isHtml;
        private char lastChar;
        private final int length;
        private final String text;

        static {
            for (int i = 0; i < 1792; ++i) {
                DirectionalityEstimator.DIR_TYPE_CACHE[i] = Character.getDirectionality(i);
            }
        }

        DirectionalityEstimator(String string2, boolean bl) {
            this.text = string2;
            this.isHtml = bl;
            this.length = string2.length();
        }

        private static byte getCachedDirectionality(char c) {
            if (c < '\u0700') {
                return DIR_TYPE_CACHE[c];
            }
            return Character.getDirectionality(c);
        }

        private byte skipEntityBackward() {
            int n = this.charIndex;
            while (this.charIndex > 0) {
                int n2;
                String string2 = this.text;
                this.charIndex = n2 = -1 + this.charIndex;
                this.lastChar = string2.charAt(n2);
                if (this.lastChar == '&') {
                    return 12;
                }
                if (this.lastChar != ';') continue;
            }
            this.charIndex = n;
            this.lastChar = (char)59;
            return 13;
        }

        private byte skipEntityForward() {
            while (this.charIndex < this.length) {
                char c;
                String string2 = this.text;
                int n = this.charIndex;
                this.charIndex = n + 1;
                this.lastChar = c = string2.charAt(n);
                if (c != ';') continue;
            }
            return 12;
        }

        /*
         * Enabled aggressive block sorting
         */
        private byte skipTagBackward() {
            int n = this.charIndex;
            block0: while (this.charIndex > 0) {
                int n2;
                String string2 = this.text;
                this.charIndex = n2 = -1 + this.charIndex;
                this.lastChar = string2.charAt(n2);
                if (this.lastChar == '<') {
                    return 12;
                }
                if (this.lastChar == '>') break;
                if (this.lastChar != '\"' && this.lastChar != '\'') continue;
                char c = this.lastChar;
                while (this.charIndex > 0) {
                    char c2;
                    int n3;
                    String string3 = this.text;
                    this.charIndex = n3 = -1 + this.charIndex;
                    this.lastChar = c2 = string3.charAt(n3);
                    if (c2 == c) continue block0;
                }
            }
            this.charIndex = n;
            this.lastChar = (char)62;
            return 13;
        }

        private byte skipTagForward() {
            int n = this.charIndex;
            block0: while (this.charIndex < this.length) {
                String string2 = this.text;
                int n2 = this.charIndex;
                this.charIndex = n2 + 1;
                this.lastChar = string2.charAt(n2);
                if (this.lastChar == '>') {
                    return 12;
                }
                if (this.lastChar != '\"' && this.lastChar != '\'') continue;
                char c = this.lastChar;
                while (this.charIndex < this.length) {
                    char c2;
                    String string3 = this.text;
                    int n3 = this.charIndex;
                    this.charIndex = n3 + 1;
                    this.lastChar = c2 = string3.charAt(n3);
                    if (c2 == c) continue block0;
                }
            }
            this.charIndex = n;
            this.lastChar = (char)60;
            return 13;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        byte dirTypeBackward() {
            this.lastChar = this.text.charAt(-1 + this.charIndex);
            if (Character.isLowSurrogate(this.lastChar)) {
                int n = Character.codePointBefore(this.text, this.charIndex);
                this.charIndex -= Character.charCount(n);
                return Character.getDirectionality(n);
            }
            this.charIndex = -1 + this.charIndex;
            byte by = DirectionalityEstimator.getCachedDirectionality(this.lastChar);
            if (!this.isHtml) return by;
            if (this.lastChar == '>') {
                return this.skipTagBackward();
            }
            if (this.lastChar != ';') return by;
            return this.skipEntityBackward();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        byte dirTypeForward() {
            this.lastChar = this.text.charAt(this.charIndex);
            if (Character.isHighSurrogate(this.lastChar)) {
                int n = Character.codePointAt(this.text, this.charIndex);
                this.charIndex += Character.charCount(n);
                return Character.getDirectionality(n);
            }
            this.charIndex = 1 + this.charIndex;
            byte by = DirectionalityEstimator.getCachedDirectionality(this.lastChar);
            if (!this.isHtml) return by;
            if (this.lastChar == '<') {
                return this.skipTagForward();
            }
            if (this.lastChar != '&') return by;
            return this.skipEntityForward();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        int getEntryDir() {
            this.charIndex = 0;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            block13: while (this.charIndex < this.length && n3 == 0) {
                switch (this.dirTypeForward()) {
                    case 9: {
                        continue block13;
                    }
                    default: {
                        n3 = n;
                        continue block13;
                    }
                    case 14: 
                    case 15: {
                        ++n;
                        n2 = -1;
                        continue block13;
                    }
                    case 16: 
                    case 17: {
                        ++n;
                        n2 = 1;
                        continue block13;
                    }
                    case 18: {
                        --n;
                        n2 = 0;
                        continue block13;
                    }
                    case 0: {
                        if (n == 0) {
                            return -1;
                        }
                        n3 = n;
                        continue block13;
                    }
                    case 1: 
                    case 2: 
                }
                if (n == 0) {
                    return 1;
                }
                n3 = n;
            }
            if (n3 == 0) {
                return 0;
            }
            if (n2 != 0) return n2;
            block14: while (this.charIndex > 0) {
                switch (this.dirTypeBackward()) {
                    default: {
                        continue block14;
                    }
                    case 14: 
                    case 15: {
                        if (n3 == n) {
                            return -1;
                        }
                        --n;
                        continue block14;
                    }
                    case 16: 
                    case 17: {
                        if (n3 == n) {
                            return 1;
                        }
                        --n;
                        continue block14;
                    }
                    case 18: 
                }
                ++n;
            }
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        int getExitDir() {
            this.charIndex = this.length;
            int n = 0;
            int n2 = 0;
            block8: while (this.charIndex > 0) {
                switch (this.dirTypeBackward()) {
                    case 9: {
                        continue block8;
                    }
                    default: {
                        if (n2 != 0) continue block8;
                        n2 = n;
                        continue block8;
                    }
                    case 0: {
                        if (n == 0) return -1;
                        if (n2 != 0) continue block8;
                        n2 = n;
                        continue block8;
                    }
                    case 14: 
                    case 15: {
                        if (n2 == n) {
                            return -1;
                        }
                        --n;
                        continue block8;
                    }
                    case 1: 
                    case 2: {
                        if (n == 0) {
                            return 1;
                        }
                        if (n2 != 0) continue block8;
                        n2 = n;
                        continue block8;
                    }
                    case 16: 
                    case 17: {
                        if (n2 == n) {
                            return 1;
                        }
                        --n;
                        continue block8;
                    }
                    case 18: 
                }
                ++n;
            }
            return 0;
        }
    }
}

