/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;

public class AndroidTestCase
extends TestCase {
    protected Context mContext;
    private Context mTestContext;

    public void assertActivityRequiresPermission(String string2, String string3, String string4) {
        Intent intent = new Intent();
        intent.setClassName(string2, string3);
        intent.addFlags(0x10000000);
        try {
            this.getContext().startActivity(intent);
            AndroidTestCase.fail("expected security exception for " + string4);
            return;
        }
        catch (SecurityException securityException) {
            AndroidTestCase.assertNotNull("security exception's error message.", securityException.getMessage());
            AndroidTestCase.assertTrue("error message should contain " + string4 + ".", securityException.getMessage().contains(string4));
            return;
        }
    }

    public void assertReadingContentUriRequiresPermission(Uri uri, String string2) {
        try {
            this.getContext().getContentResolver().query(uri, null, null, null, null);
            AndroidTestCase.fail("expected SecurityException requiring " + string2);
            return;
        }
        catch (SecurityException securityException) {
            AndroidTestCase.assertNotNull("security exception's error message.", securityException.getMessage());
            AndroidTestCase.assertTrue("error message should contain " + string2 + ".", securityException.getMessage().contains(string2));
            return;
        }
    }

    public void assertWritingContentUriRequiresPermission(Uri uri, String string2) {
        try {
            this.getContext().getContentResolver().insert(uri, new ContentValues());
            AndroidTestCase.fail("expected SecurityException requiring " + string2);
            return;
        }
        catch (SecurityException securityException) {
            AndroidTestCase.assertNotNull("security exception's error message.", securityException.getMessage());
            AndroidTestCase.assertTrue("error message should contain \"" + string2 + "\". Got: \"" + securityException.getMessage() + "\".", securityException.getMessage().contains(string2));
            return;
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public Context getTestContext() {
        return this.mTestContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void scrubClass(Class<?> clazz) throws IllegalAccessException {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!field.getType().isPrimitive() && !Modifier.isStatic(field.getModifiers())) {
                try {
                    field.setAccessible(true);
                    field.set(this, null);
                }
                catch (Exception exception) {
                    Log.d("TestCase", "Error: Could not nullify field!");
                }
                if (field.get(this) != null) {
                    Log.d("TestCase", "Error: Could not nullify field!");
                }
            }
            ++n2;
        }
        return;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public void setTestContext(Context context) {
        this.mTestContext = context;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAndroidTestCaseSetupProperly() {
        AndroidTestCase.assertNotNull("Context is null. setContext should be called before tests are run", this.mContext);
    }
}

