/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.Rlog;

public class SignalStrength
implements Parcelable {
    public static final Parcelable.Creator<SignalStrength> CREATOR;
    private static final boolean DBG = false;
    public static final int INVALID = Integer.MAX_VALUE;
    private static final String LOG_TAG = "SignalStrength";
    public static final int NUM_SIGNAL_STRENGTH_BINS = 5;
    public static final int SIGNAL_STRENGTH_GOOD = 3;
    public static final int SIGNAL_STRENGTH_GREAT = 4;
    public static final int SIGNAL_STRENGTH_MODERATE = 2;
    public static final String[] SIGNAL_STRENGTH_NAMES;
    public static final int SIGNAL_STRENGTH_NONE_OR_UNKNOWN = 0;
    public static final int SIGNAL_STRENGTH_POOR = 1;
    private boolean isGsm;
    private int mCdmaDbm;
    private int mCdmaEcio;
    private int mEvdoDbm;
    private int mEvdoEcio;
    private int mEvdoSnr;
    private int mGsmBitErrorRate;
    private int mGsmSignalStrength;
    private int mLteCqi;
    private int mLteRsrp;
    private int mLteRsrq;
    private int mLteRssnr;
    private int mLteSignalStrength;

    static {
        SIGNAL_STRENGTH_NAMES = new String[]{"none", "poor", "moderate", "good", "great"};
        CREATOR = new Parcelable.Creator(){

            public SignalStrength createFromParcel(Parcel parcel) {
                return new SignalStrength(parcel);
            }

            public SignalStrength[] newArray(int n) {
                return new SignalStrength[n];
            }
        };
    }

    public SignalStrength() {
        this.mGsmSignalStrength = 99;
        this.mGsmBitErrorRate = -1;
        this.mCdmaDbm = -1;
        this.mCdmaEcio = -1;
        this.mEvdoDbm = -1;
        this.mEvdoEcio = -1;
        this.mEvdoSnr = -1;
        this.mLteSignalStrength = 99;
        this.mLteRsrp = Integer.MAX_VALUE;
        this.mLteRsrq = Integer.MAX_VALUE;
        this.mLteRssnr = Integer.MAX_VALUE;
        this.mLteCqi = Integer.MAX_VALUE;
        this.isGsm = true;
    }

    public SignalStrength(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, boolean bl) {
        this.initialize(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, bl);
    }

    public SignalStrength(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        this.initialize(n, n2, n3, n4, n5, n6, n7, 99, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SignalStrength(Parcel parcel) {
        this.mGsmSignalStrength = parcel.readInt();
        this.mGsmBitErrorRate = parcel.readInt();
        this.mCdmaDbm = parcel.readInt();
        this.mCdmaEcio = parcel.readInt();
        this.mEvdoDbm = parcel.readInt();
        this.mEvdoEcio = parcel.readInt();
        this.mEvdoSnr = parcel.readInt();
        this.mLteSignalStrength = parcel.readInt();
        this.mLteRsrp = parcel.readInt();
        this.mLteRsrq = parcel.readInt();
        this.mLteRssnr = parcel.readInt();
        this.mLteCqi = parcel.readInt();
        boolean bl = parcel.readInt() != 0;
        this.isGsm = bl;
    }

    public SignalStrength(SignalStrength signalStrength) {
        this.copyFrom(signalStrength);
    }

    public SignalStrength(boolean bl) {
        this.mGsmSignalStrength = 99;
        this.mGsmBitErrorRate = -1;
        this.mCdmaDbm = -1;
        this.mCdmaEcio = -1;
        this.mEvdoDbm = -1;
        this.mEvdoEcio = -1;
        this.mEvdoSnr = -1;
        this.mLteSignalStrength = 99;
        this.mLteRsrp = Integer.MAX_VALUE;
        this.mLteRsrq = Integer.MAX_VALUE;
        this.mLteRssnr = Integer.MAX_VALUE;
        this.mLteCqi = Integer.MAX_VALUE;
        this.isGsm = bl;
    }

    private static void log(String string2) {
        Rlog.w(LOG_TAG, string2);
    }

    public static SignalStrength makeSignalStrengthFromRilParcel(Parcel parcel) {
        SignalStrength signalStrength = new SignalStrength();
        signalStrength.mGsmSignalStrength = parcel.readInt();
        signalStrength.mGsmBitErrorRate = parcel.readInt();
        signalStrength.mCdmaDbm = parcel.readInt();
        signalStrength.mCdmaEcio = parcel.readInt();
        signalStrength.mEvdoDbm = parcel.readInt();
        signalStrength.mEvdoEcio = parcel.readInt();
        signalStrength.mEvdoSnr = parcel.readInt();
        signalStrength.mLteSignalStrength = parcel.readInt();
        signalStrength.mLteRsrp = parcel.readInt();
        signalStrength.mLteRsrq = parcel.readInt();
        signalStrength.mLteRssnr = parcel.readInt();
        signalStrength.mLteCqi = parcel.readInt();
        return signalStrength;
    }

    public static SignalStrength newFromBundle(Bundle bundle) {
        SignalStrength signalStrength = new SignalStrength();
        signalStrength.setFromNotifierBundle(bundle);
        return signalStrength;
    }

    private void setFromNotifierBundle(Bundle bundle) {
        this.mGsmSignalStrength = bundle.getInt("GsmSignalStrength");
        this.mGsmBitErrorRate = bundle.getInt("GsmBitErrorRate");
        this.mCdmaDbm = bundle.getInt("CdmaDbm");
        this.mCdmaEcio = bundle.getInt("CdmaEcio");
        this.mEvdoDbm = bundle.getInt("EvdoDbm");
        this.mEvdoEcio = bundle.getInt("EvdoEcio");
        this.mEvdoSnr = bundle.getInt("EvdoSnr");
        this.mLteSignalStrength = bundle.getInt("LteSignalStrength");
        this.mLteRsrp = bundle.getInt("LteRsrp");
        this.mLteRsrq = bundle.getInt("LteRsrq");
        this.mLteRssnr = bundle.getInt("LteRssnr");
        this.mLteCqi = bundle.getInt("LteCqi");
        this.isGsm = bundle.getBoolean("isGsm");
    }

    protected void copyFrom(SignalStrength signalStrength) {
        this.mGsmSignalStrength = signalStrength.mGsmSignalStrength;
        this.mGsmBitErrorRate = signalStrength.mGsmBitErrorRate;
        this.mCdmaDbm = signalStrength.mCdmaDbm;
        this.mCdmaEcio = signalStrength.mCdmaEcio;
        this.mEvdoDbm = signalStrength.mEvdoDbm;
        this.mEvdoEcio = signalStrength.mEvdoEcio;
        this.mEvdoSnr = signalStrength.mEvdoSnr;
        this.mLteSignalStrength = signalStrength.mLteSignalStrength;
        this.mLteRsrp = signalStrength.mLteRsrp;
        this.mLteRsrq = signalStrength.mLteRsrq;
        this.mLteRssnr = signalStrength.mLteRssnr;
        this.mLteCqi = signalStrength.mLteCqi;
        this.isGsm = signalStrength.isGsm;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        SignalStrength signalStrength;
        block3: {
            try {
                signalStrength = (SignalStrength)object;
                if (object != null) break block3;
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        if (this.mGsmSignalStrength == signalStrength.mGsmSignalStrength && this.mGsmBitErrorRate == signalStrength.mGsmBitErrorRate && this.mCdmaDbm == signalStrength.mCdmaDbm && this.mCdmaEcio == signalStrength.mCdmaEcio && this.mEvdoDbm == signalStrength.mEvdoDbm && this.mEvdoEcio == signalStrength.mEvdoEcio && this.mEvdoSnr == signalStrength.mEvdoSnr && this.mLteSignalStrength == signalStrength.mLteSignalStrength && this.mLteRsrp == signalStrength.mLteRsrp && this.mLteRsrq == signalStrength.mLteRsrq && this.mLteRssnr == signalStrength.mLteRssnr && this.mLteCqi == signalStrength.mLteCqi && this.isGsm == signalStrength.isGsm) return true;
        return false;
    }

    public void fillInNotifierBundle(Bundle bundle) {
        bundle.putInt("GsmSignalStrength", this.mGsmSignalStrength);
        bundle.putInt("GsmBitErrorRate", this.mGsmBitErrorRate);
        bundle.putInt("CdmaDbm", this.mCdmaDbm);
        bundle.putInt("CdmaEcio", this.mCdmaEcio);
        bundle.putInt("EvdoDbm", this.mEvdoDbm);
        bundle.putInt("EvdoEcio", this.mEvdoEcio);
        bundle.putInt("EvdoSnr", this.mEvdoSnr);
        bundle.putInt("LteSignalStrength", this.mLteSignalStrength);
        bundle.putInt("LteRsrp", this.mLteRsrp);
        bundle.putInt("LteRsrq", this.mLteRsrq);
        bundle.putInt("LteRssnr", this.mLteRssnr);
        bundle.putInt("LteCqi", this.mLteCqi);
        bundle.putBoolean("isGsm", this.isGsm);
    }

    public int getAsuLevel() {
        if (this.isGsm) {
            if (this.getLteLevel() == 0) {
                return this.getGsmAsuLevel();
            }
            return this.getLteAsuLevel();
        }
        int n = this.getCdmaAsuLevel();
        int n2 = this.getEvdoAsuLevel();
        if (n2 == 0) {
            return n;
        }
        if (n == 0) {
            return n2;
        }
        if (n < n2) {
            return n;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getCdmaAsuLevel() {
        int n;
        int n2;
        int n3 = this.getCdmaDbm();
        int n4 = n3 >= -75 ? 16 : (n3 >= -82 ? 8 : (n3 >= -90 ? 4 : (n3 >= -95 ? 2 : (n3 >= -100 ? 1 : 99))));
        if (n4 < (n2 = (n = this.getCdmaEcio()) >= -90 ? 16 : (n >= -100 ? 8 : (n >= -115 ? 4 : (n >= -130 ? 2 : (n >= -150 ? 1 : 99)))))) {
            return n4;
        }
        return n2;
    }

    public int getCdmaDbm() {
        return this.mCdmaDbm;
    }

    public int getCdmaEcio() {
        return this.mCdmaEcio;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getCdmaLevel() {
        int n;
        int n2;
        int n3 = this.getCdmaDbm();
        int n4 = n3 >= -75 ? 4 : (n3 >= -85 ? 3 : (n3 >= -95 ? 2 : (n3 >= -100 ? 1 : 0)));
        if (n4 < (n2 = (n = this.getCdmaEcio()) >= -90 ? 4 : (n >= -110 ? 3 : (n >= -130 ? 2 : (n >= -150 ? 1 : 0))))) {
            return n4;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDbm() {
        if (this.isGsm()) {
            int n = this.getLteDbm();
            if (n != Integer.MAX_VALUE) return n;
            return this.getGsmDbm();
        }
        int n = this.getCdmaDbm();
        int n2 = this.getEvdoDbm();
        if (n2 == -120) {
            return n;
        }
        if (n == -120) {
            return n2;
        }
        if (n < n2) return n;
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getEvdoAsuLevel() {
        int n;
        int n2;
        int n3 = this.getEvdoDbm();
        int n4 = n3 >= -65 ? 16 : (n3 >= -75 ? 8 : (n3 >= -85 ? 4 : (n3 >= -95 ? 2 : (n3 >= -105 ? 1 : 99))));
        if (n4 < (n2 = (n = this.getEvdoSnr()) >= 7 ? 16 : (n >= 6 ? 8 : (n >= 5 ? 4 : (n >= 3 ? 2 : (n >= 1 ? 1 : 99)))))) {
            return n4;
        }
        return n2;
    }

    public int getEvdoDbm() {
        return this.mEvdoDbm;
    }

    public int getEvdoEcio() {
        return this.mEvdoEcio;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getEvdoLevel() {
        int n;
        int n2;
        int n3 = this.getEvdoDbm();
        int n4 = n3 >= -65 ? 4 : (n3 >= -75 ? 3 : (n3 >= -90 ? 2 : (n3 >= -105 ? 1 : 0)));
        if (n4 < (n2 = (n = this.getEvdoSnr()) >= 7 ? 4 : (n >= 5 ? 3 : (n >= 3 ? 2 : (n >= 1 ? 1 : 0))))) {
            return n4;
        }
        return n2;
    }

    public int getEvdoSnr() {
        return this.mEvdoSnr;
    }

    public int getGsmAsuLevel() {
        return this.getGsmSignalStrength();
    }

    public int getGsmBitErrorRate() {
        return this.mGsmBitErrorRate;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getGsmDbm() {
        int n = this.getGsmSignalStrength();
        if (n == 99) {
            return -1;
        }
        int n2 = n;
        if (n2 == -1) return -1;
        return -113 + n2 * 2;
    }

    public int getGsmLevel() {
        int n = this.getGsmSignalStrength();
        if (n <= 2 || n == 99) {
            return 0;
        }
        if (n >= 12) {
            return 4;
        }
        if (n >= 8) {
            return 3;
        }
        if (n >= 5) {
            return 2;
        }
        return 1;
    }

    public int getGsmSignalStrength() {
        return this.mGsmSignalStrength;
    }

    public int getLevel() {
        if (this.isGsm) {
            int n = this.getLteLevel();
            if (n == 0) {
                n = this.getGsmLevel();
            }
            return n;
        }
        int n = this.getCdmaLevel();
        int n2 = this.getEvdoLevel();
        if (n2 == 0) {
            return n;
        }
        if (n == 0) {
            return n2;
        }
        if (n < n2) {
            return n;
        }
        return n2;
    }

    public int getLteAsuLevel() {
        int n = this.getLteDbm();
        if (n == Integer.MAX_VALUE) {
            return 255;
        }
        return n + 140;
    }

    public int getLteCqi() {
        return this.mLteCqi;
    }

    public int getLteDbm() {
        return this.mLteRsrp;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getLteLevel() {
        int n = -1;
        int n2 = -1;
        if (this.mLteRsrp > -44) {
            n = -1;
        } else if (this.mLteRsrp >= -85) {
            n = 4;
        } else if (this.mLteRsrp >= -95) {
            n = 3;
        } else if (this.mLteRsrp >= -105) {
            n = 2;
        } else if (this.mLteRsrp >= -115) {
            n = 1;
        } else if (this.mLteRsrp >= -140) {
            n = 0;
        }
        if (this.mLteRssnr > 300) {
            n2 = -1;
        } else if (this.mLteRssnr >= 130) {
            n2 = 4;
        } else if (this.mLteRssnr >= 45) {
            n2 = 3;
        } else if (this.mLteRssnr >= 10) {
            n2 = 2;
        } else if (this.mLteRssnr >= -30) {
            n2 = 1;
        } else if (this.mLteRssnr >= -200) {
            n2 = 0;
        }
        if (n2 != -1 && n != -1) {
            if (n >= n2) return n2;
            return n;
        }
        if (n2 != -1) {
            return n2;
        }
        if (n != -1) return n;
        if (this.mLteSignalStrength > 63) {
            return 0;
        }
        if (this.mLteSignalStrength >= 12) {
            return 4;
        }
        if (this.mLteSignalStrength >= 8) {
            return 3;
        }
        if (this.mLteSignalStrength >= 5) {
            return 2;
        }
        int n3 = this.mLteSignalStrength;
        int n4 = 0;
        if (n3 < 0) return n4;
        return 1;
    }

    public int getLteRsrp() {
        return this.mLteRsrp;
    }

    public int getLteRsrq() {
        return this.mLteRsrq;
    }

    public int getLteRssnr() {
        return this.mLteRssnr;
    }

    public int getLteSignalStrength() {
        return this.mLteSignalStrength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        int n;
        int n2 = 31 * this.mGsmSignalStrength + 31 * this.mGsmBitErrorRate + 31 * this.mCdmaDbm + 31 * this.mCdmaEcio + 31 * this.mEvdoDbm + 31 * this.mEvdoEcio + 31 * this.mEvdoSnr + 31 * this.mLteSignalStrength + 31 * this.mLteRsrp + 31 * this.mLteRsrq + 31 * this.mLteRssnr + 31 * this.mLteCqi;
        if (this.isGsm) {
            n = 1;
            return n + n2;
        }
        n = 0;
        return n + n2;
    }

    public void initialize(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, boolean bl) {
        this.mGsmSignalStrength = n;
        this.mGsmBitErrorRate = n2;
        this.mCdmaDbm = n3;
        this.mCdmaEcio = n4;
        this.mEvdoDbm = n5;
        this.mEvdoEcio = n6;
        this.mEvdoSnr = n7;
        this.mLteSignalStrength = n8;
        this.mLteRsrp = n9;
        this.mLteRsrq = n10;
        this.mLteRssnr = n11;
        this.mLteCqi = n12;
        this.isGsm = bl;
    }

    public void initialize(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        this.initialize(n, n2, n3, n4, n5, n6, n7, 99, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, bl);
    }

    public boolean isGsm() {
        return this.isGsm;
    }

    public void setGsm(boolean bl) {
        this.isGsm = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder().append("SignalStrength: ").append(this.mGsmSignalStrength).append(" ").append(this.mGsmBitErrorRate).append(" ").append(this.mCdmaDbm).append(" ").append(this.mCdmaEcio).append(" ").append(this.mEvdoDbm).append(" ").append(this.mEvdoEcio).append(" ").append(this.mEvdoSnr).append(" ").append(this.mLteSignalStrength).append(" ").append(this.mLteRsrp).append(" ").append(this.mLteRsrq).append(" ").append(this.mLteRssnr).append(" ").append(this.mLteCqi).append(" ");
        if (this.isGsm) {
            string2 = "gsm|lte";
            return stringBuilder.append(string2).toString();
        }
        string2 = "cdma";
        return stringBuilder.append(string2).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void validateInput() {
        int n = 99;
        int n2 = -1;
        int n3 = -120;
        int n4 = Integer.MAX_VALUE;
        int n5 = this.mGsmSignalStrength >= 0 ? this.mGsmSignalStrength : n;
        this.mGsmSignalStrength = n5;
        int n6 = this.mCdmaDbm > 0 ? -this.mCdmaDbm : n3;
        this.mCdmaDbm = n6;
        int n7 = this.mCdmaEcio > 0 ? -this.mCdmaEcio : -160;
        this.mCdmaEcio = n7;
        if (this.mEvdoDbm > 0) {
            n3 = -this.mEvdoDbm;
        }
        this.mEvdoDbm = n3;
        int n8 = this.mEvdoEcio >= 0 ? -this.mEvdoEcio : n2;
        this.mEvdoEcio = n8;
        if (this.mEvdoSnr > 0 && this.mEvdoSnr <= 8) {
            n2 = this.mEvdoSnr;
        }
        this.mEvdoSnr = n2;
        if (this.mLteSignalStrength >= 0) {
            n = this.mLteSignalStrength;
        }
        this.mLteSignalStrength = n;
        int n9 = this.mLteRsrp >= 44 && this.mLteRsrp <= 140 ? -this.mLteRsrp : n4;
        this.mLteRsrp = n9;
        int n10 = this.mLteRsrq >= 3 && this.mLteRsrq <= 20 ? -this.mLteRsrq : n4;
        this.mLteRsrq = n10;
        if (this.mLteRssnr >= -200 && this.mLteRssnr <= 300) {
            n4 = this.mLteRssnr;
        }
        this.mLteRssnr = n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mGsmSignalStrength);
        parcel.writeInt(this.mGsmBitErrorRate);
        parcel.writeInt(this.mCdmaDbm);
        parcel.writeInt(this.mCdmaEcio);
        parcel.writeInt(this.mEvdoDbm);
        parcel.writeInt(this.mEvdoEcio);
        parcel.writeInt(this.mEvdoSnr);
        parcel.writeInt(this.mLteSignalStrength);
        parcel.writeInt(this.mLteRsrp);
        parcel.writeInt(this.mLteRsrq);
        parcel.writeInt(this.mLteRssnr);
        parcel.writeInt(this.mLteCqi);
        int n2 = this.isGsm ? 1 : 0;
        parcel.writeInt(n2);
    }
}

