/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.DataConnectionRealTimeInfo;
import android.telephony.PreciseCallState;
import android.telephony.PreciseDataConnectionState;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.VoLteServiceState;
import com.android.internal.telephony.IPhoneStateListener;
import java.util.List;

public class PhoneStateListener {
    private static final boolean DBG = false;
    public static final int LISTEN_CALL_FORWARDING_INDICATOR = 8;
    public static final int LISTEN_CALL_STATE = 32;
    public static final int LISTEN_CELL_INFO = 1024;
    public static final int LISTEN_CELL_LOCATION = 16;
    public static final int LISTEN_DATA_ACTIVITY = 128;
    public static final int LISTEN_DATA_CONNECTION_REAL_TIME_INFO = 8192;
    public static final int LISTEN_DATA_CONNECTION_STATE = 64;
    public static final int LISTEN_MESSAGE_WAITING_INDICATOR = 4;
    public static final int LISTEN_NONE = 0;
    public static final int LISTEN_OEM_HOOK_RAW_EVENT = 32768;
    public static final int LISTEN_OTASP_CHANGED = 512;
    public static final int LISTEN_PRECISE_CALL_STATE = 2048;
    public static final int LISTEN_PRECISE_DATA_CONNECTION_STATE = 4096;
    public static final int LISTEN_SERVICE_STATE = 1;
    @Deprecated
    public static final int LISTEN_SIGNAL_STRENGTH = 2;
    public static final int LISTEN_SIGNAL_STRENGTHS = 256;
    public static final int LISTEN_VOLTE_STATE = 16384;
    private static final String LOG_TAG = "PhoneStateListener";
    IPhoneStateListener callback = new IPhoneStateListener.Stub(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onCallForwardingIndicatorChanged(boolean bl) {
            Handler handler = PhoneStateListener.this.mHandler;
            int n = bl ? 1 : 0;
            Message.obtain(handler, 8, n, 0, null).sendToTarget();
        }

        @Override
        public void onCallStateChanged(int n, String string2) {
            Message.obtain(PhoneStateListener.this.mHandler, 32, n, 0, string2).sendToTarget();
        }

        @Override
        public void onCellInfoChanged(List<CellInfo> list) {
            Message.obtain(PhoneStateListener.this.mHandler, 1024, 0, 0, list).sendToTarget();
        }

        @Override
        public void onCellLocationChanged(Bundle bundle) {
            CellLocation cellLocation = CellLocation.newFromBundle(bundle);
            Message.obtain(PhoneStateListener.this.mHandler, 16, 0, 0, cellLocation).sendToTarget();
        }

        @Override
        public void onDataActivity(int n) {
            Message.obtain(PhoneStateListener.this.mHandler, 128, n, 0, null).sendToTarget();
        }

        @Override
        public void onDataConnectionRealTimeInfoChanged(DataConnectionRealTimeInfo dataConnectionRealTimeInfo) {
            Message.obtain(PhoneStateListener.this.mHandler, 8192, 0, 0, dataConnectionRealTimeInfo).sendToTarget();
        }

        @Override
        public void onDataConnectionStateChanged(int n, int n2) {
            Message.obtain(PhoneStateListener.this.mHandler, 64, n, n2).sendToTarget();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onMessageWaitingIndicatorChanged(boolean bl) {
            Handler handler = PhoneStateListener.this.mHandler;
            int n = bl ? 1 : 0;
            Message.obtain(handler, 4, n, 0, null).sendToTarget();
        }

        @Override
        public void onOemHookRawEvent(byte[] byArray) {
            Message.obtain(PhoneStateListener.this.mHandler, 32768, 0, 0, byArray).sendToTarget();
        }

        @Override
        public void onOtaspChanged(int n) {
            Message.obtain(PhoneStateListener.this.mHandler, 512, n, 0).sendToTarget();
        }

        @Override
        public void onPreciseCallStateChanged(PreciseCallState preciseCallState) {
            Message.obtain(PhoneStateListener.this.mHandler, 2048, 0, 0, preciseCallState).sendToTarget();
        }

        @Override
        public void onPreciseDataConnectionStateChanged(PreciseDataConnectionState preciseDataConnectionState) {
            Message.obtain(PhoneStateListener.this.mHandler, 4096, 0, 0, preciseDataConnectionState).sendToTarget();
        }

        @Override
        public void onServiceStateChanged(ServiceState serviceState) {
            Message.obtain(PhoneStateListener.this.mHandler, 1, 0, 0, serviceState).sendToTarget();
        }

        @Override
        public void onSignalStrengthChanged(int n) {
            Message.obtain(PhoneStateListener.this.mHandler, 2, n, 0, null).sendToTarget();
        }

        @Override
        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            Message.obtain(PhoneStateListener.this.mHandler, 256, 0, 0, signalStrength).sendToTarget();
        }

        @Override
        public void onVoLteServiceStateChanged(VoLteServiceState voLteServiceState) {
            Message.obtain(PhoneStateListener.this.mHandler, 16384, 0, 0, voLteServiceState).sendToTarget();
        }
    };
    private final Handler mHandler;
    protected long mSubId = 0L;

    public PhoneStateListener() {
        this(Long.MAX_VALUE, Looper.myLooper());
    }

    public PhoneStateListener(long l) {
        this(l, Looper.myLooper());
    }

    public PhoneStateListener(long l, Looper looper) {
        this.mSubId = l;
        this.mHandler = new Handler(looper){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void handleMessage(Message message) {
                boolean bl = true;
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        PhoneStateListener.this.onServiceStateChanged((ServiceState)message.obj);
                        return;
                    }
                    case 2: {
                        PhoneStateListener.this.onSignalStrengthChanged(message.arg1);
                        return;
                    }
                    case 4: {
                        PhoneStateListener phoneStateListener = PhoneStateListener.this;
                        if (message.arg1 == 0) {
                            bl = false;
                        }
                        phoneStateListener.onMessageWaitingIndicatorChanged(bl);
                        return;
                    }
                    case 8: {
                        PhoneStateListener phoneStateListener = PhoneStateListener.this;
                        if (message.arg1 == 0) {
                            bl = false;
                        }
                        phoneStateListener.onCallForwardingIndicatorChanged(bl);
                        return;
                    }
                    case 16: {
                        PhoneStateListener.this.onCellLocationChanged((CellLocation)message.obj);
                        return;
                    }
                    case 32: {
                        PhoneStateListener.this.onCallStateChanged(message.arg1, (String)message.obj);
                        return;
                    }
                    case 64: {
                        PhoneStateListener.this.onDataConnectionStateChanged(message.arg1, message.arg2);
                        PhoneStateListener.this.onDataConnectionStateChanged(message.arg1);
                        return;
                    }
                    case 128: {
                        PhoneStateListener.this.onDataActivity(message.arg1);
                        return;
                    }
                    case 256: {
                        PhoneStateListener.this.onSignalStrengthsChanged((SignalStrength)message.obj);
                        return;
                    }
                    case 512: {
                        PhoneStateListener.this.onOtaspChanged(message.arg1);
                        return;
                    }
                    case 1024: {
                        PhoneStateListener.this.onCellInfoChanged((List)message.obj);
                        return;
                    }
                    case 2048: {
                        PhoneStateListener.this.onPreciseCallStateChanged((PreciseCallState)message.obj);
                        return;
                    }
                    case 4096: {
                        PhoneStateListener.this.onPreciseDataConnectionStateChanged((PreciseDataConnectionState)message.obj);
                        return;
                    }
                    case 8192: {
                        PhoneStateListener.this.onDataConnectionRealTimeInfoChanged((DataConnectionRealTimeInfo)message.obj);
                        return;
                    }
                    case 16384: {
                        PhoneStateListener.this.onVoLteServiceStateChanged((VoLteServiceState)message.obj);
                        return;
                    }
                    case 32768: 
                }
                PhoneStateListener.this.onOemHookRawEvent((byte[])message.obj);
            }
        };
    }

    public PhoneStateListener(Looper looper) {
        this(Long.MAX_VALUE, looper);
    }

    private void log(String string2) {
        Rlog.d(LOG_TAG, string2);
    }

    public void onCallForwardingIndicatorChanged(boolean bl) {
    }

    public void onCallStateChanged(int n, String string2) {
    }

    public void onCellInfoChanged(List<CellInfo> list) {
    }

    public void onCellLocationChanged(CellLocation cellLocation) {
    }

    public void onDataActivity(int n) {
    }

    public void onDataConnectionRealTimeInfoChanged(DataConnectionRealTimeInfo dataConnectionRealTimeInfo) {
    }

    public void onDataConnectionStateChanged(int n) {
    }

    public void onDataConnectionStateChanged(int n, int n2) {
    }

    public void onMessageWaitingIndicatorChanged(boolean bl) {
    }

    public void onOemHookRawEvent(byte[] byArray) {
    }

    public void onOtaspChanged(int n) {
    }

    public void onPreciseCallStateChanged(PreciseCallState preciseCallState) {
    }

    public void onPreciseDataConnectionStateChanged(PreciseDataConnectionState preciseDataConnectionState) {
    }

    public void onServiceStateChanged(ServiceState serviceState) {
    }

    @Deprecated
    public void onSignalStrengthChanged(int n) {
    }

    public void onSignalStrengthsChanged(SignalStrength signalStrength) {
    }

    public void onVoLteServiceStateChanged(VoLteServiceState voLteServiceState) {
    }
}

