/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellSignalStrength;
import android.telephony.Rlog;

public final class CellSignalStrengthCdma
extends CellSignalStrength
implements Parcelable {
    public static final Parcelable.Creator<CellSignalStrengthCdma> CREATOR = new Parcelable.Creator<CellSignalStrengthCdma>(){

        @Override
        public CellSignalStrengthCdma createFromParcel(Parcel parcel) {
            return new CellSignalStrengthCdma(parcel);
        }

        public CellSignalStrengthCdma[] newArray(int n) {
            return new CellSignalStrengthCdma[n];
        }
    };
    private static final boolean DBG = false;
    private static final String LOG_TAG = "CellSignalStrengthCdma";
    private int mCdmaDbm;
    private int mCdmaEcio;
    private int mEvdoDbm;
    private int mEvdoEcio;
    private int mEvdoSnr;

    public CellSignalStrengthCdma() {
        this.setDefaultValues();
    }

    public CellSignalStrengthCdma(int n, int n2, int n3, int n4, int n5) {
        this.initialize(n, n2, n3, n4, n5);
    }

    private CellSignalStrengthCdma(Parcel parcel) {
        this.mCdmaDbm = -1 * parcel.readInt();
        this.mCdmaEcio = -1 * parcel.readInt();
        this.mEvdoDbm = -1 * parcel.readInt();
        this.mEvdoEcio = -1 * parcel.readInt();
        this.mEvdoSnr = parcel.readInt();
    }

    public CellSignalStrengthCdma(CellSignalStrengthCdma cellSignalStrengthCdma) {
        this.copyFrom(cellSignalStrengthCdma);
    }

    private static void log(String string2) {
        Rlog.w(LOG_TAG, string2);
    }

    @Override
    public CellSignalStrengthCdma copy() {
        return new CellSignalStrengthCdma(this);
    }

    protected void copyFrom(CellSignalStrengthCdma cellSignalStrengthCdma) {
        this.mCdmaDbm = cellSignalStrengthCdma.mCdmaDbm;
        this.mCdmaEcio = cellSignalStrengthCdma.mCdmaEcio;
        this.mEvdoDbm = cellSignalStrengthCdma.mEvdoDbm;
        this.mEvdoEcio = cellSignalStrengthCdma.mEvdoEcio;
        this.mEvdoSnr = cellSignalStrengthCdma.mEvdoSnr;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object object) {
        CellSignalStrengthCdma cellSignalStrengthCdma;
        block3: {
            try {
                cellSignalStrengthCdma = (CellSignalStrengthCdma)object;
                if (object != null) break block3;
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        if (this.mCdmaDbm == cellSignalStrengthCdma.mCdmaDbm && this.mCdmaEcio == cellSignalStrengthCdma.mCdmaEcio && this.mEvdoDbm == cellSignalStrengthCdma.mEvdoDbm && this.mEvdoEcio == cellSignalStrengthCdma.mEvdoEcio && this.mEvdoSnr == cellSignalStrengthCdma.mEvdoSnr) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getAsuLevel() {
        int n;
        int n2;
        int n3 = this.getCdmaDbm();
        int n4 = n3 >= -75 ? 16 : (n3 >= -82 ? 8 : (n3 >= -90 ? 4 : (n3 >= -95 ? 2 : (n3 >= -100 ? 1 : 99))));
        if (n4 < (n2 = (n = this.getCdmaEcio()) >= -90 ? 16 : (n >= -100 ? 8 : (n >= -115 ? 4 : (n >= -130 ? 2 : (n >= -150 ? 1 : 99)))))) {
            return n4;
        }
        return n2;
    }

    public int getCdmaDbm() {
        return this.mCdmaDbm;
    }

    public int getCdmaEcio() {
        return this.mCdmaEcio;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getCdmaLevel() {
        int n;
        int n2;
        int n3 = this.getCdmaDbm();
        int n4 = n3 >= -75 ? 4 : (n3 >= -85 ? 3 : (n3 >= -95 ? 2 : (n3 >= -100 ? 1 : 0)));
        if (n4 < (n2 = (n = this.getCdmaEcio()) >= -90 ? 4 : (n >= -110 ? 3 : (n >= -130 ? 2 : (n >= -150 ? 1 : 0))))) {
            return n4;
        }
        return n2;
    }

    @Override
    public int getDbm() {
        int n;
        int n2 = this.getCdmaDbm();
        if (n2 < (n = this.getEvdoDbm())) {
            return n2;
        }
        return n;
    }

    public int getEvdoDbm() {
        return this.mEvdoDbm;
    }

    public int getEvdoEcio() {
        return this.mEvdoEcio;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getEvdoLevel() {
        int n;
        int n2;
        int n3 = this.getEvdoDbm();
        int n4 = n3 >= -65 ? 4 : (n3 >= -75 ? 3 : (n3 >= -90 ? 2 : (n3 >= -105 ? 1 : 0)));
        if (n4 < (n2 = (n = this.getEvdoSnr()) >= 7 ? 4 : (n >= 5 ? 3 : (n >= 3 ? 2 : (n >= 1 ? 1 : 0))))) {
            return n4;
        }
        return n2;
    }

    public int getEvdoSnr() {
        return this.mEvdoSnr;
    }

    @Override
    public int getLevel() {
        int n = this.getCdmaLevel();
        int n2 = this.getEvdoLevel();
        if (n2 == 0) {
            return this.getCdmaLevel();
        }
        if (n == 0) {
            return this.getEvdoLevel();
        }
        if (n < n2) {
            return n;
        }
        return n2;
    }

    @Override
    public int hashCode() {
        return 31 * this.mCdmaDbm + 31 * this.mCdmaEcio + 31 * this.mEvdoDbm + 31 * this.mEvdoEcio + 31 * this.mEvdoSnr;
    }

    public void initialize(int n, int n2, int n3, int n4, int n5) {
        this.mCdmaDbm = n;
        this.mCdmaEcio = n2;
        this.mEvdoDbm = n3;
        this.mEvdoEcio = n4;
        this.mEvdoSnr = n5;
    }

    public void setCdmaDbm(int n) {
        this.mCdmaDbm = n;
    }

    public void setCdmaEcio(int n) {
        this.mCdmaEcio = n;
    }

    @Override
    public void setDefaultValues() {
        this.mCdmaDbm = Integer.MAX_VALUE;
        this.mCdmaEcio = Integer.MAX_VALUE;
        this.mEvdoDbm = Integer.MAX_VALUE;
        this.mEvdoEcio = Integer.MAX_VALUE;
        this.mEvdoSnr = Integer.MAX_VALUE;
    }

    public void setEvdoDbm(int n) {
        this.mEvdoDbm = n;
    }

    public void setEvdoEcio(int n) {
        this.mEvdoEcio = n;
    }

    public void setEvdoSnr(int n) {
        this.mEvdoSnr = n;
    }

    public String toString() {
        return "CellSignalStrengthCdma: cdmaDbm=" + this.mCdmaDbm + " cdmaEcio=" + this.mCdmaEcio + " evdoDbm=" + this.mEvdoDbm + " evdoEcio=" + this.mEvdoEcio + " evdoSnr=" + this.mEvdoSnr;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(-1 * this.mCdmaDbm);
        parcel.writeInt(-1 * this.mCdmaEcio);
        parcel.writeInt(-1 * this.mEvdoDbm);
        parcel.writeInt(-1 * this.mEvdoEcio);
        parcel.writeInt(this.mEvdoSnr);
    }
}

