/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;

public abstract class CellInfo
implements Parcelable {
    public static final Parcelable.Creator<CellInfo> CREATOR = new Parcelable.Creator<CellInfo>(){

        @Override
        public CellInfo createFromParcel(Parcel parcel) {
            switch (parcel.readInt()) {
                default: {
                    throw new RuntimeException("Bad CellInfo Parcel");
                }
                case 1: {
                    return CellInfoGsm.createFromParcelBody(parcel);
                }
                case 2: {
                    return CellInfoCdma.createFromParcelBody(parcel);
                }
                case 3: {
                    return CellInfoLte.createFromParcelBody(parcel);
                }
                case 4: 
            }
            return CellInfoWcdma.createFromParcelBody(parcel);
        }

        public CellInfo[] newArray(int n) {
            return new CellInfo[n];
        }
    };
    public static final int TIMESTAMP_TYPE_ANTENNA = 1;
    public static final int TIMESTAMP_TYPE_JAVA_RIL = 4;
    public static final int TIMESTAMP_TYPE_MODEM = 2;
    public static final int TIMESTAMP_TYPE_OEM_RIL = 3;
    public static final int TIMESTAMP_TYPE_UNKNOWN = 0;
    protected static final int TYPE_CDMA = 2;
    protected static final int TYPE_GSM = 1;
    protected static final int TYPE_LTE = 3;
    protected static final int TYPE_WCDMA = 4;
    private boolean mRegistered;
    private long mTimeStamp;
    private int mTimeStampType;

    protected CellInfo() {
        this.mRegistered = false;
        this.mTimeStampType = 0;
        this.mTimeStamp = Long.MAX_VALUE;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected CellInfo(Parcel parcel) {
        int n = 1;
        if (parcel.readInt() != n) {
            n = 0;
        }
        this.mRegistered = n;
        this.mTimeStampType = parcel.readInt();
        this.mTimeStamp = parcel.readLong();
    }

    protected CellInfo(CellInfo cellInfo) {
        this.mRegistered = cellInfo.mRegistered;
        this.mTimeStampType = cellInfo.mTimeStampType;
        this.mTimeStamp = cellInfo.mTimeStamp;
    }

    private static String timeStampTypeToString(int n) {
        switch (n) {
            default: {
                return "unknown";
            }
            case 1: {
                return "antenna";
            }
            case 2: {
                return "modem";
            }
            case 3: {
                return "oem_ril";
            }
            case 4: 
        }
        return "java_ril";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return bl;
        }
        try {
            CellInfo cellInfo = (CellInfo)object;
            if (this.mRegistered != cellInfo.mRegistered) return false;
            if (this.mTimeStamp != cellInfo.mTimeStamp) return false;
            int n = this.mTimeStampType;
            int n2 = cellInfo.mTimeStampType;
            if (n != n2) return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return bl;
    }

    public long getTimeStamp() {
        return this.mTimeStamp;
    }

    public int getTimeStampType() {
        return this.mTimeStampType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        int n;
        if (this.mRegistered) {
            n = 0;
            return n * 31 + 31 * (int)(this.mTimeStamp / 1000L) + 31 * this.mTimeStampType;
        }
        n = 1;
        return n * 31 + 31 * (int)(this.mTimeStamp / 1000L) + 31 * this.mTimeStampType;
    }

    public boolean isRegistered() {
        return this.mRegistered;
    }

    public void setRegistered(boolean bl) {
        this.mRegistered = bl;
    }

    public void setTimeStamp(long l) {
        this.mTimeStamp = l;
    }

    public void setTimeStampType(int n) {
        if (n < 0 || n > 4) {
            this.mTimeStampType = 0;
            return;
        }
        this.mTimeStampType = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = stringBuffer.append("mRegistered=");
        String string2 = this.mRegistered ? "YES" : "NO";
        stringBuffer2.append(string2);
        String string3 = CellInfo.timeStampTypeToString(this.mTimeStampType);
        stringBuffer.append(" mTimeStampType=").append(string3);
        stringBuffer.append(" mTimeStamp=").append(this.mTimeStamp).append("ns");
        return stringBuffer.toString();
    }

    @Override
    public abstract void writeToParcel(Parcel var1, int var2);

    /*
     * Enabled aggressive block sorting
     */
    protected void writeToParcel(Parcel parcel, int n, int n2) {
        parcel.writeInt(n2);
        int n3 = this.mRegistered ? 1 : 0;
        parcel.writeInt(n3);
        parcel.writeInt(this.mTimeStampType);
        parcel.writeLong(this.mTimeStamp);
    }
}

