/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Parcel;
import android.os.Parcelable;

public class VideoProfile
implements Parcelable {
    public static final Parcelable.Creator<VideoProfile> CREATOR = new Parcelable.Creator<VideoProfile>(){

        @Override
        public VideoProfile createFromParcel(Parcel parcel) {
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            VideoProfile.class.getClassLoader();
            return new VideoProfile(n, n2);
        }

        public VideoProfile[] newArray(int n) {
            return new VideoProfile[n];
        }
    };
    public static final int QUALITY_DEFAULT = 4;
    public static final int QUALITY_HIGH = 1;
    public static final int QUALITY_LOW = 3;
    public static final int QUALITY_MEDIUM = 2;
    public static final int QUALITY_UNKNOWN;
    private final int mQuality;
    private final int mVideoState;

    public VideoProfile(int n) {
        this(n, 4);
    }

    public VideoProfile(int n, int n2) {
        this.mVideoState = n;
        this.mQuality = n2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getQuality() {
        return this.mQuality;
    }

    public int getVideoState() {
        return this.mVideoState;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mVideoState);
        parcel.writeInt(this.mQuality);
    }

    public static class VideoState {
        public static final int AUDIO_ONLY = 0;
        public static final int BIDIRECTIONAL = 3;
        public static final int PAUSED = 4;
        public static final int RX_ENABLED = 2;
        public static final int TX_ENABLED = 1;

        private static boolean hasState(int n, int n2) {
            return (n & n2) == n2;
        }

        public static boolean isAudioOnly(int n) {
            return !VideoState.hasState(n, 1) && !VideoState.hasState(n, 2);
        }

        public static boolean isBidirectional(int n) {
            return VideoState.hasState(n, 3);
        }

        public static boolean isPaused(int n) {
            return VideoState.hasState(n, 4);
        }

        public static boolean isReceptionEnabled(int n) {
            return VideoState.hasState(n, 2);
        }

        public static boolean isTransmissionEnabled(int n) {
            return VideoState.hasState(n, 1);
        }

        public static boolean isVideo(int n) {
            return VideoState.hasState(n, 1) || VideoState.hasState(n, 2) || VideoState.hasState(n, 3);
        }
    }
}

