/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.telecom.CameraCapabilities;
import android.telecom.InCallService;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.internal.os.SomeArgs;
import com.android.internal.telecom.IVideoCallback;
import com.android.internal.telecom.IVideoProvider;

public class VideoCallImpl
extends InCallService.VideoCall {
    private static final int MSG_CHANGE_CALL_DATA_USAGE = 5;
    private static final int MSG_CHANGE_CAMERA_CAPABILITIES = 6;
    private static final int MSG_CHANGE_PEER_DIMENSIONS = 4;
    private static final int MSG_CHANGE_VIDEO_QUALITY = 7;
    private static final int MSG_HANDLE_CALL_SESSION_EVENT = 3;
    private static final int MSG_RECEIVE_SESSION_MODIFY_REQUEST = 1;
    private static final int MSG_RECEIVE_SESSION_MODIFY_RESPONSE = 2;
    private final VideoCallListenerBinder mBinder;
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        @Override
        public void binderDied() {
            VideoCallImpl.this.mVideoProvider.asBinder().unlinkToDeath(this, 0);
        }
    };
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        @Override
        public void handleMessage(Message message) {
            if (VideoCallImpl.this.mVideoCallListener == null) {
                return;
            }
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    VideoCallImpl.this.mVideoCallListener.onSessionModifyRequestReceived((VideoProfile)message.obj);
                    return;
                }
                case 2: {
                    SomeArgs someArgs = (SomeArgs)message.obj;
                    try {
                        int n = (Integer)someArgs.arg1;
                        VideoProfile videoProfile = (VideoProfile)someArgs.arg2;
                        VideoProfile videoProfile2 = (VideoProfile)someArgs.arg3;
                        VideoCallImpl.this.mVideoCallListener.onSessionModifyResponseReceived(n, videoProfile, videoProfile2);
                        return;
                    }
                    finally {
                        someArgs.recycle();
                    }
                }
                case 3: {
                    VideoCallImpl.this.mVideoCallListener.onCallSessionEvent((Integer)message.obj);
                    return;
                }
                case 4: {
                    SomeArgs someArgs = (SomeArgs)message.obj;
                    try {
                        int n = (Integer)someArgs.arg1;
                        int n2 = (Integer)someArgs.arg2;
                        VideoCallImpl.this.mVideoCallListener.onPeerDimensionsChanged(n, n2);
                        return;
                    }
                    finally {
                        someArgs.recycle();
                    }
                }
                case 5: {
                    VideoCallImpl.this.mVideoCallListener.onCallDataUsageChanged((Long)message.obj);
                    return;
                }
                case 6: {
                    VideoCallImpl.this.mVideoCallListener.onCameraCapabilitiesChanged((CameraCapabilities)message.obj);
                    return;
                }
                case 7: 
            }
            VideoCallImpl.this.mVideoCallListener.onVideoQualityChanged(message.arg1);
        }
    };
    private InCallService.VideoCall.Listener mVideoCallListener;
    private final IVideoProvider mVideoProvider;

    VideoCallImpl(IVideoProvider iVideoProvider) throws RemoteException {
        this.mVideoProvider = iVideoProvider;
        this.mVideoProvider.asBinder().linkToDeath(this.mDeathRecipient, 0);
        this.mBinder = new VideoCallListenerBinder();
        this.mVideoProvider.setVideoCallback(this.mBinder);
    }

    @Override
    public void requestCallDataUsage() {
        try {
            this.mVideoProvider.requestCallDataUsage();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void requestCameraCapabilities() {
        try {
            this.mVideoProvider.requestCameraCapabilities();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void sendSessionModifyRequest(VideoProfile videoProfile) {
        try {
            this.mVideoProvider.sendSessionModifyRequest(videoProfile);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void sendSessionModifyResponse(VideoProfile videoProfile) {
        try {
            this.mVideoProvider.sendSessionModifyResponse(videoProfile);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void setCamera(String string2) {
        try {
            this.mVideoProvider.setCamera(string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void setDeviceOrientation(int n) {
        try {
            this.mVideoProvider.setDeviceOrientation(n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void setDisplaySurface(Surface surface) {
        try {
            this.mVideoProvider.setDisplaySurface(surface);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void setPauseImage(String string2) {
        try {
            this.mVideoProvider.setPauseImage(string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void setPreviewSurface(Surface surface) {
        try {
            this.mVideoProvider.setPreviewSurface(surface);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void setVideoCallListener(InCallService.VideoCall.Listener listener) {
        this.mVideoCallListener = listener;
    }

    @Override
    public void setZoom(float f) {
        try {
            this.mVideoProvider.setZoom(f);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    private final class VideoCallListenerBinder
    extends IVideoCallback.Stub {
        private VideoCallListenerBinder() {
        }

        @Override
        public void changeCallDataUsage(long l) {
            VideoCallImpl.this.mHandler.obtainMessage(5, l).sendToTarget();
        }

        @Override
        public void changeCameraCapabilities(CameraCapabilities cameraCapabilities) {
            VideoCallImpl.this.mHandler.obtainMessage(6, cameraCapabilities).sendToTarget();
        }

        @Override
        public void changePeerDimensions(int n, int n2) {
            SomeArgs someArgs = SomeArgs.obtain();
            someArgs.arg1 = n;
            someArgs.arg2 = n2;
            VideoCallImpl.this.mHandler.obtainMessage(4, someArgs).sendToTarget();
        }

        @Override
        public void changeVideoQuality(int n) {
            VideoCallImpl.this.mHandler.obtainMessage(7, n, 0).sendToTarget();
        }

        @Override
        public void handleCallSessionEvent(int n) {
            VideoCallImpl.this.mHandler.obtainMessage(3, n).sendToTarget();
        }

        @Override
        public void receiveSessionModifyRequest(VideoProfile videoProfile) {
            VideoCallImpl.this.mHandler.obtainMessage(1, videoProfile).sendToTarget();
        }

        @Override
        public void receiveSessionModifyResponse(int n, VideoProfile videoProfile, VideoProfile videoProfile2) {
            SomeArgs someArgs = SomeArgs.obtain();
            someArgs.arg1 = n;
            someArgs.arg2 = videoProfile;
            someArgs.arg3 = videoProfile2;
            VideoCallImpl.this.mHandler.obtainMessage(2, someArgs).sendToTarget();
        }
    }
}

