/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.telecom.DisconnectCause;
import android.telecom.GatewayInfo;
import android.telecom.InCallService;
import android.telecom.PhoneAccountHandle;
import android.telecom.StatusHints;
import android.telecom.VideoCallImpl;
import com.android.internal.telecom.IVideoProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ParcelableCall
implements Parcelable {
    public static final Parcelable.Creator<ParcelableCall> CREATOR = new Parcelable.Creator<ParcelableCall>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public ParcelableCall createFromParcel(Parcel parcel) {
            boolean bl;
            ClassLoader classLoader = ParcelableCall.class.getClassLoader();
            String string2 = parcel.readString();
            int n = parcel.readInt();
            DisconnectCause disconnectCause = (DisconnectCause)parcel.readParcelable(classLoader);
            ArrayList<String> arrayList = new ArrayList<String>();
            parcel.readList(arrayList, classLoader);
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            long l = parcel.readLong();
            Uri uri = (Uri)parcel.readParcelable(classLoader);
            int n4 = parcel.readInt();
            String string3 = parcel.readString();
            int n5 = parcel.readInt();
            GatewayInfo gatewayInfo = (GatewayInfo)parcel.readParcelable(classLoader);
            PhoneAccountHandle phoneAccountHandle = (PhoneAccountHandle)parcel.readParcelable(classLoader);
            IVideoProvider iVideoProvider = IVideoProvider.Stub.asInterface(parcel.readStrongBinder());
            String string4 = parcel.readString();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            parcel.readList(arrayList2, classLoader);
            StatusHints statusHints = (StatusHints)parcel.readParcelable(classLoader);
            int n6 = parcel.readInt();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            parcel.readList(arrayList3, classLoader);
            Bundle bundle = (Bundle)parcel.readParcelable(classLoader);
            int n7 = parcel.readInt();
            int n8 = parcel.readInt();
            if (parcel.readInt() == 1) {
                bl = true;
                return new ParcelableCall(string2, n, disconnectCause, arrayList, n2, n3, l, uri, n4, string3, n5, gatewayInfo, phoneAccountHandle, iVideoProvider, string4, arrayList2, statusHints, n6, arrayList3, bundle, n7, n8, bl, parcel.readInt());
            }
            bl = false;
            return new ParcelableCall(string2, n, disconnectCause, arrayList, n2, n3, l, uri, n4, string3, n5, gatewayInfo, phoneAccountHandle, iVideoProvider, string4, arrayList2, statusHints, n6, arrayList3, bundle, n7, n8, bl, parcel.readInt());
        }

        public ParcelableCall[] newArray(int n) {
            return new ParcelableCall[n];
        }
    };
    private final PhoneAccountHandle mAccountHandle;
    private int mCallSubstate;
    private final String mCallerDisplayName;
    private final int mCallerDisplayNamePresentation;
    private final List<String> mCannedSmsResponses;
    private final int mCapabilities;
    private final List<String> mChildCallIds;
    private int mCode;
    private final List<String> mConferenceableCallIds;
    private final long mConnectTimeMillis;
    private final DisconnectCause mDisconnectCause;
    private final Bundle mExtras;
    private final GatewayInfo mGatewayInfo;
    private final Uri mHandle;
    private final int mHandlePresentation;
    private final String mId;
    boolean mIsActiveSub;
    private int mNotificationType;
    private final String mParentCallId;
    private final int mProperties;
    private final int mState;
    private final StatusHints mStatusHints;
    private InCallService.VideoCall mVideoCall;
    private final IVideoProvider mVideoCallProvider;
    private final int mVideoState;

    public ParcelableCall(String string2, int n, DisconnectCause disconnectCause, List<String> list, int n2, int n3, long l, Uri uri, int n4, String string3, int n5, GatewayInfo gatewayInfo, PhoneAccountHandle phoneAccountHandle, IVideoProvider iVideoProvider, String string4, List<String> list2, StatusHints statusHints, int n6, List<String> list3, Bundle bundle, int n7, int n8, boolean bl, int n9) {
        this.mId = string2;
        this.mState = n;
        this.mDisconnectCause = disconnectCause;
        this.mCannedSmsResponses = list;
        this.mCapabilities = n2;
        this.mProperties = n3;
        this.mConnectTimeMillis = l;
        this.mHandle = uri;
        this.mHandlePresentation = n4;
        this.mCallerDisplayName = string3;
        this.mCallerDisplayNamePresentation = n5;
        this.mGatewayInfo = gatewayInfo;
        this.mAccountHandle = phoneAccountHandle;
        this.mVideoCallProvider = iVideoProvider;
        this.mParentCallId = string4;
        this.mChildCallIds = list2;
        this.mStatusHints = statusHints;
        this.mVideoState = n6;
        this.mConferenceableCallIds = Collections.unmodifiableList(list3);
        this.mExtras = bundle;
        this.mNotificationType = n7;
        this.mCode = n8;
        this.mIsActiveSub = bl;
        this.mCallSubstate = n9;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public PhoneAccountHandle getAccountHandle() {
        return this.mAccountHandle;
    }

    public int getCallSubstate() {
        return this.mCallSubstate;
    }

    public String getCallerDisplayName() {
        return this.mCallerDisplayName;
    }

    public int getCallerDisplayNamePresentation() {
        return this.mCallerDisplayNamePresentation;
    }

    public List<String> getCannedSmsResponses() {
        return this.mCannedSmsResponses;
    }

    public int getCapabilities() {
        return this.mCapabilities;
    }

    public List<String> getChildCallIds() {
        return this.mChildCallIds;
    }

    public List<String> getConferenceableCallIds() {
        return this.mConferenceableCallIds;
    }

    public long getConnectTimeMillis() {
        return this.mConnectTimeMillis;
    }

    public DisconnectCause getDisconnectCause() {
        return this.mDisconnectCause;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public GatewayInfo getGatewayInfo() {
        return this.mGatewayInfo;
    }

    public Uri getHandle() {
        return this.mHandle;
    }

    public int getHandlePresentation() {
        return this.mHandlePresentation;
    }

    public String getId() {
        return this.mId;
    }

    public int getNotificationCode() {
        return this.mCode;
    }

    public int getNotificationType() {
        return this.mNotificationType;
    }

    public String getParentCallId() {
        return this.mParentCallId;
    }

    public int getProperties() {
        return this.mProperties;
    }

    public int getState() {
        return this.mState;
    }

    public StatusHints getStatusHints() {
        return this.mStatusHints;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InCallService.VideoCall getVideoCall() {
        if (this.mVideoCall != null) return this.mVideoCall;
        if (this.mVideoCallProvider == null) return this.mVideoCall;
        try {
            this.mVideoCall = new VideoCallImpl(this.mVideoCallProvider);
            return this.mVideoCall;
        }
        catch (RemoteException remoteException) {
            return this.mVideoCall;
        }
    }

    public int getVideoState() {
        return this.mVideoState;
    }

    public String toString() {
        Object[] objectArray = new Object[]{this.mId, this.mParentCallId, this.mChildCallIds};
        return String.format("[%s, parent:%s, children:%s]", objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mId);
        parcel.writeInt(this.mState);
        parcel.writeParcelable(this.mDisconnectCause, 0);
        parcel.writeList(this.mCannedSmsResponses);
        parcel.writeInt(this.mCapabilities);
        parcel.writeInt(this.mProperties);
        parcel.writeLong(this.mConnectTimeMillis);
        parcel.writeParcelable(this.mHandle, 0);
        parcel.writeInt(this.mHandlePresentation);
        parcel.writeString(this.mCallerDisplayName);
        parcel.writeInt(this.mCallerDisplayNamePresentation);
        parcel.writeParcelable(this.mGatewayInfo, 0);
        parcel.writeParcelable(this.mAccountHandle, 0);
        IBinder iBinder = this.mVideoCallProvider != null ? this.mVideoCallProvider.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
        parcel.writeString(this.mParentCallId);
        parcel.writeList(this.mChildCallIds);
        parcel.writeParcelable(this.mStatusHints, 0);
        parcel.writeInt(this.mVideoState);
        parcel.writeList(this.mConferenceableCallIds);
        parcel.writeParcelable(this.mExtras, 0);
        parcel.writeInt(this.mNotificationType);
        parcel.writeInt(this.mCode);
        int n2 = this.mIsActiveSub ? 1 : 0;
        parcel.writeInt(n2);
        parcel.writeInt(this.mCallSubstate);
    }
}

