/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.app.Service;
import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.telecom.AudioState;
import android.telecom.Conference;
import android.telecom.Connection;
import android.telecom.ConnectionRequest;
import android.telecom.ConnectionServiceAdapter;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.ParcelableConference;
import android.telecom.ParcelableConnection;
import android.telecom.PhoneAccountHandle;
import android.telecom.PhoneCapabilities;
import android.telecom.RemoteConference;
import android.telecom.RemoteConnection;
import android.telecom.RemoteConnectionManager;
import android.telecom.StatusHints;
import com.android.internal.os.SomeArgs;
import com.android.internal.telecom.IConnectionService;
import com.android.internal.telecom.IConnectionServiceAdapter;
import com.android.internal.telecom.IVideoProvider;
import com.android.internal.telecom.RemoteServiceCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ConnectionService
extends Service {
    private static final int MSG_ABORT = 3;
    private static final int MSG_ADD_CONNECTION_SERVICE_ADAPTER = 1;
    private static final int MSG_ANSWER = 4;
    private static final int MSG_ANSWER_VIDEO = 17;
    private static final int MSG_CONFERENCE = 12;
    private static final int MSG_CREATE_CONNECTION = 2;
    private static final int MSG_DEFLECT = 22;
    private static final int MSG_DISCONNECT = 6;
    private static final int MSG_HOLD = 7;
    private static final int MSG_MERGE_CONFERENCE = 18;
    private static final int MSG_ON_AUDIO_STATE_CHANGED = 9;
    private static final int MSG_ON_POST_DIAL_CONTINUE = 14;
    private static final int MSG_PLAY_DTMF_TONE = 10;
    private static final int MSG_REJECT = 5;
    private static final int MSG_REMOVE_CONNECTION_SERVICE_ADAPTER = 16;
    private static final int MSG_SET_ACTIVE_SUB = 21;
    private static final int MSG_SET_LOCAL_HOLD = 20;
    private static final int MSG_SPLIT_FROM_CONFERENCE = 13;
    private static final int MSG_STOP_DTMF_TONE = 11;
    private static final int MSG_SWAP_CONFERENCE = 19;
    private static final int MSG_UNHOLD = 8;
    private static final boolean PII_DEBUG = false;
    public static final String SERVICE_INTERFACE = "android.telecom.ConnectionService";
    private static Connection sNullConnection;
    private final ConnectionServiceAdapter mAdapter;
    private boolean mAreAccountsInitialized = false;
    private final IBinder mBinder;
    private final Map<String, Conference> mConferenceById;
    private final Conference.Listener mConferenceListener;
    private final Map<String, Connection> mConnectionById = new ConcurrentHashMap<String, Connection>();
    private final Connection.Listener mConnectionListener;
    private final Handler mHandler;
    private final Map<Conference, String> mIdByConference;
    private final Map<Connection, String> mIdByConnection = new ConcurrentHashMap<Connection, String>();
    private final List<Runnable> mPreInitializationConnectionRequests;
    private final RemoteConnectionManager mRemoteConnectionManager;
    private int mSsNotificationCode = 255;
    private int mSsNotificationType = 255;
    private Conference sNullConference;

    static {
        PII_DEBUG = Log.isLoggable(3);
    }

    public ConnectionService() {
        this.mConferenceById = new ConcurrentHashMap<String, Conference>();
        this.mIdByConference = new ConcurrentHashMap<Conference, String>();
        this.mRemoteConnectionManager = new RemoteConnectionManager(this);
        this.mPreInitializationConnectionRequests = new ArrayList<Runnable>();
        this.mAdapter = new ConnectionServiceAdapter();
        this.mBinder = new IConnectionService.Stub(){

            @Override
            public void abort(String string2) {
                ConnectionService.this.mHandler.obtainMessage(3, string2).sendToTarget();
            }

            @Override
            public void addConnectionServiceAdapter(IConnectionServiceAdapter iConnectionServiceAdapter) {
                ConnectionService.this.mHandler.obtainMessage(1, iConnectionServiceAdapter).sendToTarget();
            }

            @Override
            public void answer(String string2) {
                ConnectionService.this.mHandler.obtainMessage(4, string2).sendToTarget();
            }

            @Override
            public void answerVideo(String string2, int n) {
                SomeArgs someArgs = SomeArgs.obtain();
                someArgs.arg1 = string2;
                someArgs.argi1 = n;
                ConnectionService.this.mHandler.obtainMessage(17, someArgs).sendToTarget();
            }

            @Override
            public void conference(String string2, String string3) {
                SomeArgs someArgs = SomeArgs.obtain();
                someArgs.arg1 = string2;
                someArgs.arg2 = string3;
                ConnectionService.this.mHandler.obtainMessage(12, someArgs).sendToTarget();
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void createConnection(PhoneAccountHandle phoneAccountHandle, String string2, ConnectionRequest connectionRequest, boolean bl, boolean bl2) {
                int n = 1;
                SomeArgs someArgs = SomeArgs.obtain();
                someArgs.arg1 = phoneAccountHandle;
                someArgs.arg2 = string2;
                someArgs.arg3 = connectionRequest;
                int n2 = bl ? n : 0;
                someArgs.argi1 = n2;
                if (!bl2) {
                    n = 0;
                }
                someArgs.argi2 = n;
                ConnectionService.this.mHandler.obtainMessage(2, someArgs).sendToTarget();
            }

            @Override
            public void deflect(String string2, String string3) {
                SomeArgs someArgs = SomeArgs.obtain();
                someArgs.arg1 = string2;
                someArgs.arg2 = string3;
                ConnectionService.this.mHandler.obtainMessage(22, someArgs).sendToTarget();
            }

            @Override
            public void disconnect(String string2) {
                ConnectionService.this.mHandler.obtainMessage(6, string2).sendToTarget();
            }

            @Override
            public void hold(String string2) {
                ConnectionService.this.mHandler.obtainMessage(7, string2).sendToTarget();
            }

            @Override
            public void mergeConference(String string2) {
                ConnectionService.this.mHandler.obtainMessage(18, string2).sendToTarget();
            }

            @Override
            public void onAudioStateChanged(String string2, AudioState audioState) {
                SomeArgs someArgs = SomeArgs.obtain();
                someArgs.arg1 = string2;
                someArgs.arg2 = audioState;
                ConnectionService.this.mHandler.obtainMessage(9, someArgs).sendToTarget();
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onPostDialContinue(String string2, boolean bl) {
                SomeArgs someArgs = SomeArgs.obtain();
                someArgs.arg1 = string2;
                int n = bl ? 1 : 0;
                someArgs.argi1 = n;
                ConnectionService.this.mHandler.obtainMessage(14, someArgs).sendToTarget();
            }

            @Override
            public void playDtmfTone(String string2, char c) {
                ConnectionService.this.mHandler.obtainMessage(10, c, 0, string2).sendToTarget();
            }

            @Override
            public void reject(String string2) {
                ConnectionService.this.mHandler.obtainMessage(5, string2).sendToTarget();
            }

            @Override
            public void removeConnectionServiceAdapter(IConnectionServiceAdapter iConnectionServiceAdapter) {
                ConnectionService.this.mHandler.obtainMessage(16, iConnectionServiceAdapter).sendToTarget();
            }

            @Override
            public void setActiveSubscription(String string2) {
                Log.i(this, "setActiveSubscription %s", string2);
                ConnectionService.this.mHandler.obtainMessage(21, string2).sendToTarget();
            }

            @Override
            public void setLocalCallHold(String string2, int n) {
                SomeArgs someArgs = SomeArgs.obtain();
                someArgs.arg1 = string2;
                someArgs.argi1 = n;
                ConnectionService.this.mHandler.obtainMessage(20, someArgs).sendToTarget();
            }

            @Override
            public void splitFromConference(String string2) {
                ConnectionService.this.mHandler.obtainMessage(13, string2).sendToTarget();
            }

            @Override
            public void stopDtmfTone(String string2) {
                ConnectionService.this.mHandler.obtainMessage(11, string2).sendToTarget();
            }

            @Override
            public void swapConference(String string2) {
                ConnectionService.this.mHandler.obtainMessage(19, string2).sendToTarget();
            }

            @Override
            public void unhold(String string2) {
                ConnectionService.this.mHandler.obtainMessage(8, string2).sendToTarget();
            }
        };
        this.mHandler = new Handler(Looper.getMainLooper()){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        ConnectionService.this.mAdapter.addAdapter((IConnectionServiceAdapter)message.obj);
                        ConnectionService.this.onAdapterAttached();
                        return;
                    }
                    case 16: {
                        ConnectionService.this.mAdapter.removeAdapter((IConnectionServiceAdapter)message.obj);
                        return;
                    }
                    case 2: {
                        SomeArgs someArgs = (SomeArgs)message.obj;
                        final PhoneAccountHandle phoneAccountHandle = (PhoneAccountHandle)someArgs.arg1;
                        final String string2 = (String)someArgs.arg2;
                        final ConnectionRequest connectionRequest = (ConnectionRequest)someArgs.arg3;
                        final boolean bl = someArgs.argi1 == 1;
                        final boolean bl2 = someArgs.argi2 == 1;
                        if (!ConnectionService.this.mAreAccountsInitialized) {
                            Log.d(this, "Enqueueing pre-init request %s", string2);
                            ConnectionService.this.mPreInitializationConnectionRequests.add(new Runnable(){

                                @Override
                                public void run() {
                                    ConnectionService.this.createConnection(phoneAccountHandle, string2, connectionRequest, bl, bl2);
                                }
                            });
                            return;
                        }
                        ConnectionService.this.createConnection(phoneAccountHandle, string2, connectionRequest, bl, bl2);
                        return;
                    }
                    case 3: {
                        ConnectionService.this.abort((String)message.obj);
                        return;
                    }
                    case 4: {
                        ConnectionService.this.answer((String)message.obj);
                        return;
                    }
                    case 17: {
                        SomeArgs someArgs = (SomeArgs)message.obj;
                        try {
                            String string3 = (String)someArgs.arg1;
                            int n = someArgs.argi1;
                            ConnectionService.this.answerVideo(string3, n);
                            return;
                        }
                        finally {
                            someArgs.recycle();
                        }
                    }
                    case 5: {
                        ConnectionService.this.reject((String)message.obj);
                        return;
                    }
                    case 6: {
                        ConnectionService.this.disconnect((String)message.obj);
                        return;
                    }
                    case 7: {
                        ConnectionService.this.hold((String)message.obj);
                        return;
                    }
                    case 8: {
                        ConnectionService.this.unhold((String)message.obj);
                        return;
                    }
                    case 9: {
                        SomeArgs someArgs = (SomeArgs)message.obj;
                        try {
                            String string4 = (String)someArgs.arg1;
                            AudioState audioState = (AudioState)someArgs.arg2;
                            ConnectionService.this.onAudioStateChanged(string4, audioState);
                            return;
                        }
                        finally {
                            someArgs.recycle();
                        }
                    }
                    case 10: {
                        ConnectionService.this.playDtmfTone((String)message.obj, (char)message.arg1);
                        return;
                    }
                    case 11: {
                        ConnectionService.this.stopDtmfTone((String)message.obj);
                        return;
                    }
                    case 20: {
                        SomeArgs someArgs = (SomeArgs)message.obj;
                        try {
                            String string5 = (String)someArgs.arg1;
                            int n = someArgs.argi1;
                            ConnectionService.this.setLocalCallHold(string5, n);
                            return;
                        }
                        finally {
                            someArgs.recycle();
                        }
                    }
                    case 21: {
                        ConnectionService.this.setActiveSubscription((String)message.obj);
                        return;
                    }
                    case 12: {
                        SomeArgs someArgs = (SomeArgs)message.obj;
                        try {
                            String string6 = (String)someArgs.arg1;
                            String string7 = (String)someArgs.arg2;
                            ConnectionService.this.conference(string6, string7);
                            return;
                        }
                        finally {
                            someArgs.recycle();
                        }
                    }
                    case 13: {
                        ConnectionService.this.splitFromConference((String)message.obj);
                        return;
                    }
                    case 18: {
                        ConnectionService.this.mergeConference((String)message.obj);
                        return;
                    }
                    case 19: {
                        ConnectionService.this.swapConference((String)message.obj);
                        return;
                    }
                    case 14: {
                        SomeArgs someArgs = (SomeArgs)message.obj;
                        try {
                            String string8 = (String)someArgs.arg1;
                            boolean bl = someArgs.argi1 == 1;
                            ConnectionService.this.onPostDialContinue(string8, bl);
                            someArgs.recycle();
                            return;
                        }
                        catch (Throwable throwable) {
                            someArgs.recycle();
                            throw throwable;
                        }
                    }
                    case 22: 
                }
                SomeArgs someArgs = (SomeArgs)message.obj;
                try {
                    String string9 = (String)someArgs.arg1;
                    String string10 = (String)someArgs.arg2;
                    ConnectionService.this.deflect(string9, string10);
                    return;
                }
                finally {
                    someArgs.recycle();
                }
            }
        };
        this.mConferenceListener = new Conference.Listener(){

            @Override
            public void onCapabilitiesChanged(Conference conference, int n) {
                String string2 = (String)ConnectionService.this.mIdByConference.get(conference);
                Object[] objectArray = new Object[]{PhoneCapabilities.toString(n)};
                Log.d(this, "call capabilities: conference: %s", objectArray);
                ConnectionService.this.mAdapter.setCallCapabilities(string2, n);
            }

            @Override
            public void onConferenceableConnectionsChanged(Conference conference, List<Connection> list) {
                ConnectionService.this.mAdapter.setConferenceableConnections((String)ConnectionService.this.mIdByConference.get(conference), ConnectionService.this.createConnectionIdList(list));
            }

            @Override
            public void onConnectionAdded(Conference conference, Connection connection) {
            }

            @Override
            public void onConnectionRemoved(Conference conference, Connection connection) {
            }

            @Override
            public void onDestroyed(Conference conference) {
                ConnectionService.this.removeConference(conference);
            }

            @Override
            public void onDisconnected(Conference conference, DisconnectCause disconnectCause) {
                String string2 = (String)ConnectionService.this.mIdByConference.get(conference);
                ConnectionService.this.mAdapter.setDisconnected(string2, disconnectCause);
            }

            @Override
            public void onStateChanged(Conference conference, int n, int n2) {
                String string2 = (String)ConnectionService.this.mIdByConference.get(conference);
                switch (n2) {
                    default: {
                        return;
                    }
                    case 4: {
                        ConnectionService.this.mAdapter.setActive(string2);
                        return;
                    }
                    case 5: 
                }
                ConnectionService.this.mAdapter.setOnHold(string2);
            }
        };
        this.mConnectionListener = new Connection.Listener(){

            @Override
            public void onAddressChanged(Connection connection, Uri uri, int n) {
                String string2 = (String)ConnectionService.this.mIdByConnection.get(connection);
                ConnectionService.this.mAdapter.setAddress(string2, uri, n);
            }

            @Override
            public void onAudioModeIsVoipChanged(Connection connection, boolean bl) {
                String string2 = (String)ConnectionService.this.mIdByConnection.get(connection);
                ConnectionService.this.mAdapter.setIsVoipAudioMode(string2, bl);
            }

            @Override
            public void onCallCapabilitiesChanged(Connection connection, int n) {
                String string2 = (String)ConnectionService.this.mIdByConnection.get(connection);
                Object[] objectArray = new Object[]{PhoneCapabilities.toString(n)};
                Log.d(this, "capabilities: parcelableconnection: %s", objectArray);
                ConnectionService.this.mAdapter.setCallCapabilities(string2, n);
            }

            @Override
            public void onCallSubstateChanged(Connection connection, int n) {
                String string2 = (String)ConnectionService.this.mIdByConnection.get(connection);
                Object[] objectArray = new Object[]{n};
                Log.d(this, "Adapter set call substate %d", objectArray);
                ConnectionService.this.mAdapter.setCallSubstate(string2, n);
            }

            @Override
            public void onCallerDisplayNameChanged(Connection connection, String string2, int n) {
                String string3 = (String)ConnectionService.this.mIdByConnection.get(connection);
                ConnectionService.this.mAdapter.setCallerDisplayName(string3, string2, n);
            }

            @Override
            public void onConferenceChanged(Connection connection, Conference conference) {
                String string2 = (String)ConnectionService.this.mIdByConnection.get(connection);
                if (string2 != null) {
                    String string3 = null;
                    if (conference != null) {
                        string3 = (String)ConnectionService.this.mIdByConference.get(conference);
                    }
                    ConnectionService.this.mAdapter.setIsConferenced(string2, string3);
                }
            }

            @Override
            public void onConferenceableConnectionsChanged(Connection connection, List<Connection> list) {
                ConnectionService.this.mAdapter.setConferenceableConnections((String)ConnectionService.this.mIdByConnection.get(connection), ConnectionService.this.createConnectionIdList(list));
            }

            @Override
            public void onDestroyed(Connection connection) {
                ConnectionService.this.removeConnection(connection);
            }

            @Override
            public void onDisconnected(Connection connection, DisconnectCause disconnectCause) {
                String string2 = (String)ConnectionService.this.mIdByConnection.get(connection);
                Log.d(this, "Adapter set disconnected %s", disconnectCause);
                if (ConnectionService.this.mSsNotificationType == 255 && ConnectionService.this.mSsNotificationCode == 255) {
                    ConnectionService.this.mAdapter.setDisconnected(string2, disconnectCause);
                    return;
                }
                ConnectionService.this.mAdapter.setDisconnectedWithSsNotification(string2, disconnectCause.getCode(), disconnectCause.getReason(), ConnectionService.this.mSsNotificationType, ConnectionService.this.mSsNotificationCode);
                ConnectionService.access$2802(ConnectionService.this, 255);
                ConnectionService.access$2902(ConnectionService.this, 255);
            }

            @Override
            public void onPhoneAccountChanged(Connection connection, PhoneAccountHandle phoneAccountHandle) {
                String string2 = (String)ConnectionService.this.mIdByConnection.get(connection);
                Log.i(this, "Adapter onPhoneAccountChanged %s, %s", connection, phoneAccountHandle);
                ConnectionService.this.mAdapter.setPhoneAccountHandle(string2, phoneAccountHandle);
            }

            @Override
            public void onPostDialWait(Connection connection, String string2) {
                String string3 = (String)ConnectionService.this.mIdByConnection.get(connection);
                Log.d(this, "Adapter onPostDialWait %s, %s", connection, string2);
                ConnectionService.this.mAdapter.onPostDialWait(string3, string2);
            }

            @Override
            public void onRingbackRequested(Connection connection, boolean bl) {
                String string2 = (String)ConnectionService.this.mIdByConnection.get(connection);
                Object[] objectArray = new Object[]{bl};
                Log.d(this, "Adapter onRingback %b", objectArray);
                ConnectionService.this.mAdapter.setRingbackRequested(string2, bl);
            }

            @Override
            public void onSsNotificationData(int n, int n2) {
                ConnectionService.access$2802(ConnectionService.this, n);
                ConnectionService.access$2902(ConnectionService.this, n2);
            }

            @Override
            public void onStateChanged(Connection connection, int n) {
                String string2 = (String)ConnectionService.this.mIdByConnection.get(connection);
                Object[] objectArray = new Object[]{string2, Connection.stateToString(n)};
                Log.d(this, "Adapter set state %s %s", objectArray);
                switch (n) {
                    default: {
                        return;
                    }
                    case 4: {
                        ConnectionService.this.mAdapter.setActive(string2);
                        return;
                    }
                    case 3: {
                        ConnectionService.this.mAdapter.setDialing(string2);
                        return;
                    }
                    case 5: {
                        ConnectionService.this.mAdapter.setOnHold(string2);
                        return;
                    }
                    case 2: 
                }
                ConnectionService.this.mAdapter.setRinging(string2);
            }

            @Override
            public void onStatusHintsChanged(Connection connection, StatusHints statusHints) {
                String string2 = (String)ConnectionService.this.mIdByConnection.get(connection);
                ConnectionService.this.mAdapter.setStatusHints(string2, statusHints);
            }

            @Override
            public void onVideoProviderChanged(Connection connection, Connection.VideoProvider videoProvider) {
                String string2 = (String)ConnectionService.this.mIdByConnection.get(connection);
                ConnectionService.this.mAdapter.setVideoProvider(string2, videoProvider);
            }

            @Override
            public void onVideoStateChanged(Connection connection, int n) {
                String string2 = (String)ConnectionService.this.mIdByConnection.get(connection);
                Object[] objectArray = new Object[]{n};
                Log.d(this, "Adapter set video state %d", objectArray);
                ConnectionService.this.mAdapter.setVideoState(string2, n);
            }
        };
    }

    private void abort(String string2) {
        Log.d(this, "abort %s", string2);
        this.findConnectionForAction(string2, "abort").onAbort();
    }

    static /* synthetic */ int access$2802(ConnectionService connectionService, int n) {
        connectionService.mSsNotificationType = n;
        return n;
    }

    static /* synthetic */ int access$2902(ConnectionService connectionService, int n) {
        connectionService.mSsNotificationCode = n;
        return n;
    }

    static /* synthetic */ boolean access$302(ConnectionService connectionService, boolean bl) {
        connectionService.mAreAccountsInitialized = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String addConferenceInternal(Conference conference) {
        if (this.mIdByConference.containsKey(conference)) {
            Log.w(this, "Re-adding an existing conference: %s.", conference);
            return null;
        } else {
            if (conference == null) return null;
            String string2 = UUID.randomUUID().toString();
            this.mConferenceById.put(string2, conference);
            this.mIdByConference.put(conference, string2);
            conference.addListener(this.mConferenceListener);
            return string2;
        }
    }

    private void addConnection(String string2, Connection connection) {
        this.mConnectionById.put(string2, connection);
        this.mIdByConnection.put(connection, string2);
        connection.addConnectionListener(this.mConnectionListener);
        connection.setConnectionService(this);
    }

    private void answer(String string2) {
        Log.d(this, "answer %s", string2);
        this.findConnectionForAction(string2, "answer").onAnswer();
    }

    private void answerVideo(String string2, int n) {
        Log.d(this, "answerVideo %s", string2);
        this.findConnectionForAction(string2, "answer").onAnswer(n);
    }

    private void conference(String string2, String string3) {
        Log.d(this, "conference %s, %s", string2, string3);
        Connection connection = this.findConnectionForAction(string3, "conference");
        if (connection == ConnectionService.getNullConnection()) {
            Log.w(this, "Connection2 missing in conference request %s.", string3);
            return;
        }
        Connection connection2 = this.findConnectionForAction(string2, "conference");
        if (connection2 == ConnectionService.getNullConnection()) {
            Conference conference = this.findConferenceForAction(string2, "addConnection");
            if (conference == this.getNullConference()) {
                Log.w(this, "Connection1 or Conference1 missing in conference request %s.", string2);
                return;
            }
            conference.onMerge(connection);
            return;
        }
        this.onConference(connection2, connection);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createConnection(PhoneAccountHandle phoneAccountHandle, String string2, ConnectionRequest connectionRequest, boolean bl, boolean bl2) {
        Uri uri;
        Object[] objectArray = new Object[]{phoneAccountHandle, string2, connectionRequest, bl, bl2};
        Log.d(this, "createConnection, callManagerAccount: %s, callId: %s, request: %s, isIncoming: %b, isUnknown: %b", objectArray);
        Connection connection = bl2 ? this.onCreateUnknownConnection(phoneAccountHandle, connectionRequest) : (bl ? this.onCreateIncomingConnection(phoneAccountHandle, connectionRequest) : this.onCreateOutgoingConnection(phoneAccountHandle, connectionRequest));
        Log.d(this, "createConnection, connection: %s", connection);
        if (connection == null) {
            connection = Connection.createFailedConnection(new DisconnectCause(1));
        }
        if (connection.getState() != 6) {
            this.addConnection(string2, connection);
        }
        String string3 = (uri = connection.getAddress()) == null ? "null" : uri.getSchemeSpecificPart();
        Object[] objectArray2 = new Object[]{Connection.toLogSafePhoneNumber(string3), Connection.stateToString(connection.getState()), PhoneCapabilities.toString(connection.getCallCapabilities())};
        Log.v(this, "createConnection, number: %s, state: %s, capabilities: %s", objectArray2);
        Log.d(this, "createConnection, calling handleCreateConnectionSuccessful %s", string2);
        ConnectionServiceAdapter connectionServiceAdapter = this.mAdapter;
        PhoneAccountHandle phoneAccountHandle2 = this.getAccountHandle(connectionRequest, connection);
        int n = connection.getState();
        int n2 = connection.getCallCapabilities();
        Uri uri2 = connection.getAddress();
        int n3 = connection.getAddressPresentation();
        String string4 = connection.getCallerDisplayName();
        int n4 = connection.getCallerDisplayNamePresentation();
        IVideoProvider iVideoProvider = connection.getVideoProvider() == null ? null : connection.getVideoProvider().getInterface();
        connectionServiceAdapter.handleCreateConnectionComplete(string2, connectionRequest, new ParcelableConnection(phoneAccountHandle2, n, n2, uri2, n3, string4, n4, iVideoProvider, connection.getVideoState(), connection.isRingbackRequested(), connection.getAudioModeIsVoip(), connection.getStatusHints(), connection.getDisconnectCause(), this.createConnectionIdList(connection.getConferenceableConnections()), connection.getCallSubstate()));
    }

    private List<String> createConnectionIdList(List<Connection> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Connection connection : list) {
            if (!this.mIdByConnection.containsKey(connection)) continue;
            arrayList.add(this.mIdByConnection.get(connection));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private void deflect(String string2, String string3) {
        Log.d(this, "deflect %s - %s", string2, string3);
        this.findConnectionForAction(string2, "deflect").onDeflect(string3);
    }

    private void disconnect(String string2) {
        Log.d(this, "disconnect %s", string2);
        if (this.mConnectionById.containsKey(string2)) {
            this.findConnectionForAction(string2, "disconnect").onDisconnect();
            return;
        }
        this.findConferenceForAction(string2, "disconnect").onDisconnect();
    }

    private void endAllConnections() {
        for (Connection connection : this.mIdByConnection.keySet()) {
            if (connection.getConference() != null) continue;
            connection.onDisconnect();
        }
        Iterator<Conference> iterator = this.mIdByConference.keySet().iterator();
        while (iterator.hasNext()) {
            iterator.next().onDisconnect();
        }
    }

    private Conference findConferenceForAction(String string2, String string3) {
        if (this.mConferenceById.containsKey(string2)) {
            return this.mConferenceById.get(string2);
        }
        Log.w(this, "%s - Cannot find conference %s", string3, string2);
        return this.getNullConference();
    }

    private Connection findConnectionForAction(String string2, String string3) {
        if (this.mConnectionById.containsKey(string2)) {
            return this.mConnectionById.get(string2);
        }
        Log.w(this, "%s - Cannot find Connection %s", string3, string2);
        return ConnectionService.getNullConnection();
    }

    private Conference getNullConference() {
        if (this.sNullConference == null) {
            this.sNullConference = new Conference(null){};
        }
        return this.sNullConference;
    }

    static Connection getNullConnection() {
        synchronized (ConnectionService.class) {
            if (sNullConnection == null) {
                sNullConnection = new Connection(){};
            }
            Connection connection = sNullConnection;
            return connection;
        }
    }

    private void hold(String string2) {
        Log.d(this, "hold %s", string2);
        if (this.mConnectionById.containsKey(string2)) {
            this.findConnectionForAction(string2, "hold").onHold();
            return;
        }
        this.findConferenceForAction(string2, "hold").onHold();
    }

    private void mergeConference(String string2) {
        Log.d(this, "mergeConference(%s)", string2);
        Conference conference = this.findConferenceForAction(string2, "mergeConference");
        if (conference != null) {
            conference.onMerge();
        }
    }

    private void onAccountsInitialized() {
        this.mAreAccountsInitialized = true;
        Iterator<Runnable> iterator = this.mPreInitializationConnectionRequests.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.mPreInitializationConnectionRequests.clear();
    }

    private void onAdapterAttached() {
        if (this.mAreAccountsInitialized) {
            return;
        }
        this.mAdapter.queryRemoteConnectionServices(new RemoteServiceCallback.Stub(){

            @Override
            public void onError() {
                ConnectionService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionService.access$302(ConnectionService.this, true);
                    }
                });
            }

            @Override
            public void onResult(final List<ComponentName> list, final List<IBinder> list2) {
                ConnectionService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < list.size() && i < list2.size(); ++i) {
                            ConnectionService.this.mRemoteConnectionManager.addConnectionService((ComponentName)list.get(i), IConnectionService.Stub.asInterface((IBinder)list2.get(i)));
                        }
                        ConnectionService.this.onAccountsInitialized();
                        Log.d(this, "remote connection services found: " + list2, new Object[0]);
                    }
                });
            }
        });
    }

    private void onAudioStateChanged(String string2, AudioState audioState) {
        Log.d(this, "onAudioStateChanged %s %s", string2, audioState);
        if (this.mConnectionById.containsKey(string2)) {
            this.findConnectionForAction(string2, "onAudioStateChanged").setAudioState(audioState);
            return;
        }
        this.findConferenceForAction(string2, "onAudioStateChanged").setAudioState(audioState);
    }

    private void onPostDialContinue(String string2, boolean bl) {
        Log.d(this, "onPostDialContinue(%s)", string2);
        this.findConnectionForAction(string2, "stopDtmfTone").onPostDialContinue(bl);
    }

    private void playDtmfTone(String string2, char c) {
        Object[] objectArray = new Object[]{string2, Character.valueOf(c)};
        Log.d(this, "playDtmfTone %s %c", objectArray);
        if (this.mConnectionById.containsKey(string2)) {
            this.findConnectionForAction(string2, "playDtmfTone").onPlayDtmfTone(c);
            return;
        }
        this.findConferenceForAction(string2, "playDtmfTone").onPlayDtmfTone(c);
    }

    private void reject(String string2) {
        Log.d(this, "reject %s", string2);
        this.findConnectionForAction(string2, "reject").onReject();
    }

    private void removeConference(Conference conference) {
        if (this.mIdByConference.containsKey(conference)) {
            conference.removeListener(this.mConferenceListener);
            String string2 = this.mIdByConference.get(conference);
            this.mConferenceById.remove(string2);
            this.mIdByConference.remove(conference);
            this.mAdapter.removeCall(string2);
        }
    }

    private void setActiveSubscription(String string2) {
        Log.d(this, "setActiveSubscription %s", string2);
        this.findConnectionForAction(string2, "setActiveSubscription").setActiveSubscription();
    }

    private void setLocalCallHold(String string2, int n) {
        Log.d(this, "setLocalCallHold %s", string2);
        this.findConnectionForAction(string2, "setLocalCallHold").setLocalCallHold(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void splitFromConference(String string2) {
        Log.d(this, "splitFromConference(%s)", string2);
        Connection connection = this.findConnectionForAction(string2, "splitFromConference");
        if (connection == ConnectionService.getNullConnection()) {
            Log.w(this, "Connection missing in conference request %s.", string2);
            return;
        } else {
            Conference conference = connection.getConference();
            if (conference == null) return;
            conference.onSeparate(connection);
            return;
        }
    }

    private void stopDtmfTone(String string2) {
        Log.d(this, "stopDtmfTone %s", string2);
        if (this.mConnectionById.containsKey(string2)) {
            this.findConnectionForAction(string2, "stopDtmfTone").onStopDtmfTone();
            return;
        }
        this.findConferenceForAction(string2, "stopDtmfTone").onStopDtmfTone();
    }

    private void swapConference(String string2) {
        Log.d(this, "swapConference(%s)", string2);
        Conference conference = this.findConferenceForAction(string2, "swapConference");
        if (conference != null) {
            conference.onSwap();
        }
    }

    private void unhold(String string2) {
        Log.d(this, "unhold %s", string2);
        if (this.mConnectionById.containsKey(string2)) {
            this.findConnectionForAction(string2, "unhold").onUnhold();
            return;
        }
        this.findConferenceForAction(string2, "unhold").onUnhold();
    }

    public final void addConference(Conference conference) {
        String string2 = this.addConferenceInternal(conference);
        if (string2 != null) {
            ArrayList<String> arrayList = new ArrayList<String>(2);
            for (Connection connection : conference.getConnections()) {
                if (!this.mIdByConnection.containsKey(connection)) continue;
                arrayList.add(this.mIdByConnection.get(connection));
            }
            ParcelableConference parcelableConference = new ParcelableConference(conference.getPhoneAccountHandle(), conference.getState(), conference.getCapabilities(), arrayList);
            this.mAdapter.addConferenceCall(string2, parcelableConference);
            for (Connection connection : conference.getConnections()) {
                String string3 = this.mIdByConnection.get(connection);
                if (string3 == null) continue;
                this.mAdapter.setIsConferenced(string3, string2);
            }
        }
    }

    void addRemoteConference(RemoteConference remoteConference) {
        this.onRemoteConferenceAdded(remoteConference);
    }

    public final void conferenceRemoteConnections(RemoteConnection remoteConnection, RemoteConnection remoteConnection2) {
        this.mRemoteConnectionManager.conferenceRemoteConnections(remoteConnection, remoteConnection2);
    }

    public boolean containsConference(Conference conference) {
        return this.mIdByConference.containsKey(conference);
    }

    public final RemoteConnection createRemoteIncomingConnection(PhoneAccountHandle phoneAccountHandle, ConnectionRequest connectionRequest) {
        return this.mRemoteConnectionManager.createRemoteConnection(phoneAccountHandle, connectionRequest, true);
    }

    public final RemoteConnection createRemoteOutgoingConnection(PhoneAccountHandle phoneAccountHandle, ConnectionRequest connectionRequest) {
        return this.mRemoteConnectionManager.createRemoteConnection(phoneAccountHandle, connectionRequest, false);
    }

    public PhoneAccountHandle getAccountHandle(ConnectionRequest connectionRequest, Connection connection) {
        PhoneAccountHandle phoneAccountHandle = connection.getPhoneAccountHandle();
        if (phoneAccountHandle != null) {
            Log.i(this, "getAccountHandle, return account handle from local, %s", phoneAccountHandle);
            return phoneAccountHandle;
        }
        return connectionRequest.getAccountHandle();
    }

    public final Collection<Connection> getAllConnections() {
        return this.mConnectionById.values();
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public void onConference(Connection connection, Connection connection2) {
    }

    public Connection onCreateIncomingConnection(PhoneAccountHandle phoneAccountHandle, ConnectionRequest connectionRequest) {
        return null;
    }

    public Connection onCreateOutgoingConnection(PhoneAccountHandle phoneAccountHandle, ConnectionRequest connectionRequest) {
        return null;
    }

    public Connection onCreateUnknownConnection(PhoneAccountHandle phoneAccountHandle, ConnectionRequest connectionRequest) {
        return null;
    }

    public void onRemoteConferenceAdded(RemoteConference remoteConference) {
    }

    @Override
    public boolean onUnbind(Intent intent) {
        this.endAllConnections();
        return super.onUnbind(intent);
    }

    protected void removeConnection(Connection connection) {
        String string2 = this.mIdByConnection.get(connection);
        connection.unsetConnectionService(this);
        connection.removeConnectionListener(this.mConnectionListener);
        this.mConnectionById.remove(this.mIdByConnection.get(connection));
        this.mIdByConnection.remove(connection);
        this.mAdapter.removeCall(string2);
    }
}

