/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.Connection;
import android.telecom.PhoneAccountHandle;

public final class ConnectionRequest
implements Parcelable {
    public static final Parcelable.Creator<ConnectionRequest> CREATOR = new Parcelable.Creator<ConnectionRequest>(){

        @Override
        public ConnectionRequest createFromParcel(Parcel parcel) {
            return new ConnectionRequest(parcel);
        }

        public ConnectionRequest[] newArray(int n) {
            return new ConnectionRequest[n];
        }
    };
    private final PhoneAccountHandle mAccountHandle;
    private final Uri mAddress;
    private final Bundle mExtras;
    private final int mVideoState;

    private ConnectionRequest(Parcel parcel) {
        this.mAccountHandle = (PhoneAccountHandle)parcel.readParcelable(this.getClass().getClassLoader());
        this.mAddress = (Uri)parcel.readParcelable(this.getClass().getClassLoader());
        this.mExtras = (Bundle)parcel.readParcelable(this.getClass().getClassLoader());
        this.mVideoState = parcel.readInt();
    }

    public ConnectionRequest(PhoneAccountHandle phoneAccountHandle, Uri uri, Bundle bundle) {
        this(phoneAccountHandle, uri, bundle, 0);
    }

    public ConnectionRequest(PhoneAccountHandle phoneAccountHandle, Uri uri, Bundle bundle, int n) {
        this.mAccountHandle = phoneAccountHandle;
        this.mAddress = uri;
        this.mExtras = bundle;
        this.mVideoState = n;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public PhoneAccountHandle getAccountHandle() {
        return this.mAccountHandle;
    }

    public Uri getAddress() {
        return this.mAddress;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public int getVideoState() {
        return this.mVideoState;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        Object[] objectArray = new Object[2];
        Object object = this.mAddress == null ? Uri.EMPTY : Connection.toLogSafePhoneNumber(this.mAddress.toString());
        objectArray[0] = object;
        Object object2 = this.mExtras == null ? "" : this.mExtras;
        objectArray[1] = object2;
        return String.format("ConnectionRequest %s %s", objectArray);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeParcelable(this.mAccountHandle, 0);
        parcel.writeParcelable(this.mAddress, 0);
        parcel.writeParcelable(this.mExtras, 0);
        parcel.writeInt(this.mVideoState);
    }
}

