/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.provider.Settings;
import android.speech.tts.TextToSpeech;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.xmlpull.v1.XmlPullParserException;

public class TtsEngines {
    private static final boolean DBG = false;
    private static final String LOCALE_DELIMITER_NEW = "_";
    private static final String LOCALE_DELIMITER_OLD = "-";
    private static final String TAG = "TtsEngines";
    private static final String XML_TAG_NAME = "tts-engine";
    private static final Map<String, String> sNormalizeCountry;
    private static final Map<String, String> sNormalizeLanguage;
    private final Context mContext;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : Locale.getISOLanguages()) {
            try {
                hashMap.put(new Locale(string2).getISO3Language(), string2);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        sNormalizeLanguage = Collections.unmodifiableMap(hashMap);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        String[] stringArray = Locale.getISOCountries();
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                sNormalizeCountry = Collections.unmodifiableMap(hashMap2);
                return;
            }
            String string3 = stringArray[n2];
            try {
                hashMap2.put(new Locale("", string3).getISO3Country(), string3);
            }
            catch (MissingResourceException missingResourceException) {}
            ++n2;
        }
    }

    public TtsEngines(Context context) {
        this.mContext = context;
    }

    /*
     * Enabled aggressive block sorting
     */
    private TextToSpeech.EngineInfo getEngineInfo(ResolveInfo resolveInfo, PackageManager packageManager) {
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        if (serviceInfo == null) {
            return null;
        }
        TextToSpeech.EngineInfo engineInfo = new TextToSpeech.EngineInfo();
        engineInfo.name = serviceInfo.packageName;
        CharSequence charSequence = serviceInfo.loadLabel(packageManager);
        String string2 = TextUtils.isEmpty(charSequence) ? engineInfo.name : charSequence.toString();
        engineInfo.label = string2;
        engineInfo.icon = serviceInfo.getIconResource();
        engineInfo.priority = resolveInfo.priority;
        engineInfo.system = this.isSystemEngine(serviceInfo);
        return engineInfo;
    }

    private boolean isSystemEngine(ServiceInfo serviceInfo) {
        ApplicationInfo applicationInfo = serviceInfo.applicationInfo;
        return applicationInfo != null && (1 & applicationInfo.flags) != 0;
    }

    public static Locale normalizeTTSLocale(Locale locale) {
        String string2;
        String string3;
        String string4;
        String string5 = locale.getLanguage();
        if (!TextUtils.isEmpty(string5) && (string4 = sNormalizeLanguage.get(string5)) != null) {
            string5 = string4;
        }
        if (!TextUtils.isEmpty(string3 = locale.getCountry()) && (string2 = sNormalizeCountry.get(string3)) != null) {
            string3 = string2;
        }
        return new Locale(string5, string3, locale.getVariant());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String parseEnginePrefFromList(String string2, String string3) {
        if (!TextUtils.isEmpty(string2)) {
            for (String string4 : string2.split(",")) {
                int n = string4.indexOf(58);
                if (n <= 0 || !string3.equals(string4.substring(0, n))) continue;
                return string4.substring(n + 1);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String settingsActivityFromServiceInfo(ServiceInfo serviceInfo, PackageManager packageManager) {
        String string2;
        XmlResourceParser xmlResourceParser = null;
        try {
            int n;
            xmlResourceParser = serviceInfo.loadXmlMetaData(packageManager, "android.speech.tts");
            if (xmlResourceParser == null) {
                Log.w(TAG, "No meta-data found for :" + serviceInfo);
                string2 = null;
                return string2;
            }
            Resources resources = packageManager.getResourcesForApplication(serviceInfo.applicationInfo);
            do {
                if ((n = xmlResourceParser.next()) == 1) return null;
            } while (n != 2);
            if (!XML_TAG_NAME.equals(xmlResourceParser.getName())) {
                Log.w(TAG, "Package " + serviceInfo + " uses unknown tag :" + xmlResourceParser.getName());
                return null;
            }
            TypedArray typedArray = resources.obtainAttributes(Xml.asAttributeSet(xmlResourceParser), R.styleable.TextToSpeechEngine);
            string2 = typedArray.getString(0);
            typedArray.recycle();
            if (xmlResourceParser == null) return string2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w(TAG, "Could not load resources for : " + serviceInfo);
            return null;
        }
        catch (XmlPullParserException xmlPullParserException) {
            Log.w(TAG, "Error parsing metadata for " + serviceInfo + ":" + xmlPullParserException);
            return null;
        }
        catch (IOException iOException) {
            Log.w(TAG, "Error parsing metadata for " + serviceInfo + ":" + iOException);
            return null;
        }
        xmlResourceParser.close();
        return string2;
        finally {
            if (xmlResourceParser != null) {
                xmlResourceParser.close();
            }
        }
    }

    public static String[] toOldLocaleStringFormat(Locale locale) {
        String[] stringArray = new String[]{"", "", ""};
        try {
            stringArray[0] = locale.getISO3Language();
            stringArray[1] = locale.getISO3Country();
            stringArray[2] = locale.getVariant();
            return stringArray;
        }
        catch (MissingResourceException missingResourceException) {
            return new String[]{"eng", "USA", ""};
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String updateValueInCommaSeparatedList(String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        if (TextUtils.isEmpty(string2)) {
            stringBuilder.append(string3).append(':').append(string4);
            return stringBuilder.toString();
        }
        String[] stringArray = string2.split(",");
        boolean bl = true;
        boolean bl2 = false;
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                if (bl2) return stringBuilder.toString();
                stringBuilder.append(',');
                stringBuilder.append(string3).append(':').append(string4);
                return stringBuilder.toString();
            }
            String string5 = stringArray[n2];
            int n3 = string5.indexOf(58);
            if (n3 > 0) {
                if (string3.equals(string5.substring(0, n3))) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append(',');
                    }
                    bl2 = true;
                    stringBuilder.append(string3).append(':').append(string4);
                } else {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(string5);
                }
            }
            ++n2;
        }
    }

    public String getDefaultEngine() {
        String string2 = Settings.Secure.getString(this.mContext.getContentResolver(), "tts_default_synth");
        if (this.isEngineInstalled(string2)) {
            return string2;
        }
        return this.getHighestRankedEngineName();
    }

    public TextToSpeech.EngineInfo getEngineInfo(String string2) {
        PackageManager packageManager = this.mContext.getPackageManager();
        Intent intent = new Intent("android.intent.action.TTS_SERVICE");
        intent.setPackage(string2);
        List<ResolveInfo> list = packageManager.queryIntentServices(intent, 65536);
        if (list != null && list.size() == 1) {
            return this.getEngineInfo(list.get(0), packageManager);
        }
        return null;
    }

    public List<TextToSpeech.EngineInfo> getEngines() {
        PackageManager packageManager = this.mContext.getPackageManager();
        List<ResolveInfo> list = packageManager.queryIntentServices(new Intent("android.intent.action.TTS_SERVICE"), 65536);
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<TextToSpeech.EngineInfo> arrayList = new ArrayList<TextToSpeech.EngineInfo>(list.size());
        Iterator<ResolveInfo> iterator = list.iterator();
        while (iterator.hasNext()) {
            TextToSpeech.EngineInfo engineInfo = this.getEngineInfo(iterator.next(), packageManager);
            if (engineInfo == null) continue;
            arrayList.add(engineInfo);
        }
        Collections.sort(arrayList, EngineInfoComparator.INSTANCE);
        return arrayList;
    }

    public String getHighestRankedEngineName() {
        List<TextToSpeech.EngineInfo> list = this.getEngines();
        if (list.size() > 0 && list.get((int)0).system) {
            return list.get((int)0).name;
        }
        return null;
    }

    public Locale getLocalePrefForEngine(String string2) {
        return this.getLocalePrefForEngine(string2, Settings.Secure.getString(this.mContext.getContentResolver(), "tts_default_locale"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Locale getLocalePrefForEngine(String string2, String string3) {
        String string4 = TtsEngines.parseEnginePrefFromList(string3, string2);
        if (TextUtils.isEmpty(string4)) {
            return Locale.getDefault();
        }
        Locale locale = this.parseLocaleString(string4);
        if (locale != null) return locale;
        Log.w(TAG, "Failed to parse locale " + string4 + ", returning en_US instead");
        return Locale.US;
    }

    public Intent getSettingsIntent(String string2) {
        String string3;
        ServiceInfo serviceInfo;
        PackageManager packageManager = this.mContext.getPackageManager();
        Intent intent = new Intent("android.intent.action.TTS_SERVICE");
        intent.setPackage(string2);
        List<ResolveInfo> list = packageManager.queryIntentServices(intent, 65664);
        if (list != null && list.size() == 1 && (serviceInfo = list.get((int)0).serviceInfo) != null && (string3 = this.settingsActivityFromServiceInfo(serviceInfo, packageManager)) != null) {
            Intent intent2 = new Intent();
            intent2.setClassName(string2, string3);
            return intent2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isEngineInstalled(String string2) {
        return string2 != null && this.getEngineInfo(string2) != null;
    }

    public boolean isLocaleSetToDefaultForEngine(String string2) {
        return TextUtils.isEmpty(TtsEngines.parseEnginePrefFromList(Settings.Secure.getString(this.mContext.getContentResolver(), "tts_default_locale"), string2));
    }

    public Locale parseLocaleString(String string2) {
        String string3;
        String string4;
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (!TextUtils.isEmpty(string2)) {
            String[] stringArray = string2.split("[-_]");
            string5 = stringArray[0].toLowerCase();
            if (stringArray.length == 0) {
                Log.w(TAG, "Failed to convert " + string2 + " to a valid Locale object. Only" + " separators");
                return null;
            }
            if (stringArray.length > 3) {
                Log.w(TAG, "Failed to convert " + string2 + " to a valid Locale object. Too" + " many separators");
                return null;
            }
            if (stringArray.length >= 2) {
                string6 = stringArray[1].toUpperCase();
            }
            if (stringArray.length >= 3) {
                string7 = stringArray[2];
            }
        }
        if ((string4 = sNormalizeLanguage.get(string5)) != null) {
            string5 = string4;
        }
        if ((string3 = sNormalizeCountry.get(string6)) != null) {
            string6 = string3;
        }
        Locale locale = new Locale(string5, string6, string7);
        try {
            locale.getISO3Language();
            locale.getISO3Country();
            return locale;
        }
        catch (MissingResourceException missingResourceException) {
            Log.w(TAG, "Failed to convert " + string2 + " to a valid Locale object.");
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateLocalePrefForEngine(String string2, Locale locale) {
        synchronized (this) {
            String string3 = Settings.Secure.getString(this.mContext.getContentResolver(), "tts_default_locale");
            String string4 = locale != null ? locale.toString() : "";
            String string5 = this.updateValueInCommaSeparatedList(string3, string2, string4);
            Settings.Secure.putString(this.mContext.getContentResolver(), "tts_default_locale", string5.toString());
            return;
        }
    }

    private static class EngineInfoComparator
    implements Comparator<TextToSpeech.EngineInfo> {
        static EngineInfoComparator INSTANCE = new EngineInfoComparator();

        private EngineInfoComparator() {
        }

        @Override
        public int compare(TextToSpeech.EngineInfo engineInfo, TextToSpeech.EngineInfo engineInfo2) {
            if (engineInfo.system && !engineInfo2.system) {
                return -1;
            }
            if (engineInfo2.system && !engineInfo.system) {
                return 1;
            }
            return engineInfo2.priority - engineInfo.priority;
        }
    }
}

