/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.media.AudioFormat;
import android.media.AudioTrack;
import android.speech.tts.TextToSpeechService;
import android.util.Log;

class BlockingAudioTrack {
    private static final boolean DBG = false;
    private static final long MAX_PROGRESS_WAIT_MS = 2500L;
    private static final long MAX_SLEEP_TIME_MS = 2500L;
    private static final int MIN_AUDIO_BUFFER_SIZE = 8192;
    private static final long MIN_SLEEP_TIME_MS = 20L;
    private static final String TAG = "TTS.BlockingAudioTrack";
    private int mAudioBufferSize;
    private final int mAudioFormat;
    private final TextToSpeechService.AudioOutputParams mAudioParams;
    private AudioTrack mAudioTrack;
    private Object mAudioTrackLock = new Object();
    private final int mBytesPerFrame;
    private int mBytesWritten = 0;
    private final int mChannelCount;
    private boolean mIsShortUtterance;
    private final int mSampleRateInHz;
    private int mSessionId;
    private volatile boolean mStopped;

    BlockingAudioTrack(TextToSpeechService.AudioOutputParams audioOutputParams, int n, int n2, int n3) {
        this.mAudioParams = audioOutputParams;
        this.mSampleRateInHz = n;
        this.mAudioFormat = n2;
        this.mChannelCount = n3;
        this.mBytesPerFrame = AudioFormat.getBytesPerSample(this.mAudioFormat) * this.mChannelCount;
        this.mIsShortUtterance = false;
        this.mAudioBufferSize = 0;
        this.mBytesWritten = 0;
        this.mAudioTrack = null;
        this.mStopped = false;
    }

    private void blockUntilCompletion(AudioTrack audioTrack) {
        int n = this.mBytesWritten / this.mBytesPerFrame;
        int n2 = -1;
        long l = 0L;
        while (true) {
            long l2;
            int n3;
            block7: {
                block6: {
                    block5: {
                        if ((n3 = audioTrack.getPlaybackHeadPosition()) >= n || audioTrack.getPlayState() != 3 || this.mStopped) break block5;
                        l2 = BlockingAudioTrack.clip(1000 * (n - n3) / audioTrack.getSampleRate(), 20L, 2500L);
                        if (n3 != n2) break block6;
                        if ((l += l2) <= 2500L) break block7;
                        Log.w(TAG, "Waited unsuccessfully for 2500ms for AudioTrack to make progress, Aborting");
                    }
                    return;
                }
                l = 0L;
            }
            n2 = n3;
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private void blockUntilDone(AudioTrack audioTrack) {
        if (this.mBytesWritten <= 0) {
            return;
        }
        if (this.mIsShortUtterance) {
            this.blockUntilEstimatedCompletion();
            return;
        }
        this.blockUntilCompletion(audioTrack);
    }

    private void blockUntilEstimatedCompletion() {
        long l = 1000 * (this.mBytesWritten / this.mBytesPerFrame) / this.mSampleRateInHz;
        try {
            Thread.sleep(l);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private static final float clip(float f, float f2, float f3) {
        if (f < f2) {
            return f2;
        }
        if (f < f3) {
            return f;
        }
        return f3;
    }

    private static final long clip(long l, long l2, long l3) {
        if (l < l2) {
            return l2;
        }
        if (l < l3) {
            return l;
        }
        return l3;
    }

    private AudioTrack createStreamingAudioTrack() {
        int n = BlockingAudioTrack.getChannelConfig(this.mChannelCount);
        int n2 = Math.max(8192, AudioTrack.getMinBufferSize(this.mSampleRateInHz, n, this.mAudioFormat));
        AudioFormat audioFormat = new AudioFormat.Builder().setChannelMask(n).setEncoding(this.mAudioFormat).setSampleRate(this.mSampleRateInHz).build();
        AudioTrack audioTrack = new AudioTrack(this.mAudioParams.mAudioAttributes, audioFormat, n2, 1, this.mAudioParams.mSessionId);
        if (audioTrack.getState() != 1) {
            Log.w(TAG, "Unable to create audio track.");
            audioTrack.release();
            return null;
        }
        this.mAudioBufferSize = n2;
        BlockingAudioTrack.setupVolume(audioTrack, this.mAudioParams.mVolume, this.mAudioParams.mPan);
        return audioTrack;
    }

    static int getChannelConfig(int n) {
        if (n == 1) {
            return 4;
        }
        if (n == 2) {
            return 12;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void setupVolume(AudioTrack audioTrack, float f, float f2) {
        float f3 = BlockingAudioTrack.clip(f, 0.0f, 1.0f);
        float f4 = BlockingAudioTrack.clip(f2, -1.0f, 1.0f);
        float f5 = f3;
        float f6 = f3;
        if (f4 > 0.0f) {
            f5 *= 1.0f - f4;
        } else if (f4 < 0.0f) {
            f6 *= 1.0f + f4;
        }
        if (audioTrack.setStereoVolume(f5, f6) != 0) {
            Log.e(TAG, "Failed to set volume");
        }
    }

    private static int writeToAudioTrack(AudioTrack audioTrack, byte[] byArray) {
        if (audioTrack.getPlayState() != 3) {
            audioTrack.play();
        }
        int n = 0;
        int n2;
        while (n < byArray.length && (n2 = audioTrack.write(byArray, n, byArray.length)) > 0) {
            n += n2;
        }
        return n;
    }

    long getAudioLengthMs(int n) {
        return 1000 * (n / this.mBytesPerFrame) / this.mSampleRateInHz;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean init() {
        AudioTrack audioTrack = this.createStreamingAudioTrack();
        Object object = this.mAudioTrackLock;
        synchronized (object) {
            this.mAudioTrack = audioTrack;
            return audioTrack != null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Object object = this.mAudioTrackLock;
        synchronized (object) {
            if (this.mAudioTrack != null) {
                this.mAudioTrack.stop();
            }
            this.mStopped = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void waitAndRelease() {
        Object object = this.mAudioTrackLock;
        // MONITORENTER : object
        AudioTrack audioTrack = this.mAudioTrack;
        // MONITOREXIT : object
        if (audioTrack == null) {
            return;
        }
        if (this.mBytesWritten < this.mAudioBufferSize && !this.mStopped) {
            this.mIsShortUtterance = true;
            audioTrack.stop();
        }
        if (!this.mStopped) {
            this.blockUntilDone(this.mAudioTrack);
        }
        Object object2 = this.mAudioTrackLock;
        // MONITORENTER : object2
        this.mAudioTrack = null;
        // MONITOREXIT : object2
        audioTrack.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int write(byte[] byArray) {
        Object object = this.mAudioTrackLock;
        // MONITORENTER : object
        AudioTrack audioTrack = this.mAudioTrack;
        // MONITOREXIT : object
        if (audioTrack == null) return -1;
        if (this.mStopped) {
            return -1;
        }
        int n = BlockingAudioTrack.writeToAudioTrack(audioTrack, byArray);
        this.mBytesWritten = n + this.mBytesWritten;
        return n;
    }
}

