/*
 * Decompiled with CFR 0.152.
 */
package android.speech.srec;

import java.io.IOException;
import java.io.InputStream;

public final class MicrophoneInputStream
extends InputStream {
    private static final String TAG = "MicrophoneInputStream";
    private long mAudioRecord = 0L;
    private byte[] mOneByte = new byte[1];

    static {
        System.loadLibrary("srec_jni");
    }

    public MicrophoneInputStream(int n, int n2) throws IOException {
        this.mAudioRecord = MicrophoneInputStream.AudioRecordNew(n, n2);
        if (this.mAudioRecord == 0L) {
            throw new IOException("AudioRecord constructor failed - busy?");
        }
        int n3 = MicrophoneInputStream.AudioRecordStart(this.mAudioRecord);
        if (n3 != 0) {
            this.close();
            throw new IOException("AudioRecord start failed: " + n3);
        }
    }

    private static native void AudioRecordDelete(long var0) throws IOException;

    private static native long AudioRecordNew(int var0, int var1);

    private static native int AudioRecordRead(long var0, byte[] var2, int var3, int var4) throws IOException;

    private static native int AudioRecordStart(long var0);

    private static native void AudioRecordStop(long var0) throws IOException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        if (this.mAudioRecord == 0L) return;
        try {
            MicrophoneInputStream.AudioRecordStop(this.mAudioRecord);
        }
        catch (Throwable throwable) {
            try {
                MicrophoneInputStream.AudioRecordDelete(this.mAudioRecord);
                throw throwable;
            }
            finally {
                this.mAudioRecord = 0L;
            }
        }
        MicrophoneInputStream.AudioRecordDelete(this.mAudioRecord);
        return;
        finally {
            this.mAudioRecord = 0L;
        }
    }

    protected void finalize() throws Throwable {
        if (this.mAudioRecord != 0L) {
            this.close();
            throw new IOException("someone forgot to close MicrophoneInputStream");
        }
    }

    @Override
    public int read() throws IOException {
        if (this.mAudioRecord == 0L) {
            throw new IllegalStateException("not open");
        }
        if (MicrophoneInputStream.AudioRecordRead(this.mAudioRecord, this.mOneByte, 0, 1) == 1) {
            return 0xFF & this.mOneByte[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        if (this.mAudioRecord == 0L) {
            throw new IllegalStateException("not open");
        }
        return MicrophoneInputStream.AudioRecordRead(this.mAudioRecord, byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.mAudioRecord == 0L) {
            throw new IllegalStateException("not open");
        }
        return MicrophoneInputStream.AudioRecordRead(this.mAudioRecord, byArray, n, n2);
    }
}

