/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.R;
import android.app.Dialog;
import android.app.Instrumentation;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.Region;
import android.inputmethodservice.SoftInputWindow;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.service.voice.IVoiceInteractionSession;
import android.util.ArrayMap;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.android.internal.app.IVoiceInteractionManagerService;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.app.IVoiceInteractorCallback;
import com.android.internal.app.IVoiceInteractorRequest;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import java.lang.ref.WeakReference;

public abstract class VoiceInteractionSession
implements KeyEvent.Callback {
    static final boolean DEBUG = true;
    static final int MSG_CANCEL = 6;
    static final int MSG_CLOSE_SYSTEM_DIALOGS = 102;
    static final int MSG_DESTROY = 103;
    static final int MSG_START_ABORT_VOICE = 3;
    static final int MSG_START_COMMAND = 4;
    static final int MSG_START_COMPLETE_VOICE = 2;
    static final int MSG_START_CONFIRMATION = 1;
    static final int MSG_SUPPORTS_COMMANDS = 5;
    static final int MSG_TASK_FINISHED = 101;
    static final int MSG_TASK_STARTED = 100;
    static final String TAG = "VoiceInteractionSession";
    final ArrayMap<IBinder, Request> mActiveRequests;
    final MyCallbacks mCallbacks;
    FrameLayout mContentFrame;
    final Context mContext;
    final KeyEvent.DispatcherState mDispatcherState = new KeyEvent.DispatcherState();
    final HandlerCaller mHandlerCaller;
    boolean mInShowWindow;
    LayoutInflater mInflater;
    boolean mInitialized;
    final ViewTreeObserver.OnComputeInternalInsetsListener mInsetsComputer;
    final IVoiceInteractor mInteractor;
    View mRootView;
    final IVoiceInteractionSession mSession;
    IVoiceInteractionManagerService mSystemService;
    int mTheme = 0;
    TypedArray mThemeAttrs;
    final Insets mTmpInsets;
    final int[] mTmpLocation;
    IBinder mToken;
    final WeakReference<VoiceInteractionSession> mWeakRef;
    SoftInputWindow mWindow;
    boolean mWindowAdded;
    boolean mWindowVisible;
    boolean mWindowWasVisible;

    public VoiceInteractionSession(Context context) {
        this(context, new Handler());
    }

    public VoiceInteractionSession(Context context, Handler handler) {
        this.mActiveRequests = new ArrayMap();
        this.mTmpInsets = new Insets();
        this.mTmpLocation = new int[2];
        this.mWeakRef = new WeakReference<VoiceInteractionSession>(this);
        this.mInteractor = new IVoiceInteractor.Stub(){

            @Override
            public IVoiceInteractorRequest startAbortVoice(String string2, IVoiceInteractorCallback iVoiceInteractorCallback, CharSequence charSequence, Bundle bundle) {
                Request request = VoiceInteractionSession.this.newRequest(iVoiceInteractorCallback);
                VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageOOOO(3, new Caller(string2, Binder.getCallingUid()), request, charSequence, bundle));
                return request.mInterface;
            }

            @Override
            public IVoiceInteractorRequest startCommand(String string2, IVoiceInteractorCallback iVoiceInteractorCallback, String string3, Bundle bundle) {
                Request request = VoiceInteractionSession.this.newRequest(iVoiceInteractorCallback);
                VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageOOOO(4, new Caller(string2, Binder.getCallingUid()), request, string3, bundle));
                return request.mInterface;
            }

            @Override
            public IVoiceInteractorRequest startCompleteVoice(String string2, IVoiceInteractorCallback iVoiceInteractorCallback, CharSequence charSequence, Bundle bundle) {
                Request request = VoiceInteractionSession.this.newRequest(iVoiceInteractorCallback);
                VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageOOOO(2, new Caller(string2, Binder.getCallingUid()), request, charSequence, bundle));
                return request.mInterface;
            }

            @Override
            public IVoiceInteractorRequest startConfirmation(String string2, IVoiceInteractorCallback iVoiceInteractorCallback, CharSequence charSequence, Bundle bundle) {
                Request request = VoiceInteractionSession.this.newRequest(iVoiceInteractorCallback);
                VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageOOOO(1, new Caller(string2, Binder.getCallingUid()), request, charSequence, bundle));
                return request.mInterface;
            }

            @Override
            public boolean[] supportsCommands(String string2, String[] stringArray) {
                Message message = VoiceInteractionSession.this.mHandlerCaller.obtainMessageIOO(5, 0, new Caller(string2, Binder.getCallingUid()), stringArray);
                SomeArgs someArgs = VoiceInteractionSession.this.mHandlerCaller.sendMessageAndWait(message);
                if (someArgs != null) {
                    boolean[] blArray = (boolean[])someArgs.arg1;
                    someArgs.recycle();
                    return blArray;
                }
                return new boolean[stringArray.length];
            }
        };
        this.mSession = new IVoiceInteractionSession.Stub(){

            @Override
            public void closeSystemDialogs() {
                VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessage(102));
            }

            @Override
            public void destroy() {
                VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessage(103));
            }

            @Override
            public void taskFinished(Intent intent, int n) {
                VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageIO(101, n, intent));
            }

            @Override
            public void taskStarted(Intent intent, int n) {
                VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageIO(100, n, intent));
            }
        };
        this.mCallbacks = new MyCallbacks();
        this.mInsetsComputer = new ViewTreeObserver.OnComputeInternalInsetsListener(){

            @Override
            public void onComputeInternalInsets(ViewTreeObserver.InternalInsetsInfo internalInsetsInfo) {
                VoiceInteractionSession.this.onComputeInsets(VoiceInteractionSession.this.mTmpInsets);
                internalInsetsInfo.contentInsets.set(VoiceInteractionSession.this.mTmpInsets.contentInsets);
                internalInsetsInfo.visibleInsets.set(VoiceInteractionSession.this.mTmpInsets.contentInsets);
                internalInsetsInfo.touchableRegion.set(VoiceInteractionSession.this.mTmpInsets.touchableRegion);
                internalInsetsInfo.setTouchableInsets(VoiceInteractionSession.this.mTmpInsets.touchableInsets);
            }
        };
        this.mContext = context;
        this.mHandlerCaller = new HandlerCaller(context, handler.getLooper(), this.mCallbacks, true);
    }

    void doCreate(IVoiceInteractionManagerService iVoiceInteractionManagerService, IBinder iBinder, Bundle bundle) {
        this.mSystemService = iVoiceInteractionManagerService;
        this.mToken = iBinder;
        this.onCreate(bundle);
    }

    void doDestroy() {
        this.onDestroy();
        if (this.mInitialized) {
            this.mRootView.getViewTreeObserver().removeOnComputeInternalInsetsListener(this.mInsetsComputer);
            if (this.mWindowAdded) {
                this.mWindow.dismiss();
                this.mWindowAdded = false;
            }
            this.mInitialized = false;
        }
    }

    public void finish() {
        if (this.mToken == null) {
            throw new IllegalStateException("Can't call before onCreate()");
        }
        this.hideWindow();
        try {
            this.mSystemService.finish(this.mToken);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public LayoutInflater getLayoutInflater() {
        return this.mInflater;
    }

    public Dialog getWindow() {
        return this.mWindow;
    }

    public void hideWindow() {
        if (this.mWindowVisible) {
            this.mWindow.hide();
            this.mWindowVisible = false;
        }
    }

    void initViews() {
        this.mInitialized = true;
        this.mThemeAttrs = this.mContext.obtainStyledAttributes(R.styleable.VoiceInteractionSession);
        this.mRootView = this.mInflater.inflate(17367299, null);
        this.mRootView.setSystemUiVisibility(768);
        this.mWindow.setContentView(this.mRootView);
        this.mRootView.getViewTreeObserver().addOnComputeInternalInsetsListener(this.mInsetsComputer);
        this.mContentFrame = (FrameLayout)this.mRootView.findViewById(0x1020002);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Request newRequest(IVoiceInteractorCallback iVoiceInteractorCallback) {
        synchronized (this) {
            Request request = new Request(iVoiceInteractorCallback, this);
            this.mActiveRequests.put(request.mInterface.asBinder(), request);
            return request;
        }
    }

    public void onAbortVoice(Caller caller, Request request, CharSequence charSequence, Bundle bundle) {
        request.sendAbortVoiceResult(null);
    }

    public void onBackPressed() {
        this.finish();
    }

    public abstract void onCancel(Request var1);

    public void onCloseSystemDialogs() {
        this.finish();
    }

    public abstract void onCommand(Caller var1, Request var2, String var3, Bundle var4);

    public void onCompleteVoice(Caller caller, Request request, CharSequence charSequence, Bundle bundle) {
        request.sendCompleteVoiceResult(null);
    }

    public void onComputeInsets(Insets insets) {
        int[] nArray = this.mTmpLocation;
        this.getWindow().getWindow().getDecorView().getLocationInWindow(nArray);
        insets.contentInsets.top = 0;
        insets.contentInsets.left = 0;
        insets.contentInsets.right = 0;
        insets.contentInsets.bottom = 0;
        insets.touchableInsets = 0;
        insets.touchableRegion.setEmpty();
    }

    public abstract void onConfirm(Caller var1, Request var2, CharSequence var3, Bundle var4);

    /*
     * Enabled aggressive block sorting
     */
    public void onCreate(Bundle bundle) {
        int n = this.mTheme != 0 ? this.mTheme : 16974982;
        this.mTheme = n;
        this.mInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mWindow = new SoftInputWindow(this.mContext, TAG, this.mTheme, this.mCallbacks, this, this.mDispatcherState, 2031, 48, true);
        this.mWindow.getWindow().addFlags(0x1000000);
        this.initViews();
        this.mWindow.getWindow().setLayout(-1, -2);
        this.mWindow.setToken(this.mToken);
    }

    public View onCreateContentView() {
        return null;
    }

    public void onDestroy() {
    }

    public boolean[] onGetSupportedCommands(Caller caller, String[] stringArray) {
        return new boolean[stringArray.length];
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return false;
    }

    @Override
    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        return false;
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return false;
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return false;
    }

    public void onTaskFinished(Intent intent, int n) {
        this.finish();
    }

    public void onTaskStarted(Intent intent, int n) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Request removeRequest(IBinder iBinder) {
        synchronized (this) {
            Request request = this.mActiveRequests.get(iBinder);
            if (request != null) {
                this.mActiveRequests.remove(request);
            }
            return request;
        }
    }

    public void setContentView(View view) {
        this.mContentFrame.removeAllViews();
        this.mContentFrame.addView(view, new FrameLayout.LayoutParams(-1, -2));
    }

    public void setTheme(int n) {
        if (this.mWindow != null) {
            throw new IllegalStateException("Must be called before onCreate()");
        }
        this.mTheme = n;
    }

    public void showWindow() {
        Log.v(TAG, "Showing window: mWindowAdded=" + this.mWindowAdded + " mWindowVisible=" + this.mWindowVisible);
        if (this.mInShowWindow) {
            Log.w(TAG, "Re-entrance in to showWindow");
            return;
        }
        try {
            this.mInShowWindow = true;
            if (!this.mWindowVisible) {
                this.mWindowVisible = true;
                if (!this.mWindowAdded) {
                    this.mWindowAdded = true;
                    View view = this.onCreateContentView();
                    if (view != null) {
                        this.setContentView(view);
                    }
                }
                this.mWindow.show();
            }
            return;
        }
        finally {
            this.mWindowWasVisible = true;
            this.mInShowWindow = false;
        }
    }

    public void startVoiceActivity(Intent intent) {
        if (this.mToken == null) {
            throw new IllegalStateException("Can't call before onCreate()");
        }
        try {
            intent.migrateExtraStreamToClipData();
            intent.prepareToLeaveProcess();
            Instrumentation.checkStartActivityResult(this.mSystemService.startVoiceActivity(this.mToken, intent, intent.resolveType(this.mContext.getContentResolver())), intent);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static class Caller {
        final String packageName;
        final int uid;

        Caller(String string2, int n) {
            this.packageName = string2;
            this.uid = n;
        }
    }

    public static final class Insets {
        public static final int TOUCHABLE_INSETS_CONTENT = 1;
        public static final int TOUCHABLE_INSETS_FRAME = 0;
        public static final int TOUCHABLE_INSETS_REGION = 3;
        public final Rect contentInsets = new Rect();
        public int touchableInsets;
        public final Region touchableRegion = new Region();
    }

    class MyCallbacks
    implements HandlerCaller.Callback,
    SoftInputWindow.Callback {
        MyCallbacks() {
        }

        @Override
        public void executeMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    SomeArgs someArgs = (SomeArgs)message.obj;
                    Log.d(VoiceInteractionSession.TAG, "onConfirm: req=" + ((Request)someArgs.arg2).mInterface + " prompt=" + someArgs.arg3 + " extras=" + someArgs.arg4);
                    VoiceInteractionSession.this.onConfirm((Caller)someArgs.arg1, (Request)someArgs.arg2, (CharSequence)someArgs.arg3, (Bundle)someArgs.arg4);
                    return;
                }
                case 2: {
                    SomeArgs someArgs = (SomeArgs)message.obj;
                    Log.d(VoiceInteractionSession.TAG, "onCompleteVoice: req=" + ((Request)someArgs.arg2).mInterface + " message=" + someArgs.arg3 + " extras=" + someArgs.arg4);
                    VoiceInteractionSession.this.onCompleteVoice((Caller)someArgs.arg1, (Request)someArgs.arg2, (CharSequence)someArgs.arg3, (Bundle)someArgs.arg4);
                    return;
                }
                case 3: {
                    SomeArgs someArgs = (SomeArgs)message.obj;
                    Log.d(VoiceInteractionSession.TAG, "onAbortVoice: req=" + ((Request)someArgs.arg2).mInterface + " message=" + someArgs.arg3 + " extras=" + someArgs.arg4);
                    VoiceInteractionSession.this.onAbortVoice((Caller)someArgs.arg1, (Request)someArgs.arg2, (CharSequence)someArgs.arg3, (Bundle)someArgs.arg4);
                    return;
                }
                case 4: {
                    SomeArgs someArgs = (SomeArgs)message.obj;
                    Log.d(VoiceInteractionSession.TAG, "onCommand: req=" + ((Request)someArgs.arg2).mInterface + " command=" + someArgs.arg3 + " extras=" + someArgs.arg4);
                    VoiceInteractionSession.this.onCommand((Caller)someArgs.arg1, (Request)someArgs.arg2, (String)someArgs.arg3, (Bundle)someArgs.arg4);
                    return;
                }
                case 5: {
                    SomeArgs someArgs = (SomeArgs)message.obj;
                    Log.d(VoiceInteractionSession.TAG, "onGetSupportedCommands: cmds=" + someArgs.arg2);
                    someArgs.arg1 = VoiceInteractionSession.this.onGetSupportedCommands((Caller)someArgs.arg1, (String[])someArgs.arg2);
                    return;
                }
                case 6: {
                    SomeArgs someArgs = (SomeArgs)message.obj;
                    Log.d(VoiceInteractionSession.TAG, "onCancel: req=" + ((Request)someArgs.arg1).mInterface);
                    VoiceInteractionSession.this.onCancel((Request)someArgs.arg1);
                    return;
                }
                case 100: {
                    Log.d(VoiceInteractionSession.TAG, "onTaskStarted: intent=" + message.obj + " taskId=" + message.arg1);
                    VoiceInteractionSession.this.onTaskStarted((Intent)message.obj, message.arg1);
                    return;
                }
                case 101: {
                    Log.d(VoiceInteractionSession.TAG, "onTaskFinished: intent=" + message.obj + " taskId=" + message.arg1);
                    VoiceInteractionSession.this.onTaskFinished((Intent)message.obj, message.arg1);
                    return;
                }
                case 102: {
                    Log.d(VoiceInteractionSession.TAG, "onCloseSystemDialogs");
                    VoiceInteractionSession.this.onCloseSystemDialogs();
                    return;
                }
                case 103: 
            }
            Log.d(VoiceInteractionSession.TAG, "doDestroy");
            VoiceInteractionSession.this.doDestroy();
        }

        @Override
        public void onBackPressed() {
            VoiceInteractionSession.this.onBackPressed();
        }
    }

    public static class Request {
        final IVoiceInteractorCallback mCallback;
        final IVoiceInteractorRequest mInterface = new IVoiceInteractorRequest.Stub(){

            @Override
            public void cancel() throws RemoteException {
                VoiceInteractionSession voiceInteractionSession = (VoiceInteractionSession)Request.this.mSession.get();
                if (voiceInteractionSession != null) {
                    voiceInteractionSession.mHandlerCaller.sendMessage(voiceInteractionSession.mHandlerCaller.obtainMessageO(6, Request.this));
                }
            }
        };
        final WeakReference<VoiceInteractionSession> mSession;

        Request(IVoiceInteractorCallback iVoiceInteractorCallback, VoiceInteractionSession voiceInteractionSession) {
            this.mCallback = iVoiceInteractorCallback;
            this.mSession = voiceInteractionSession.mWeakRef;
        }

        void finishRequest() {
            VoiceInteractionSession voiceInteractionSession = (VoiceInteractionSession)this.mSession.get();
            if (voiceInteractionSession == null) {
                throw new IllegalStateException("VoiceInteractionSession has been destroyed");
            }
            Request request = voiceInteractionSession.removeRequest(this.mInterface.asBinder());
            if (request == null) {
                throw new IllegalStateException("Request not active: " + this);
            }
            if (request != this) {
                throw new IllegalStateException("Current active request " + request + " not same as calling request " + this);
            }
        }

        public void sendAbortVoiceResult(Bundle bundle) {
            try {
                Log.d(VoiceInteractionSession.TAG, "sendConfirmResult: req=" + this.mInterface + " result=" + bundle);
                this.finishRequest();
                this.mCallback.deliverAbortVoiceResult(this.mInterface, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void sendCancelResult() {
            try {
                Log.d(VoiceInteractionSession.TAG, "sendCancelResult: req=" + this.mInterface);
                this.finishRequest();
                this.mCallback.deliverCancel(this.mInterface);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void sendCommandResult(boolean bl, Bundle bundle) {
            try {
                Log.d(VoiceInteractionSession.TAG, "sendCommandResult: req=" + this.mInterface + " result=" + bundle);
                this.finishRequest();
                this.mCallback.deliverCommandResult(this.mInterface, bl, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void sendCompleteVoiceResult(Bundle bundle) {
            try {
                Log.d(VoiceInteractionSession.TAG, "sendCompleteVoiceResult: req=" + this.mInterface + " result=" + bundle);
                this.finishRequest();
                this.mCallback.deliverCompleteVoiceResult(this.mInterface, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void sendConfirmResult(boolean bl, Bundle bundle) {
            try {
                Log.d(VoiceInteractionSession.TAG, "sendConfirmResult: req=" + this.mInterface + " confirmed=" + bl + " result=" + bundle);
                this.finishRequest();
                this.mCallback.deliverConfirmationResult(this.mInterface, bl, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    }
}

