/*
 * Decompiled with CFR 0.152.
 */
package android.service.textservice;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.text.TextUtils;
import android.text.method.WordIterator;
import android.view.textservice.SentenceSuggestionsInfo;
import android.view.textservice.SuggestionsInfo;
import android.view.textservice.TextInfo;
import com.android.internal.textservice.ISpellCheckerService;
import com.android.internal.textservice.ISpellCheckerSession;
import com.android.internal.textservice.ISpellCheckerSessionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Locale;

public abstract class SpellCheckerService
extends Service {
    private static final boolean DBG = false;
    public static final String SERVICE_INTERFACE = "android.service.textservice.SpellCheckerService";
    private static final String TAG = SpellCheckerService.class.getSimpleName();
    private final SpellCheckerServiceBinder mBinder = new SpellCheckerServiceBinder(this);

    public abstract Session createSession();

    @Override
    public final IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    private static class InternalISpellCheckerSession
    extends ISpellCheckerSession.Stub {
        private final Bundle mBundle;
        private ISpellCheckerSessionListener mListener;
        private final String mLocale;
        private final Session mSession;

        public InternalISpellCheckerSession(String string2, ISpellCheckerSessionListener iSpellCheckerSessionListener, Bundle bundle, Session session) {
            this.mListener = iSpellCheckerSessionListener;
            this.mSession = session;
            this.mLocale = string2;
            this.mBundle = bundle;
            session.setInternalISpellCheckerSession(this);
        }

        public Bundle getBundle() {
            return this.mBundle;
        }

        public String getLocale() {
            return this.mLocale;
        }

        @Override
        public void onCancel() {
            int n = Process.getThreadPriority(Process.myTid());
            try {
                Process.setThreadPriority(10);
                this.mSession.onCancel();
                return;
            }
            finally {
                Process.setThreadPriority(n);
            }
        }

        @Override
        public void onClose() {
            int n = Process.getThreadPriority(Process.myTid());
            try {
                Process.setThreadPriority(10);
                this.mSession.onClose();
                return;
            }
            finally {
                Process.setThreadPriority(n);
                this.mListener = null;
            }
        }

        @Override
        public void onGetSentenceSuggestionsMultiple(TextInfo[] textInfoArray, int n) {
            try {
                this.mListener.onGetSentenceSuggestions(this.mSession.onGetSentenceSuggestionsMultiple(textInfoArray, n));
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void onGetSuggestionsMultiple(TextInfo[] textInfoArray, int n, boolean bl) {
            int n2 = Process.getThreadPriority(Process.myTid());
            try {
                Process.setThreadPriority(10);
                this.mListener.onGetSuggestions(this.mSession.onGetSuggestionsMultiple(textInfoArray, n, bl));
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
            finally {
                Process.setThreadPriority(n2);
            }
        }
    }

    private static class SentenceLevelAdapter {
        public static final SentenceSuggestionsInfo[] EMPTY_SENTENCE_SUGGESTIONS_INFOS = new SentenceSuggestionsInfo[0];
        private static final SuggestionsInfo EMPTY_SUGGESTIONS_INFO = new SuggestionsInfo(0, null);
        private final WordIterator mWordIterator;

        public SentenceLevelAdapter(Locale locale) {
            this.mWordIterator = new WordIterator(locale);
        }

        private SentenceTextInfoParams getSplitWords(TextInfo textInfo) {
            WordIterator wordIterator = this.mWordIterator;
            String string2 = textInfo.getText();
            int n = textInfo.getCookie();
            int n2 = string2.length();
            ArrayList<SentenceWordItem> arrayList = new ArrayList<SentenceWordItem>();
            wordIterator.setCharSequence(string2, 0, string2.length());
            int n3 = wordIterator.following(0);
            int n4 = wordIterator.getBeginning(n3);
            while (true) {
                block6: {
                    block5: {
                        if (n4 > n2 || n3 == -1 || n4 == -1) break block5;
                        if (n3 >= 0 && n3 > n4) {
                            CharSequence charSequence = string2.subSequence(n4, n3);
                            arrayList.add(new SentenceWordItem(new TextInfo(charSequence, 0, charSequence.length(), n, charSequence.hashCode()), n4, n3));
                        }
                        if ((n3 = wordIterator.following(n3)) != -1) break block6;
                    }
                    return new SentenceTextInfoParams(textInfo, arrayList);
                }
                n4 = wordIterator.getBeginning(n3);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public static SentenceSuggestionsInfo reconstructSuggestions(SentenceTextInfoParams sentenceTextInfoParams, SuggestionsInfo[] suggestionsInfoArray) {
            if (suggestionsInfoArray == null || suggestionsInfoArray.length == 0 || sentenceTextInfoParams == null) {
                return null;
            }
            int n = sentenceTextInfoParams.mOriginalTextInfo.getCookie();
            int n2 = sentenceTextInfoParams.mOriginalTextInfo.getSequence();
            int n3 = sentenceTextInfoParams.mSize;
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            SuggestionsInfo[] suggestionsInfoArray2 = new SuggestionsInfo[n3];
            int n4 = 0;
            while (true) {
                SuggestionsInfo suggestionsInfo;
                block5: {
                    if (n4 >= n3) {
                        return new SentenceSuggestionsInfo(suggestionsInfoArray2, nArray, nArray2);
                    }
                    SentenceWordItem sentenceWordItem = sentenceTextInfoParams.mItems.get(n4);
                    int n5 = 0;
                    while (true) {
                        block7: {
                            block6: {
                                int n6 = suggestionsInfoArray.length;
                                suggestionsInfo = null;
                                if (n5 >= n6) break block6;
                                SuggestionsInfo suggestionsInfo2 = suggestionsInfoArray[n5];
                                if (suggestionsInfo2 == null || suggestionsInfo2.getSequence() != sentenceWordItem.mTextInfo.getSequence()) break block7;
                                suggestionsInfo = suggestionsInfo2;
                                suggestionsInfo.setCookieAndSequence(n, n2);
                            }
                            nArray[n4] = sentenceWordItem.mStart;
                            nArray2[n4] = sentenceWordItem.mLength;
                            if (suggestionsInfo == null) break;
                            break block5;
                        }
                        ++n5;
                    }
                    suggestionsInfo = EMPTY_SUGGESTIONS_INFO;
                }
                suggestionsInfoArray2[n4] = suggestionsInfo;
                ++n4;
            }
        }

        public static class SentenceTextInfoParams {
            final ArrayList<SentenceWordItem> mItems;
            final TextInfo mOriginalTextInfo;
            final int mSize;

            public SentenceTextInfoParams(TextInfo textInfo, ArrayList<SentenceWordItem> arrayList) {
                this.mOriginalTextInfo = textInfo;
                this.mItems = arrayList;
                this.mSize = arrayList.size();
            }
        }

        public static class SentenceWordItem {
            public final int mLength;
            public final int mStart;
            public final TextInfo mTextInfo;

            public SentenceWordItem(TextInfo textInfo, int n, int n2) {
                this.mTextInfo = textInfo;
                this.mStart = n;
                this.mLength = n2 - n;
            }
        }
    }

    public static abstract class Session {
        private InternalISpellCheckerSession mInternalSession;
        private volatile SentenceLevelAdapter mSentenceLevelAdapter;

        public Bundle getBundle() {
            return this.mInternalSession.getBundle();
        }

        public String getLocale() {
            return this.mInternalSession.getLocale();
        }

        public void onCancel() {
        }

        public void onClose() {
        }

        public abstract void onCreate();

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public SentenceSuggestionsInfo[] onGetSentenceSuggestionsMultiple(TextInfo[] textInfoArray, int n) {
            if (textInfoArray == null) return SentenceLevelAdapter.EMPTY_SENTENCE_SUGGESTIONS_INFOS;
            if (textInfoArray.length == 0) {
                return SentenceLevelAdapter.EMPTY_SENTENCE_SUGGESTIONS_INFOS;
            }
            if (this.mSentenceLevelAdapter == null) {
                synchronized (this) {
                    String string2;
                    if (this.mSentenceLevelAdapter == null && !TextUtils.isEmpty(string2 = this.getLocale())) {
                        this.mSentenceLevelAdapter = new SentenceLevelAdapter(new Locale(string2));
                    }
                }
            }
            if (this.mSentenceLevelAdapter == null) {
                return SentenceLevelAdapter.EMPTY_SENTENCE_SUGGESTIONS_INFOS;
            }
            int n2 = textInfoArray.length;
            SentenceSuggestionsInfo[] sentenceSuggestionsInfoArray = new SentenceSuggestionsInfo[n2];
            int n3 = 0;
            while (n3 < n2) {
                SentenceLevelAdapter.SentenceTextInfoParams sentenceTextInfoParams = this.mSentenceLevelAdapter.getSplitWords(textInfoArray[n3]);
                ArrayList<SentenceLevelAdapter.SentenceWordItem> arrayList = sentenceTextInfoParams.mItems;
                int n4 = arrayList.size();
                TextInfo[] textInfoArray2 = new TextInfo[n4];
                for (int i = 0; i < n4; ++i) {
                    textInfoArray2[i] = arrayList.get((int)i).mTextInfo;
                }
                sentenceSuggestionsInfoArray[n3] = SentenceLevelAdapter.reconstructSuggestions(sentenceTextInfoParams, this.onGetSuggestionsMultiple(textInfoArray2, n, true));
                ++n3;
            }
            return sentenceSuggestionsInfoArray;
        }

        public abstract SuggestionsInfo onGetSuggestions(TextInfo var1, int var2);

        public SuggestionsInfo[] onGetSuggestionsMultiple(TextInfo[] textInfoArray, int n, boolean bl) {
            int n2 = textInfoArray.length;
            SuggestionsInfo[] suggestionsInfoArray = new SuggestionsInfo[n2];
            for (int i = 0; i < n2; ++i) {
                suggestionsInfoArray[i] = this.onGetSuggestions(textInfoArray[i], n);
                suggestionsInfoArray[i].setCookieAndSequence(textInfoArray[i].getCookie(), textInfoArray[i].getSequence());
            }
            return suggestionsInfoArray;
        }

        public final void setInternalISpellCheckerSession(InternalISpellCheckerSession internalISpellCheckerSession) {
            this.mInternalSession = internalISpellCheckerSession;
        }
    }

    private static class SpellCheckerServiceBinder
    extends ISpellCheckerService.Stub {
        private final WeakReference<SpellCheckerService> mInternalServiceRef;

        public SpellCheckerServiceBinder(SpellCheckerService spellCheckerService) {
            this.mInternalServiceRef = new WeakReference<SpellCheckerService>(spellCheckerService);
        }

        @Override
        public ISpellCheckerSession getISpellCheckerSession(String string2, ISpellCheckerSessionListener iSpellCheckerSessionListener, Bundle bundle) {
            SpellCheckerService spellCheckerService = (SpellCheckerService)this.mInternalServiceRef.get();
            if (spellCheckerService == null) {
                return null;
            }
            Session session = spellCheckerService.createSession();
            InternalISpellCheckerSession internalISpellCheckerSession = new InternalISpellCheckerSession(string2, iSpellCheckerSessionListener, bundle, session);
            session.onCreate();
            return internalISpellCheckerSession;
        }
    }
}

