/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.content.Context;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class Condition
implements Parcelable {
    public static final Parcelable.Creator<Condition> CREATOR = new Parcelable.Creator<Condition>(){

        @Override
        public Condition createFromParcel(Parcel parcel) {
            return new Condition(parcel);
        }

        public Condition[] newArray(int n) {
            return new Condition[n];
        }
    };
    public static final int FLAG_RELEVANT_ALWAYS = 2;
    public static final int FLAG_RELEVANT_NOW = 1;
    public static final String SCHEME = "condition";
    public static final int STATE_ERROR = 3;
    public static final int STATE_FALSE = 0;
    public static final int STATE_TRUE = 1;
    public static final int STATE_UNKNOWN = 2;
    public final int flags;
    public final int icon;
    public final Uri id;
    public final String line1;
    public final String line2;
    public final int state;
    public final String summary;

    public Condition(Uri uri, String string2, String string3, String string4, int n, int n2, int n3) {
        if (uri == null) {
            throw new IllegalArgumentException("id is required");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("summary is required");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("line1 is required");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("line2 is required");
        }
        if (!Condition.isValidState(n2)) {
            throw new IllegalArgumentException("state is invalid: " + n2);
        }
        this.id = uri;
        this.summary = string2;
        this.line1 = string3;
        this.line2 = string4;
        this.icon = n;
        this.state = n2;
        this.flags = n3;
    }

    private Condition(Parcel parcel) {
        this((Uri)parcel.readParcelable(Condition.class.getClassLoader()), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readInt(), parcel.readInt(), parcel.readInt());
    }

    public static boolean isValidId(Uri uri, String string2) {
        return uri != null && uri.getScheme().equals(SCHEME) && uri.getAuthority().equals(string2);
    }

    private static boolean isValidState(int n) {
        return n >= 0 && n <= 3;
    }

    public static Uri.Builder newId(Context context) {
        return new Uri.Builder().scheme(SCHEME).authority(context.getPackageName());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String relevanceToString(int n) {
        boolean bl = true;
        boolean bl2 = (n & 1) != 0 ? bl : false;
        if ((n & 2) == 0) {
            bl = false;
        }
        if (!bl2 && !bl) {
            return "NONE";
        }
        if (bl2 && bl) {
            return "NOW, ALWAYS";
        }
        if (bl2) {
            return "NOW";
        }
        return "ALWAYS";
    }

    public static String stateToString(int n) {
        if (n == 0) {
            return "STATE_FALSE";
        }
        if (n == 1) {
            return "STATE_TRUE";
        }
        if (n == 2) {
            return "STATE_UNKNOWN";
        }
        if (n == 3) {
            return "STATE_ERROR";
        }
        throw new IllegalArgumentException("state is invalid: " + n);
    }

    public Condition copy() {
        Parcel parcel = Parcel.obtain();
        try {
            this.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            Condition condition = new Condition(parcel);
            return condition;
        }
        finally {
            parcel.recycle();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (!(object instanceof Condition)) {
            return false;
        }
        if (object == this) return bl;
        Condition condition = (Condition)object;
        if (!Objects.equals(condition.id, this.id)) return false;
        if (!Objects.equals(condition.summary, this.summary)) return false;
        if (!Objects.equals(condition.line1, this.line1)) return false;
        if (!Objects.equals(condition.line2, this.line2)) return false;
        if (condition.icon != this.icon) return false;
        if (condition.state != this.state) return false;
        if (condition.flags == this.flags) return bl;
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.id, this.summary, this.line1, this.line2, this.icon, this.state, this.flags};
        return Objects.hash(objectArray);
    }

    public String toString() {
        return Condition.class.getSimpleName() + '[' + "id=" + this.id + ",summary=" + this.summary + ",line1=" + this.line1 + ",line2=" + this.line2 + ",icon=" + this.icon + ",state=" + Condition.stateToString(this.state) + ",flags=" + this.flags + ']';
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeParcelable(this.id, 0);
        parcel.writeString(this.summary);
        parcel.writeString(this.line1);
        parcel.writeString(this.line2);
        parcel.writeInt(this.icon);
        parcel.writeInt(this.state);
        parcel.writeInt(this.flags);
    }
}

