/*
 * Decompiled with CFR 0.152.
 */
package android.service.fingerprint;

import android.app.ActivityManagerNative;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.provider.Settings;
import android.service.fingerprint.FingerprintManagerReceiver;
import android.service.fingerprint.FingerprintUtils;
import android.service.fingerprint.IFingerprintService;
import android.service.fingerprint.IFingerprintServiceReceiver;
import android.util.Log;
import android.util.Slog;

public class FingerprintManager {
    private static final boolean DEBUG = true;
    public static final int FINGERPRINT_ACQUIRED = 1;
    public static final int FINGERPRINT_ACQUIRED_GOOD = 0;
    public static final int FINGERPRINT_ACQUIRED_IMAGER_DIRTY = 4;
    public static final int FINGERPRINT_ACQUIRED_INSUFFICIENT = 2;
    public static final int FINGERPRINT_ACQUIRED_PARTIAL = 1;
    public static final int FINGERPRINT_ACQUIRED_TOO_FAST = 16;
    public static final int FINGERPRINT_ACQUIRED_TOO_SLOW = 8;
    public static final int FINGERPRINT_ERROR = -1;
    public static final int FINGERPRINT_ERROR_HW_UNAVAILABLE = 1;
    public static final int FINGERPRINT_ERROR_NO_RECEIVER = -10;
    public static final int FINGERPRINT_ERROR_NO_SPACE = 4;
    public static final int FINGERPRINT_ERROR_TIMEOUT = 3;
    public static final int FINGERPRINT_ERROR_UNABLE_TO_PROCESS = 2;
    public static final int FINGERPRINT_PROCESSED = 2;
    public static final int FINGERPRINT_TEMPLATE_ENROLLING = 3;
    public static final int FINGERPRINT_TEMPLATE_REMOVED = 4;
    private static final int MSG_ACQUIRED = 101;
    private static final int MSG_ENROLL_RESULT = 100;
    private static final int MSG_ERROR = 103;
    private static final int MSG_PROCESSED = 102;
    private static final int MSG_REMOVED = 104;
    private static final String TAG = "FingerprintManager";
    private FingerprintManagerReceiver mClientReceiver;
    private Context mContext;
    private Handler mHandler;
    private IFingerprintService mService;
    private IFingerprintServiceReceiver mServiceReceiver;
    private IBinder mToken = new Binder();

    public FingerprintManager(Context context, IFingerprintService iFingerprintService) {
        this.mHandler = new Handler(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void handleMessage(Message message) {
                if (FingerprintManager.this.mClientReceiver == null) return;
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 100: {
                        FingerprintManager.this.mClientReceiver.onEnrollResult(message.arg1, message.arg2);
                        return;
                    }
                    case 101: {
                        FingerprintManager.this.mClientReceiver.onAcquired(message.arg1);
                        return;
                    }
                    case 102: {
                        FingerprintManager.this.mClientReceiver.onProcessed(message.arg1);
                        return;
                    }
                    case 103: {
                        FingerprintManager.this.mClientReceiver.onError(message.arg1);
                        return;
                    }
                    case 104: 
                }
                FingerprintManager.this.mClientReceiver.onRemoved(message.arg1);
            }
        };
        this.mServiceReceiver = new IFingerprintServiceReceiver.Stub(){

            @Override
            public void onAcquired(int n) {
                FingerprintManager.this.mHandler.obtainMessage(101, n, 0).sendToTarget();
            }

            @Override
            public void onEnrollResult(int n, int n2) {
                FingerprintManager.this.mHandler.obtainMessage(100, n, n2).sendToTarget();
            }

            @Override
            public void onError(int n) {
                FingerprintManager.this.mHandler.obtainMessage(103, n, 0).sendToTarget();
            }

            @Override
            public void onProcessed(int n) {
                FingerprintManager.this.mHandler.obtainMessage(102, n, 0).sendToTarget();
            }

            @Override
            public void onRemoved(int n) {
                FingerprintManager.this.mHandler.obtainMessage(104, n, 0).sendToTarget();
            }
        };
        this.mContext = context;
        this.mService = iFingerprintService;
        if (this.mService == null) {
            Slog.v(TAG, "FingerprintManagerService was null");
        }
    }

    private int getCurrentUserId() {
        try {
            int n = ActivityManagerNative.getDefault().getCurrentUser().id;
            return n;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed to get current user id\n");
            return -10000;
        }
    }

    private void sendError(int n, int n2, int n3) {
        this.mHandler.obtainMessage(n, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enroll(long l) {
        if (this.mServiceReceiver == null) {
            this.sendError(-10, 0, 0);
            return;
        } else {
            if (this.mService == null) return;
            try {
                this.mService.enroll(this.mToken, l, this.getCurrentUserId());
                return;
            }
            catch (RemoteException remoteException) {
                Log.v(TAG, "Remote exception while enrolling: ", remoteException);
                this.sendError(1, 0, 0);
                return;
            }
        }
    }

    public void enrollCancel() {
        if (this.mServiceReceiver == null) {
            this.sendError(-10, 0, 0);
            return;
        }
        if (this.mService != null) {
            try {
                this.mService.enrollCancel(this.mToken, this.getCurrentUserId());
                this.mClientReceiver = null;
                return;
            }
            catch (RemoteException remoteException) {
                Log.v(TAG, "Remote exception in enrollCancel(): ", remoteException);
                this.sendError(1, 0, 0);
                return;
            }
        }
        Log.w(TAG, "enrollCancel(): Service not connected!");
    }

    public boolean enrolledAndEnabled() {
        ContentResolver contentResolver = this.mContext.getContentResolver();
        int n = Settings.Secure.getInt(contentResolver, "fingerprint_enabled", 0);
        boolean bl = false;
        if (n != 0) {
            int n2 = FingerprintUtils.getFingerprintIdsForUser(contentResolver, this.getCurrentUserId()).length;
            bl = false;
            if (n2 > 0) {
                bl = true;
            }
        }
        return bl;
    }

    public void remove(int n) {
        if (this.mServiceReceiver == null) {
            this.sendError(-10, 0, 0);
            return;
        }
        if (this.mService != null) {
            try {
                this.mService.remove(this.mToken, n, this.getCurrentUserId());
                return;
            }
            catch (RemoteException remoteException) {
                Log.v(TAG, "Remote exception during remove of fingerprintId: " + n, remoteException);
                return;
            }
        }
        Log.w(TAG, "remove(): Service not connected!");
        this.sendError(1, 0, 0);
    }

    public void startListening(FingerprintManagerReceiver fingerprintManagerReceiver) {
        this.mClientReceiver = fingerprintManagerReceiver;
        if (this.mService != null) {
            try {
                this.mService.startListening(this.mToken, this.mServiceReceiver, this.getCurrentUserId());
                return;
            }
            catch (RemoteException remoteException) {
                Log.v(TAG, "Remote exception in startListening(): ", remoteException);
                return;
            }
        }
        Log.w(TAG, "startListening(): Service not connected!");
        this.sendError(1, 0, 0);
    }

    public void stopListening() {
        if (this.mService != null) {
            try {
                this.mService.stopListening(this.mToken, this.getCurrentUserId());
                this.mClientReceiver = null;
                return;
            }
            catch (RemoteException remoteException) {
                Log.v(TAG, "Remote exception in stopListening(): ", remoteException);
                return;
            }
        }
        Log.w(TAG, "stopListening(): Service not connected!");
        this.sendError(1, 0, 0);
    }
}

