/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import android.renderscript.Script;
import android.renderscript.Type;
import java.util.ArrayList;

public final class ScriptGroup
extends BaseObj {
    IO[] mInputs;
    IO[] mOutputs;

    ScriptGroup(long l, RenderScript renderScript) {
        super(l, renderScript);
    }

    public void execute() {
        this.mRS.nScriptGroupExecute(this.getID(this.mRS));
    }

    public void setInput(Script.KernelID kernelID, Allocation allocation) {
        for (int i = 0; i < this.mInputs.length; ++i) {
            if (this.mInputs[i].mKID != kernelID) continue;
            this.mInputs[i].mAllocation = allocation;
            this.mRS.nScriptGroupSetInput(this.getID(this.mRS), kernelID.getID(this.mRS), this.mRS.safeID(allocation));
            return;
        }
        throw new RSIllegalArgumentException("Script not found");
    }

    public void setOutput(Script.KernelID kernelID, Allocation allocation) {
        for (int i = 0; i < this.mOutputs.length; ++i) {
            if (this.mOutputs[i].mKID != kernelID) continue;
            this.mOutputs[i].mAllocation = allocation;
            this.mRS.nScriptGroupSetOutput(this.getID(this.mRS), kernelID.getID(this.mRS), this.mRS.safeID(allocation));
            return;
        }
        throw new RSIllegalArgumentException("Script not found");
    }

    public static final class Builder {
        private int mKernelCount;
        private ArrayList<ConnectLine> mLines;
        private ArrayList<Node> mNodes = new ArrayList();
        private RenderScript mRS;

        public Builder(RenderScript renderScript) {
            this.mLines = new ArrayList();
            this.mRS = renderScript;
        }

        private Node findNode(Script.KernelID kernelID) {
            for (int i = 0; i < this.mNodes.size(); ++i) {
                Node node = this.mNodes.get(i);
                for (int j = 0; j < node.mKernels.size(); ++j) {
                    if (kernelID != node.mKernels.get(j)) continue;
                    return node;
                }
            }
            return null;
        }

        private Node findNode(Script script) {
            for (int i = 0; i < this.mNodes.size(); ++i) {
                if (script != this.mNodes.get((int)i).mScript) continue;
                return this.mNodes.get(i);
            }
            return null;
        }

        private void mergeDAGs(int n, int n2) {
            for (int i = 0; i < this.mNodes.size(); ++i) {
                if (this.mNodes.get((int)i).dagNumber != n2) continue;
                this.mNodes.get((int)i).dagNumber = n;
            }
        }

        private void validateCycle(Node node, Node node2) {
            for (int i = 0; i < node.mOutputs.size(); ++i) {
                ConnectLine connectLine = node.mOutputs.get(i);
                if (connectLine.mToK != null) {
                    Node node3 = this.findNode(connectLine.mToK.mScript);
                    if (node3.equals(node2)) {
                        throw new RSInvalidStateException("Loops in group not allowed.");
                    }
                    this.validateCycle(node3, node2);
                }
                if (connectLine.mToF == null) continue;
                Node node4 = this.findNode(connectLine.mToF.mScript);
                if (node4.equals(node2)) {
                    throw new RSInvalidStateException("Loops in group not allowed.");
                }
                this.validateCycle(node4, node2);
            }
        }

        private void validateDAG() {
            for (int i = 0; i < this.mNodes.size(); ++i) {
                Node node = this.mNodes.get(i);
                if (node.mInputs.size() != 0) continue;
                if (node.mOutputs.size() == 0 && this.mNodes.size() > 1) {
                    throw new RSInvalidStateException("Groups cannot contain unconnected scripts");
                }
                this.validateDAGRecurse(node, i + 1);
            }
            int n = this.mNodes.get((int)0).dagNumber;
            for (int i = 0; i < this.mNodes.size(); ++i) {
                if (this.mNodes.get((int)i).dagNumber == n) continue;
                throw new RSInvalidStateException("Multiple DAGs in group not allowed.");
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void validateDAGRecurse(Node node, int n) {
            if (node.dagNumber != 0 && node.dagNumber != n) {
                this.mergeDAGs(node.dagNumber, n);
                return;
            } else {
                node.dagNumber = n;
                for (int i = 0; i < node.mOutputs.size(); ++i) {
                    ConnectLine connectLine = node.mOutputs.get(i);
                    if (connectLine.mToK != null) {
                        this.validateDAGRecurse(this.findNode(connectLine.mToK.mScript), n);
                    }
                    if (connectLine.mToF == null) continue;
                    this.validateDAGRecurse(this.findNode(connectLine.mToF.mScript), n);
                }
            }
        }

        public Builder addConnection(Type type, Script.KernelID kernelID, Script.FieldID fieldID) {
            Node node = this.findNode(kernelID);
            if (node == null) {
                throw new RSInvalidStateException("From script not found.");
            }
            Node node2 = this.findNode(fieldID.mScript);
            if (node2 == null) {
                throw new RSInvalidStateException("To script not found.");
            }
            ConnectLine connectLine = new ConnectLine(type, kernelID, fieldID);
            this.mLines.add(new ConnectLine(type, kernelID, fieldID));
            node.mOutputs.add(connectLine);
            node2.mInputs.add(connectLine);
            this.validateCycle(node, node);
            return this;
        }

        public Builder addConnection(Type type, Script.KernelID kernelID, Script.KernelID kernelID2) {
            Node node = this.findNode(kernelID);
            if (node == null) {
                throw new RSInvalidStateException("From script not found.");
            }
            Node node2 = this.findNode(kernelID2);
            if (node2 == null) {
                throw new RSInvalidStateException("To script not found.");
            }
            ConnectLine connectLine = new ConnectLine(type, kernelID, kernelID2);
            this.mLines.add(new ConnectLine(type, kernelID, kernelID2));
            node.mOutputs.add(connectLine);
            node2.mInputs.add(connectLine);
            this.validateCycle(node, node);
            return this;
        }

        public Builder addKernel(Script.KernelID kernelID) {
            if (this.mLines.size() != 0) {
                throw new RSInvalidStateException("Kernels may not be added once connections exist.");
            }
            if (this.findNode(kernelID) != null) {
                return this;
            }
            this.mKernelCount = 1 + this.mKernelCount;
            Node node = this.findNode(kernelID.mScript);
            if (node == null) {
                node = new Node(kernelID.mScript);
                this.mNodes.add(node);
            }
            node.mKernels.add(kernelID);
            return this;
        }

        public ScriptGroup create() {
            if (this.mNodes.size() == 0) {
                throw new RSInvalidStateException("Empty script groups are not allowed");
            }
            for (int i = 0; i < this.mNodes.size(); ++i) {
                this.mNodes.get((int)i).dagNumber = 0;
            }
            this.validateDAG();
            ArrayList<IO> arrayList = new ArrayList<IO>();
            ArrayList<IO> arrayList2 = new ArrayList<IO>();
            long[] lArray = new long[this.mKernelCount];
            int n = 0;
            for (int i = 0; i < this.mNodes.size(); ++i) {
                Node node = this.mNodes.get(i);
                for (int j = 0; j < node.mKernels.size(); ++j) {
                    Script.KernelID kernelID = node.mKernels.get(j);
                    int n2 = n + 1;
                    lArray[n] = kernelID.getID(this.mRS);
                    boolean bl = false;
                    boolean bl2 = false;
                    for (int k = 0; k < node.mInputs.size(); ++k) {
                        if (node.mInputs.get((int)k).mToK != kernelID) continue;
                        bl = true;
                    }
                    for (int k = 0; k < node.mOutputs.size(); ++k) {
                        if (node.mOutputs.get((int)k).mFrom != kernelID) continue;
                        bl2 = true;
                    }
                    if (!bl) {
                        arrayList.add(new IO(kernelID));
                    }
                    if (!bl2) {
                        arrayList2.add(new IO(kernelID));
                    }
                    n = n2;
                }
            }
            int n3 = this.mKernelCount;
            if (n != n3) {
                throw new RSRuntimeException("Count mismatch, should not happen.");
            }
            long[] lArray2 = new long[this.mLines.size()];
            long[] lArray3 = new long[this.mLines.size()];
            long[] lArray4 = new long[this.mLines.size()];
            long[] lArray5 = new long[this.mLines.size()];
            for (int i = 0; i < this.mLines.size(); ++i) {
                ConnectLine connectLine = this.mLines.get(i);
                lArray2[i] = connectLine.mFrom.getID(this.mRS);
                if (connectLine.mToK != null) {
                    lArray3[i] = connectLine.mToK.getID(this.mRS);
                }
                if (connectLine.mToF != null) {
                    lArray4[i] = connectLine.mToF.getID(this.mRS);
                }
                lArray5[i] = connectLine.mAllocationType.getID(this.mRS);
            }
            long l = this.mRS.nScriptGroupCreate(lArray, lArray2, lArray3, lArray4, lArray5);
            if (l == 0L) {
                throw new RSRuntimeException("Object creation error, should not happen.");
            }
            ScriptGroup scriptGroup = new ScriptGroup(l, this.mRS);
            scriptGroup.mOutputs = new IO[arrayList2.size()];
            for (int i = 0; i < arrayList2.size(); ++i) {
                scriptGroup.mOutputs[i] = (IO)arrayList2.get(i);
            }
            scriptGroup.mInputs = new IO[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                scriptGroup.mInputs[i] = (IO)arrayList.get(i);
            }
            return scriptGroup;
        }
    }

    static class ConnectLine {
        Type mAllocationType;
        Script.KernelID mFrom;
        Script.FieldID mToF;
        Script.KernelID mToK;

        ConnectLine(Type type, Script.KernelID kernelID, Script.FieldID fieldID) {
            this.mFrom = kernelID;
            this.mToF = fieldID;
            this.mAllocationType = type;
        }

        ConnectLine(Type type, Script.KernelID kernelID, Script.KernelID kernelID2) {
            this.mFrom = kernelID;
            this.mToK = kernelID2;
            this.mAllocationType = type;
        }
    }

    static class IO {
        Allocation mAllocation;
        Script.KernelID mKID;

        IO(Script.KernelID kernelID) {
            this.mKID = kernelID;
        }
    }

    static class Node {
        int dagNumber;
        ArrayList<ConnectLine> mInputs;
        ArrayList<Script.KernelID> mKernels = new ArrayList();
        Node mNext;
        ArrayList<ConnectLine> mOutputs;
        Script mScript;

        Node(Script script) {
            this.mInputs = new ArrayList();
            this.mOutputs = new ArrayList();
            this.mScript = script;
        }
    }
}

