/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Element;
import android.renderscript.Program;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;

public class ProgramVertex
extends Program {
    ProgramVertex(long l, RenderScript renderScript) {
        super(l, renderScript);
    }

    public Element getInput(int n) {
        if (n < 0 || n >= this.mInputs.length) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        return this.mInputs[n];
    }

    public int getInputCount() {
        if (this.mInputs != null) {
            return this.mInputs.length;
        }
        return 0;
    }

    public static class Builder
    extends Program.BaseProgramBuilder {
        public Builder(RenderScript renderScript) {
            super(renderScript);
        }

        public Builder addInput(Element element) throws IllegalStateException {
            if (this.mInputCount >= 8) {
                throw new RSIllegalArgumentException("Max input count exceeded.");
            }
            if (element.isComplex()) {
                throw new RSIllegalArgumentException("Complex elements not allowed.");
            }
            Element[] elementArray = this.mInputs;
            int n = this.mInputCount;
            this.mInputCount = n + 1;
            elementArray[n] = element;
            return this;
        }

        public ProgramVertex create() {
            this.mRS.validate();
            long[] lArray = new long[2 * (this.mInputCount + this.mOutputCount + this.mConstantCount + this.mTextureCount)];
            String[] stringArray = new String[this.mTextureCount];
            int n = 0;
            for (int i = 0; i < this.mInputCount; ++i) {
                int n2 = n + 1;
                lArray[n] = Program.ProgramParam.INPUT.mID;
                n = n2 + 1;
                lArray[n2] = this.mInputs[i].getID(this.mRS);
            }
            for (int i = 0; i < this.mOutputCount; ++i) {
                int n3 = n + 1;
                lArray[n] = Program.ProgramParam.OUTPUT.mID;
                n = n3 + 1;
                lArray[n3] = this.mOutputs[i].getID(this.mRS);
            }
            for (int i = 0; i < this.mConstantCount; ++i) {
                int n4 = n + 1;
                lArray[n] = Program.ProgramParam.CONSTANT.mID;
                n = n4 + 1;
                lArray[n4] = this.mConstants[i].getID(this.mRS);
            }
            for (int i = 0; i < this.mTextureCount; ++i) {
                int n5 = n + 1;
                lArray[n] = Program.ProgramParam.TEXTURE_TYPE.mID;
                n = n5 + 1;
                lArray[n5] = this.mTextureTypes[i].mID;
                stringArray[i] = this.mTextureNames[i];
            }
            ProgramVertex programVertex = new ProgramVertex(this.mRS.nProgramVertexCreate(this.mShader, stringArray, lArray), this.mRS);
            this.initProgram(programVertex);
            return programVertex;
        }
    }
}

