/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Matrix3f;

public class Matrix4f {
    final float[] mMat = new float[16];

    public Matrix4f() {
        this.loadIdentity();
    }

    public Matrix4f(float[] fArray) {
        System.arraycopy((float[])fArray, (int)0, (float[])this.mMat, (int)0, (int)this.mMat.length);
    }

    private float computeCofactor(int n, int n2) {
        int n3 = (n + 1) % 4;
        int n4 = (n + 2) % 4;
        int n5 = (n + 3) % 4;
        int n6 = (n2 + 1) % 4;
        int n7 = (n2 + 2) % 4;
        int n8 = (n2 + 3) % 4;
        float f = this.mMat[n3 + n6 * 4] * (this.mMat[n4 + n7 * 4] * this.mMat[n5 + n8 * 4] - this.mMat[n4 + n8 * 4] * this.mMat[n5 + n7 * 4]) - this.mMat[n3 + n7 * 4] * (this.mMat[n4 + n6 * 4] * this.mMat[n5 + n8 * 4] - this.mMat[n4 + n8 * 4] * this.mMat[n5 + n6 * 4]) + this.mMat[n3 + n8 * 4] * (this.mMat[n4 + n6 * 4] * this.mMat[n5 + n7 * 4] - this.mMat[n4 + n7 * 4] * this.mMat[n5 + n6 * 4]);
        if ((1 & n + n2) != 0) {
            return -f;
        }
        return f;
    }

    public float get(int n, int n2) {
        return this.mMat[n2 + n * 4];
    }

    public float[] getArray() {
        return this.mMat;
    }

    public boolean inverse() {
        Matrix4f matrix4f = new Matrix4f();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                matrix4f.mMat[j + i * 4] = this.computeCofactor(i, j);
            }
        }
        float f = this.mMat[0] * matrix4f.mMat[0] + this.mMat[4] * matrix4f.mMat[1] + this.mMat[8] * matrix4f.mMat[2] + this.mMat[12] * matrix4f.mMat[3];
        if ((double)Math.abs(f) < 1.0E-6) {
            return false;
        }
        float f2 = 1.0f / f;
        for (int i = 0; i < 16; ++i) {
            this.mMat[i] = f2 * matrix4f.mMat[i];
        }
        return true;
    }

    public boolean inverseTranspose() {
        Matrix4f matrix4f = new Matrix4f();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                matrix4f.mMat[i + j * 4] = this.computeCofactor(i, j);
            }
        }
        float f = this.mMat[0] * matrix4f.mMat[0] + this.mMat[4] * matrix4f.mMat[4] + this.mMat[8] * matrix4f.mMat[8] + this.mMat[12] * matrix4f.mMat[12];
        if ((double)Math.abs(f) < 1.0E-6) {
            return false;
        }
        float f2 = 1.0f / f;
        for (int i = 0; i < 16; ++i) {
            this.mMat[i] = f2 * matrix4f.mMat[i];
        }
        return true;
    }

    public void load(Matrix3f matrix3f) {
        this.mMat[0] = matrix3f.mMat[0];
        this.mMat[1] = matrix3f.mMat[1];
        this.mMat[2] = matrix3f.mMat[2];
        this.mMat[3] = 0.0f;
        this.mMat[4] = matrix3f.mMat[3];
        this.mMat[5] = matrix3f.mMat[4];
        this.mMat[6] = matrix3f.mMat[5];
        this.mMat[7] = 0.0f;
        this.mMat[8] = matrix3f.mMat[6];
        this.mMat[9] = matrix3f.mMat[7];
        this.mMat[10] = matrix3f.mMat[8];
        this.mMat[11] = 0.0f;
        this.mMat[12] = 0.0f;
        this.mMat[13] = 0.0f;
        this.mMat[14] = 0.0f;
        this.mMat[15] = 1.0f;
    }

    public void load(Matrix4f matrix4f) {
        System.arraycopy((float[])matrix4f.getArray(), (int)0, (float[])this.mMat, (int)0, (int)this.mMat.length);
    }

    public void loadFrustum(float f, float f2, float f3, float f4, float f5, float f6) {
        this.loadIdentity();
        this.mMat[0] = 2.0f * f5 / (f2 - f);
        this.mMat[5] = 2.0f * f5 / (f4 - f3);
        this.mMat[8] = (f2 + f) / (f2 - f);
        this.mMat[9] = (f4 + f3) / (f4 - f3);
        this.mMat[10] = -(f6 + f5) / (f6 - f5);
        this.mMat[11] = -1.0f;
        this.mMat[14] = f5 * (-2.0f * f6) / (f6 - f5);
        this.mMat[15] = 0.0f;
    }

    public void loadIdentity() {
        this.mMat[0] = 1.0f;
        this.mMat[1] = 0.0f;
        this.mMat[2] = 0.0f;
        this.mMat[3] = 0.0f;
        this.mMat[4] = 0.0f;
        this.mMat[5] = 1.0f;
        this.mMat[6] = 0.0f;
        this.mMat[7] = 0.0f;
        this.mMat[8] = 0.0f;
        this.mMat[9] = 0.0f;
        this.mMat[10] = 1.0f;
        this.mMat[11] = 0.0f;
        this.mMat[12] = 0.0f;
        this.mMat[13] = 0.0f;
        this.mMat[14] = 0.0f;
        this.mMat[15] = 1.0f;
    }

    public void loadMultiply(Matrix4f matrix4f, Matrix4f matrix4f2) {
        for (int i = 0; i < 4; ++i) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            for (int j = 0; j < 4; ++j) {
                float f5 = matrix4f2.get(i, j);
                f += f5 * matrix4f.get(j, 0);
                f2 += f5 * matrix4f.get(j, 1);
                f3 += f5 * matrix4f.get(j, 2);
                f4 += f5 * matrix4f.get(j, 3);
            }
            this.set(i, 0, f);
            this.set(i, 1, f2);
            this.set(i, 2, f3);
            this.set(i, 3, f4);
        }
    }

    public void loadOrtho(float f, float f2, float f3, float f4, float f5, float f6) {
        this.loadIdentity();
        this.mMat[0] = 2.0f / (f2 - f);
        this.mMat[5] = 2.0f / (f4 - f3);
        this.mMat[10] = -2.0f / (f6 - f5);
        this.mMat[12] = -(f2 + f) / (f2 - f);
        this.mMat[13] = -(f4 + f3) / (f4 - f3);
        this.mMat[14] = -(f6 + f5) / (f6 - f5);
    }

    public void loadOrthoWindow(int n, int n2) {
        this.loadOrtho(0.0f, n, n2, 0.0f, -1.0f, 1.0f);
    }

    public void loadPerspective(float f, float f2, float f3, float f4) {
        float f5 = f3 * (float)Math.tan((float)(Math.PI * (double)f / 360.0));
        float f6 = -f5;
        this.loadFrustum(f6 * f2, f5 * f2, f6, f5, f3, f4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void loadProjectionNormalized(int n, int n2) {
        Matrix4f matrix4f = new Matrix4f();
        Matrix4f matrix4f2 = new Matrix4f();
        if (n > n2) {
            float f = (float)n / (float)n2;
            matrix4f.loadFrustum(-f, f, -1.0f, 1.0f, 1.0f, 100.0f);
        } else {
            float f = (float)n2 / (float)n;
            matrix4f.loadFrustum(-1.0f, 1.0f, -f, f, 1.0f, 100.0f);
        }
        matrix4f2.loadRotate(180.0f, 0.0f, 1.0f, 0.0f);
        matrix4f.loadMultiply(matrix4f, matrix4f2);
        matrix4f2.loadScale(-2.0f, 2.0f, 1.0f);
        matrix4f.loadMultiply(matrix4f, matrix4f2);
        matrix4f2.loadTranslate(0.0f, 0.0f, 2.0f);
        matrix4f.loadMultiply(matrix4f, matrix4f2);
        this.load(matrix4f);
    }

    public void loadRotate(float f, float f2, float f3, float f4) {
        this.mMat[3] = 0.0f;
        this.mMat[7] = 0.0f;
        this.mMat[11] = 0.0f;
        this.mMat[12] = 0.0f;
        this.mMat[13] = 0.0f;
        this.mMat[14] = 0.0f;
        this.mMat[15] = 1.0f;
        float f5 = f * ((float)Math.PI / 180);
        float f6 = (float)Math.cos(f5);
        float f7 = (float)Math.sin(f5);
        float f8 = (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
        if (f8 == 1.0f) {
            float f9 = 1.0f / f8;
            f2 *= f9;
            f3 *= f9;
            f4 *= f9;
        }
        float f10 = 1.0f - f6;
        float f11 = f2 * f3;
        float f12 = f3 * f4;
        float f13 = f4 * f2;
        float f14 = f2 * f7;
        float f15 = f3 * f7;
        float f16 = f4 * f7;
        this.mMat[0] = f6 + f10 * (f2 * f2);
        this.mMat[4] = f11 * f10 - f16;
        this.mMat[8] = f15 + f13 * f10;
        this.mMat[1] = f16 + f11 * f10;
        this.mMat[5] = f6 + f10 * (f3 * f3);
        this.mMat[9] = f12 * f10 - f14;
        this.mMat[2] = f13 * f10 - f15;
        this.mMat[6] = f14 + f12 * f10;
        this.mMat[10] = f6 + f10 * (f4 * f4);
    }

    public void loadScale(float f, float f2, float f3) {
        this.loadIdentity();
        this.mMat[0] = f;
        this.mMat[5] = f2;
        this.mMat[10] = f3;
    }

    public void loadTranslate(float f, float f2, float f3) {
        this.loadIdentity();
        this.mMat[12] = f;
        this.mMat[13] = f2;
        this.mMat[14] = f3;
    }

    public void multiply(Matrix4f matrix4f) {
        Matrix4f matrix4f2 = new Matrix4f();
        matrix4f2.loadMultiply(this, matrix4f);
        this.load(matrix4f2);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.loadRotate(f, f2, f3, f4);
        this.multiply(matrix4f);
    }

    public void scale(float f, float f2, float f3) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.loadScale(f, f2, f3);
        this.multiply(matrix4f);
    }

    public void set(int n, int n2, float f) {
        this.mMat[n2 + n * 4] = f;
    }

    public void translate(float f, float f2, float f3) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.loadTranslate(f, f2, f3);
        this.multiply(matrix4f);
    }

    public void transpose() {
        for (int i = 0; i < 3; ++i) {
            for (int j = i + 1; j < 4; ++j) {
                float f = this.mMat[j + i * 4];
                this.mMat[j + i * 4] = this.mMat[i + j * 4];
                this.mMat[i + j * 4] = f;
            }
        }
    }
}

