/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

public class Matrix3f {
    final float[] mMat = new float[9];

    public Matrix3f() {
        this.loadIdentity();
    }

    public Matrix3f(float[] fArray) {
        System.arraycopy((float[])fArray, (int)0, (float[])this.mMat, (int)0, (int)this.mMat.length);
    }

    public float get(int n, int n2) {
        return this.mMat[n2 + n * 3];
    }

    public float[] getArray() {
        return this.mMat;
    }

    public void load(Matrix3f matrix3f) {
        System.arraycopy((float[])matrix3f.getArray(), (int)0, (float[])this.mMat, (int)0, (int)this.mMat.length);
    }

    public void loadIdentity() {
        this.mMat[0] = 1.0f;
        this.mMat[1] = 0.0f;
        this.mMat[2] = 0.0f;
        this.mMat[3] = 0.0f;
        this.mMat[4] = 1.0f;
        this.mMat[5] = 0.0f;
        this.mMat[6] = 0.0f;
        this.mMat[7] = 0.0f;
        this.mMat[8] = 1.0f;
    }

    public void loadMultiply(Matrix3f matrix3f, Matrix3f matrix3f2) {
        for (int i = 0; i < 3; ++i) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (int j = 0; j < 3; ++j) {
                float f4 = matrix3f2.get(i, j);
                f += f4 * matrix3f.get(j, 0);
                f2 += f4 * matrix3f.get(j, 1);
                f3 += f4 * matrix3f.get(j, 2);
            }
            this.set(i, 0, f);
            this.set(i, 1, f2);
            this.set(i, 2, f3);
        }
    }

    public void loadRotate(float f) {
        this.loadIdentity();
        float f2 = f * ((float)Math.PI / 180);
        float f3 = (float)Math.cos(f2);
        float f4 = (float)Math.sin(f2);
        this.mMat[0] = f3;
        this.mMat[1] = -f4;
        this.mMat[3] = f4;
        this.mMat[4] = f3;
    }

    public void loadRotate(float f, float f2, float f3, float f4) {
        float f5 = f * ((float)Math.PI / 180);
        float f6 = (float)Math.cos(f5);
        float f7 = (float)Math.sin(f5);
        float f8 = (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
        if (f8 == 1.0f) {
            float f9 = 1.0f / f8;
            f2 *= f9;
            f3 *= f9;
            f4 *= f9;
        }
        float f10 = 1.0f - f6;
        float f11 = f2 * f3;
        float f12 = f3 * f4;
        float f13 = f4 * f2;
        float f14 = f2 * f7;
        float f15 = f3 * f7;
        float f16 = f4 * f7;
        this.mMat[0] = f6 + f10 * (f2 * f2);
        this.mMat[3] = f11 * f10 - f16;
        this.mMat[6] = f15 + f13 * f10;
        this.mMat[1] = f16 + f11 * f10;
        this.mMat[4] = f6 + f10 * (f3 * f3);
        this.mMat[7] = f12 * f10 - f14;
        this.mMat[2] = f13 * f10 - f15;
        this.mMat[5] = f14 + f12 * f10;
        this.mMat[8] = f6 + f10 * (f4 * f4);
    }

    public void loadScale(float f, float f2) {
        this.loadIdentity();
        this.mMat[0] = f;
        this.mMat[4] = f2;
    }

    public void loadScale(float f, float f2, float f3) {
        this.loadIdentity();
        this.mMat[0] = f;
        this.mMat[4] = f2;
        this.mMat[8] = f3;
    }

    public void loadTranslate(float f, float f2) {
        this.loadIdentity();
        this.mMat[6] = f;
        this.mMat[7] = f2;
    }

    public void multiply(Matrix3f matrix3f) {
        Matrix3f matrix3f2 = new Matrix3f();
        matrix3f2.loadMultiply(this, matrix3f);
        this.load(matrix3f2);
    }

    public void rotate(float f) {
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.loadRotate(f);
        this.multiply(matrix3f);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.loadRotate(f, f2, f3, f4);
        this.multiply(matrix3f);
    }

    public void scale(float f, float f2) {
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.loadScale(f, f2);
        this.multiply(matrix3f);
    }

    public void scale(float f, float f2, float f3) {
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.loadScale(f, f2, f3);
        this.multiply(matrix3f);
    }

    public void set(int n, int n2, float f) {
        this.mMat[n2 + n * 3] = f;
    }

    public void translate(float f, float f2) {
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.loadTranslate(f, f2);
        this.multiply(matrix3f);
    }

    public void transpose() {
        for (int i = 0; i < 2; ++i) {
            for (int j = i + 1; j < 3; ++j) {
                float f = this.mMat[j + i * 3];
                this.mMat[j + i * 3] = this.mMat[i + j * 3];
                this.mMat[i + j * 3] = f;
            }
        }
    }
}

