/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.renderscript.BaseObj;
import android.renderscript.Mesh;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import java.io.File;
import java.io.InputStream;

public class FileA3D
extends BaseObj {
    IndexEntry[] mFileEntries;
    InputStream mInputStream;

    FileA3D(long l, RenderScript renderScript, InputStream inputStream) {
        super(l, renderScript);
        this.mInputStream = inputStream;
    }

    public static FileA3D createFromAsset(RenderScript renderScript, AssetManager assetManager, String string2) {
        renderScript.validate();
        long l = renderScript.nFileA3DCreateFromAsset(assetManager, string2);
        if (l == 0L) {
            throw new RSRuntimeException("Unable to create a3d file from asset " + string2);
        }
        FileA3D fileA3D = new FileA3D(l, renderScript, null);
        fileA3D.initEntries();
        return fileA3D;
    }

    public static FileA3D createFromFile(RenderScript renderScript, File file) {
        return FileA3D.createFromFile(renderScript, file.getAbsolutePath());
    }

    public static FileA3D createFromFile(RenderScript renderScript, String string2) {
        long l = renderScript.nFileA3DCreateFromFile(string2);
        if (l == 0L) {
            throw new RSRuntimeException("Unable to create a3d file from " + string2);
        }
        FileA3D fileA3D = new FileA3D(l, renderScript, null);
        fileA3D.initEntries();
        return fileA3D;
    }

    public static FileA3D createFromResource(RenderScript renderScript, Resources resources, int n) {
        long l;
        InputStream inputStream;
        block4: {
            block3: {
                renderScript.validate();
                try {
                    inputStream = resources.openRawResource(n);
                }
                catch (Exception exception) {
                    throw new RSRuntimeException("Unable to open resource " + n);
                }
                if (!(inputStream instanceof AssetManager.AssetInputStream)) break block3;
                l = renderScript.nFileA3DCreateFromAssetStream(((AssetManager.AssetInputStream)inputStream).getNativeAsset());
                if (l == 0L) {
                    throw new RSRuntimeException("Unable to create a3d file from resource " + n);
                }
                break block4;
            }
            throw new RSRuntimeException("Unsupported asset stream");
        }
        FileA3D fileA3D = new FileA3D(l, renderScript, inputStream);
        fileA3D.initEntries();
        return fileA3D;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initEntries() {
        int n = this.mRS.nFileA3DGetNumIndexEntries(this.getID(this.mRS));
        if (n > 0) {
            this.mFileEntries = new IndexEntry[n];
            int[] nArray = new int[n];
            String[] stringArray = new String[n];
            this.mRS.nFileA3DGetIndexEntries(this.getID(this.mRS), n, nArray, stringArray);
            for (int i = 0; i < n; ++i) {
                this.mFileEntries[i] = new IndexEntry(this.mRS, i, this.getID(this.mRS), stringArray[i], EntryType.toEntryType(nArray[i]));
            }
        }
    }

    public IndexEntry getIndexEntry(int n) {
        if (this.getIndexEntryCount() == 0 || n < 0 || n >= this.mFileEntries.length) {
            return null;
        }
        return this.mFileEntries[n];
    }

    public int getIndexEntryCount() {
        if (this.mFileEntries == null) {
            return 0;
        }
        return this.mFileEntries.length;
    }

    public static final class EntryType
    extends Enum<EntryType> {
        private static final /* synthetic */ EntryType[] $VALUES;
        public static final /* enum */ EntryType MESH;
        public static final /* enum */ EntryType UNKNOWN;
        int mID;

        static {
            UNKNOWN = new EntryType(0);
            MESH = new EntryType(1);
            EntryType[] entryTypeArray = new EntryType[]{UNKNOWN, MESH};
            $VALUES = entryTypeArray;
        }

        private EntryType(int n2) {
            this.mID = n2;
        }

        static EntryType toEntryType(int n) {
            return EntryType.values()[n];
        }

        public static EntryType valueOf(String string2) {
            return Enum.valueOf(EntryType.class, string2);
        }

        public static EntryType[] values() {
            return (EntryType[])$VALUES.clone();
        }
    }

    public static class IndexEntry {
        EntryType mEntryType;
        long mID;
        int mIndex;
        BaseObj mLoadedObj;
        String mName;
        RenderScript mRS;

        IndexEntry(RenderScript renderScript, int n, long l, String string2, EntryType entryType) {
            this.mRS = renderScript;
            this.mIndex = n;
            this.mID = l;
            this.mName = string2;
            this.mEntryType = entryType;
            this.mLoadedObj = null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static BaseObj internalCreate(RenderScript renderScript, IndexEntry indexEntry) {
            synchronized (IndexEntry.class) {
                if (indexEntry.mLoadedObj != null) {
                    return indexEntry.mLoadedObj;
                }
                EntryType entryType = indexEntry.mEntryType;
                EntryType entryType2 = EntryType.UNKNOWN;
                BaseObj baseObj = null;
                if (entryType == entryType2) return baseObj;
                long l = renderScript.nFileA3DGetEntryByIndex(indexEntry.mID, indexEntry.mIndex);
                long l2 = l - 0L;
                long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                baseObj = null;
                if (l3 == false) return baseObj;
                switch (indexEntry.mEntryType) {
                    default: {
                        break;
                    }
                    case MESH: {
                        indexEntry.mLoadedObj = new Mesh(l, renderScript);
                    }
                }
                indexEntry.mLoadedObj.updateFromNative();
                return indexEntry.mLoadedObj;
            }
        }

        public EntryType getEntryType() {
            return this.mEntryType;
        }

        public Mesh getMesh() {
            return (Mesh)this.getObject();
        }

        public String getName() {
            return this.mName;
        }

        public BaseObj getObject() {
            this.mRS.validate();
            return IndexEntry.internalCreate(this.mRS, this);
        }
    }
}

