/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.util.Log;
import java.io.FileNotFoundException;
import java.util.Objects;
import libcore.io.IoUtils;

public abstract class DocumentsProvider
extends ContentProvider {
    private static final int MATCH_CHILDREN = 6;
    private static final int MATCH_CHILDREN_TREE = 8;
    private static final int MATCH_DOCUMENT = 5;
    private static final int MATCH_DOCUMENT_TREE = 7;
    private static final int MATCH_RECENT = 3;
    private static final int MATCH_ROOT = 2;
    private static final int MATCH_ROOTS = 1;
    private static final int MATCH_SEARCH = 4;
    private static final String TAG = "DocumentsProvider";
    private String mAuthority;
    private UriMatcher mMatcher;

    /*
     * Enabled aggressive block sorting
     */
    private void enforceTree(Uri uri) {
        String string2;
        String string3;
        if (!DocumentsContract.isTreeUri(uri) || Objects.equals(string3 = DocumentsContract.getTreeDocumentId(uri), string2 = DocumentsContract.getDocumentId(uri)) || this.isChildDocument(string3, string2)) {
            return;
        }
        throw new SecurityException("Document " + string2 + " is not a descendant of " + string3);
    }

    private static int getCallingOrSelfUriPermissionModeFlags(Context context, Uri uri) {
        int n = context.checkCallingOrSelfUriPermission(uri, 1);
        int n2 = 0;
        if (n == 0) {
            n2 = 0 | 1;
        }
        if (context.checkCallingOrSelfUriPermission(uri, 2) == 0) {
            n2 |= 2;
        }
        if (context.checkCallingOrSelfUriPermission(uri, 65) == 0) {
            n2 |= 0x40;
        }
        return n2;
    }

    @Override
    public void attachInfo(Context context, ProviderInfo providerInfo) {
        this.mAuthority = providerInfo.authority;
        this.mMatcher = new UriMatcher(-1);
        this.mMatcher.addURI(this.mAuthority, "root", 1);
        this.mMatcher.addURI(this.mAuthority, "root/*", 2);
        this.mMatcher.addURI(this.mAuthority, "root/*/recent", 3);
        this.mMatcher.addURI(this.mAuthority, "root/*/search", 4);
        this.mMatcher.addURI(this.mAuthority, "document/*", 5);
        this.mMatcher.addURI(this.mAuthority, "document/*/children", 6);
        this.mMatcher.addURI(this.mAuthority, "tree/*/document/*", 7);
        this.mMatcher.addURI(this.mAuthority, "tree/*/document/*/children", 8);
        if (!providerInfo.exported) {
            throw new SecurityException("Provider must be exported");
        }
        if (!providerInfo.grantUriPermissions) {
            throw new SecurityException("Provider must grantUriPermissions");
        }
        if (!"android.permission.MANAGE_DOCUMENTS".equals(providerInfo.readPermission) || !"android.permission.MANAGE_DOCUMENTS".equals(providerInfo.writePermission)) {
            throw new SecurityException("Provider must be protected by MANAGE_DOCUMENTS");
        }
        super.attachInfo(context, providerInfo);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Bundle call(String string2, String string3, Bundle bundle) {
        if (!string2.startsWith("android:")) {
            return super.call(string2, string3, bundle);
        }
        Context context = this.getContext();
        Uri uri = (Uri)bundle.getParcelable("uri");
        String string4 = uri.getAuthority();
        String string5 = DocumentsContract.getDocumentId(uri);
        if (!this.mAuthority.equals(string4)) {
            throw new SecurityException("Requested authority " + string4 + " doesn't match provider " + this.mAuthority);
        }
        this.enforceTree(uri);
        Bundle bundle2 = new Bundle();
        try {
            if ("android:createDocument".equals(string2)) {
                this.enforceWritePermissionInner(uri);
                bundle2.putParcelable("uri", DocumentsContract.buildDocumentUriMaybeUsingTree(uri, this.createDocument(string5, bundle.getString("mime_type"), bundle.getString("_display_name"))));
                return bundle2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalStateException("Failed call " + string2, fileNotFoundException);
        }
        {
            if ("android:renameDocument".equals(string2)) {
                this.enforceWritePermissionInner(uri);
                String string6 = this.renameDocument(string5, bundle.getString("_display_name"));
                if (string6 == null) return bundle2;
                Uri uri2 = DocumentsContract.buildDocumentUriMaybeUsingTree(uri, string6);
                if (!DocumentsContract.isTreeUri(uri2)) {
                    int n = DocumentsProvider.getCallingOrSelfUriPermissionModeFlags(context, uri);
                    context.grantUriPermission(this.getCallingPackage(), uri2, n);
                }
                bundle2.putParcelable("uri", uri2);
                this.revokeDocumentPermission(string5);
                return bundle2;
            }
            if (!"android:deleteDocument".equals(string2)) throw new UnsupportedOperationException("Method not supported " + string2);
            this.enforceWritePermissionInner(uri);
            this.deleteDocument(string5);
            this.revokeDocumentPermission(string5);
            return bundle2;
        }
    }

    @Override
    public Uri canonicalize(Uri uri) {
        Context context = this.getContext();
        switch (this.mMatcher.match(uri)) {
            default: {
                return null;
            }
            case 7: 
        }
        this.enforceTree(uri);
        Uri uri2 = DocumentsContract.buildDocumentUri(uri.getAuthority(), DocumentsContract.getDocumentId(uri));
        int n = DocumentsProvider.getCallingOrSelfUriPermissionModeFlags(context, uri);
        context.grantUriPermission(this.getCallingPackage(), uri2, n);
        return uri2;
    }

    public String createDocument(String string2, String string3, String string4) throws FileNotFoundException {
        throw new UnsupportedOperationException("Create not supported");
    }

    @Override
    public final int delete(Uri uri, String string2, String[] stringArray) {
        throw new UnsupportedOperationException("Delete not supported");
    }

    public void deleteDocument(String string2) throws FileNotFoundException {
        throw new UnsupportedOperationException("Delete not supported");
    }

    public String getDocumentType(String string2) throws FileNotFoundException {
        Cursor cursor = this.queryDocument(string2, null);
        try {
            if (cursor.moveToFirst()) {
                String string3 = cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
                return string3;
            }
            return null;
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)cursor);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public final String getType(Uri var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public final Uri insert(Uri uri, ContentValues contentValues) {
        throw new UnsupportedOperationException("Insert not supported");
    }

    public boolean isChildDocument(String string2, String string3) {
        return false;
    }

    @Override
    public final AssetFileDescriptor openAssetFile(Uri uri, String string2) throws FileNotFoundException {
        this.enforceTree(uri);
        ParcelFileDescriptor parcelFileDescriptor = this.openDocument(DocumentsContract.getDocumentId(uri), string2, null);
        AssetFileDescriptor assetFileDescriptor = null;
        if (parcelFileDescriptor != null) {
            assetFileDescriptor = new AssetFileDescriptor(parcelFileDescriptor, 0L, -1L);
        }
        return assetFileDescriptor;
    }

    @Override
    public final AssetFileDescriptor openAssetFile(Uri uri, String string2, CancellationSignal cancellationSignal) throws FileNotFoundException {
        this.enforceTree(uri);
        ParcelFileDescriptor parcelFileDescriptor = this.openDocument(DocumentsContract.getDocumentId(uri), string2, cancellationSignal);
        if (parcelFileDescriptor != null) {
            return new AssetFileDescriptor(parcelFileDescriptor, 0L, -1L);
        }
        return null;
    }

    public abstract ParcelFileDescriptor openDocument(String var1, String var2, CancellationSignal var3) throws FileNotFoundException;

    public AssetFileDescriptor openDocumentThumbnail(String string2, Point point, CancellationSignal cancellationSignal) throws FileNotFoundException {
        throw new UnsupportedOperationException("Thumbnails not supported");
    }

    @Override
    public final ParcelFileDescriptor openFile(Uri uri, String string2) throws FileNotFoundException {
        this.enforceTree(uri);
        return this.openDocument(DocumentsContract.getDocumentId(uri), string2, null);
    }

    @Override
    public final ParcelFileDescriptor openFile(Uri uri, String string2, CancellationSignal cancellationSignal) throws FileNotFoundException {
        this.enforceTree(uri);
        return this.openDocument(DocumentsContract.getDocumentId(uri), string2, cancellationSignal);
    }

    @Override
    public final AssetFileDescriptor openTypedAssetFile(Uri uri, String string2, Bundle bundle) throws FileNotFoundException {
        this.enforceTree(uri);
        if (bundle != null && bundle.containsKey("android.content.extra.SIZE")) {
            Point point = (Point)bundle.getParcelable("android.content.extra.SIZE");
            return this.openDocumentThumbnail(DocumentsContract.getDocumentId(uri), point, null);
        }
        return super.openTypedAssetFile(uri, string2, bundle);
    }

    @Override
    public final AssetFileDescriptor openTypedAssetFile(Uri uri, String string2, Bundle bundle, CancellationSignal cancellationSignal) throws FileNotFoundException {
        this.enforceTree(uri);
        if (bundle != null && bundle.containsKey("android.content.extra.SIZE")) {
            Point point = (Point)bundle.getParcelable("android.content.extra.SIZE");
            return this.openDocumentThumbnail(DocumentsContract.getDocumentId(uri), point, cancellationSignal);
        }
        return super.openTypedAssetFile(uri, string2, bundle, cancellationSignal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        try {
            switch (this.mMatcher.match(uri)) {
                default: {
                    throw new UnsupportedOperationException("Unsupported Uri " + uri);
                }
                case 1: {
                    return this.queryRoots(stringArray);
                }
                case 3: {
                    return this.queryRecentDocuments(DocumentsContract.getRootId(uri), stringArray);
                }
                case 4: {
                    return this.querySearchDocuments(DocumentsContract.getRootId(uri), DocumentsContract.getSearchDocumentsQuery(uri), stringArray);
                }
                case 5: 
                case 7: {
                    this.enforceTree(uri);
                    return this.queryDocument(DocumentsContract.getDocumentId(uri), stringArray);
                }
                case 6: 
                case 8: 
            }
            this.enforceTree(uri);
            if (!DocumentsContract.isManageMode(uri)) return this.queryChildDocuments(DocumentsContract.getDocumentId(uri), stringArray, string3);
            return this.queryChildDocumentsForManage(DocumentsContract.getDocumentId(uri), stringArray, string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.w(TAG, "Failed during query", fileNotFoundException);
            return null;
        }
    }

    public abstract Cursor queryChildDocuments(String var1, String[] var2, String var3) throws FileNotFoundException;

    public Cursor queryChildDocumentsForManage(String string2, String[] stringArray, String string3) throws FileNotFoundException {
        throw new UnsupportedOperationException("Manage not supported");
    }

    public abstract Cursor queryDocument(String var1, String[] var2) throws FileNotFoundException;

    public Cursor queryRecentDocuments(String string2, String[] stringArray) throws FileNotFoundException {
        throw new UnsupportedOperationException("Recent not supported");
    }

    public abstract Cursor queryRoots(String[] var1) throws FileNotFoundException;

    public Cursor querySearchDocuments(String string2, String string3, String[] stringArray) throws FileNotFoundException {
        throw new UnsupportedOperationException("Search not supported");
    }

    public String renameDocument(String string2, String string3) throws FileNotFoundException {
        throw new UnsupportedOperationException("Rename not supported");
    }

    public final void revokeDocumentPermission(String string2) {
        Context context = this.getContext();
        context.revokeUriPermission(DocumentsContract.buildDocumentUri(this.mAuthority, string2), -1);
        context.revokeUriPermission(DocumentsContract.buildTreeDocumentUri(this.mAuthority, string2), -1);
    }

    @Override
    public final int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        throw new UnsupportedOperationException("Update not supported");
    }
}

