/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.os.Parcel;
import android.os.Parcelable;
import android.print.PrinterCapabilitiesInfo;
import android.print.PrinterId;
import android.text.TextUtils;

public final class PrinterInfo
implements Parcelable {
    public static final Parcelable.Creator<PrinterInfo> CREATOR = new Parcelable.Creator<PrinterInfo>(){

        @Override
        public PrinterInfo createFromParcel(Parcel parcel) {
            return new PrinterInfo(parcel);
        }

        public PrinterInfo[] newArray(int n) {
            return new PrinterInfo[n];
        }
    };
    public static final int STATUS_BUSY = 2;
    public static final int STATUS_IDLE = 1;
    public static final int STATUS_UNAVAILABLE = 3;
    private PrinterCapabilitiesInfo mCapabilities;
    private String mDescription;
    private PrinterId mId;
    private String mName;
    private int mStatus;

    private PrinterInfo() {
    }

    private PrinterInfo(Parcel parcel) {
        this.mId = (PrinterId)parcel.readParcelable(null);
        this.mName = parcel.readString();
        this.mStatus = parcel.readInt();
        this.mDescription = parcel.readString();
        this.mCapabilities = (PrinterCapabilitiesInfo)parcel.readParcelable(null);
    }

    private PrinterInfo(PrinterInfo printerInfo) {
        this.copyFrom(printerInfo);
    }

    static /* synthetic */ PrinterId access$102(PrinterInfo printerInfo, PrinterId printerId) {
        printerInfo.mId = printerId;
        return printerId;
    }

    static /* synthetic */ String access$202(PrinterInfo printerInfo, String string2) {
        printerInfo.mName = string2;
        return string2;
    }

    static /* synthetic */ int access$302(PrinterInfo printerInfo, int n) {
        printerInfo.mStatus = n;
        return n;
    }

    static /* synthetic */ String access$402(PrinterInfo printerInfo, String string2) {
        printerInfo.mDescription = string2;
        return string2;
    }

    static /* synthetic */ PrinterCapabilitiesInfo access$502(PrinterInfo printerInfo, PrinterCapabilitiesInfo printerCapabilitiesInfo) {
        printerInfo.mCapabilities = printerCapabilitiesInfo;
        return printerCapabilitiesInfo;
    }

    public void copyFrom(PrinterInfo printerInfo) {
        if (this == printerInfo) {
            return;
        }
        this.mId = printerInfo.mId;
        this.mName = printerInfo.mName;
        this.mStatus = printerInfo.mStatus;
        this.mDescription = printerInfo.mDescription;
        if (printerInfo.mCapabilities != null) {
            if (this.mCapabilities != null) {
                this.mCapabilities.copyFrom(printerInfo.mCapabilities);
                return;
            }
            this.mCapabilities = new PrinterCapabilitiesInfo(printerInfo.mCapabilities);
            return;
        }
        this.mCapabilities = null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PrinterInfo printerInfo = (PrinterInfo)object;
        if (this.mId == null ? printerInfo.mId != null : !this.mId.equals(printerInfo.mId)) {
            return false;
        }
        if (!TextUtils.equals(this.mName, printerInfo.mName)) {
            return false;
        }
        if (this.mStatus != printerInfo.mStatus) {
            return false;
        }
        if (!TextUtils.equals(this.mDescription, printerInfo.mDescription)) {
            return false;
        }
        if (this.mCapabilities == null) {
            if (printerInfo.mCapabilities == null) return true;
            return false;
        }
        if (!this.mCapabilities.equals(printerInfo.mCapabilities)) return false;
        return true;
    }

    public PrinterCapabilitiesInfo getCapabilities() {
        return this.mCapabilities;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public PrinterId getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public int getStatus() {
        return this.mStatus;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n = this.mId != null ? this.mId.hashCode() : 0;
        int n2 = 31 * (n + 31);
        int n3 = this.mName != null ? this.mName.hashCode() : 0;
        int n4 = 31 * (31 * (n2 + n3) + this.mStatus);
        int n5 = this.mDescription != null ? this.mDescription.hashCode() : 0;
        int n6 = 31 * (n4 + n5);
        PrinterCapabilitiesInfo printerCapabilitiesInfo = this.mCapabilities;
        int n7 = 0;
        if (printerCapabilitiesInfo != null) {
            n7 = this.mCapabilities.hashCode();
        }
        return n6 + n7;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PrinterInfo{");
        stringBuilder.append("id=").append(this.mId);
        stringBuilder.append(", name=").append(this.mName);
        stringBuilder.append(", status=").append(this.mStatus);
        stringBuilder.append(", description=").append(this.mDescription);
        stringBuilder.append(", capabilities=").append(this.mCapabilities);
        stringBuilder.append("\"}");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeParcelable(this.mId, n);
        parcel.writeString(this.mName);
        parcel.writeInt(this.mStatus);
        parcel.writeString(this.mDescription);
        parcel.writeParcelable(this.mCapabilities, n);
    }

    public static final class Builder {
        private final PrinterInfo mPrototype;

        public Builder(PrinterId printerId, String string2, int n) {
            if (printerId == null) {
                throw new IllegalArgumentException("printerId cannot be null.");
            }
            if (TextUtils.isEmpty(string2)) {
                throw new IllegalArgumentException("name cannot be empty.");
            }
            if (!this.isValidStatus(n)) {
                throw new IllegalArgumentException("status is invalid.");
            }
            this.mPrototype = new PrinterInfo();
            PrinterInfo.access$102(this.mPrototype, printerId);
            PrinterInfo.access$202(this.mPrototype, string2);
            PrinterInfo.access$302(this.mPrototype, n);
        }

        public Builder(PrinterInfo printerInfo) {
            this.mPrototype = new PrinterInfo();
            this.mPrototype.copyFrom(printerInfo);
        }

        private boolean isValidStatus(int n) {
            return n == 1 || n == 2 || n == 3;
        }

        public PrinterInfo build() {
            return this.mPrototype;
        }

        public Builder setCapabilities(PrinterCapabilitiesInfo printerCapabilitiesInfo) {
            PrinterInfo.access$502(this.mPrototype, printerCapabilitiesInfo);
            return this;
        }

        public Builder setDescription(String string2) {
            PrinterInfo.access$402(this.mPrototype, string2);
            return this;
        }

        public Builder setName(String string2) {
            PrinterInfo.access$202(this.mPrototype, string2);
            return this;
        }

        public Builder setStatus(int n) {
            PrinterInfo.access$302(this.mPrototype, n);
            return this;
        }
    }
}

