/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.print.PageRange;
import android.print.PrintAttributes;
import android.print.PrintDocumentInfo;
import android.print.PrintJobId;
import android.print.PrinterId;
import java.util.Arrays;

public final class PrintJobInfo
implements Parcelable {
    public static final Parcelable.Creator<PrintJobInfo> CREATOR = new Parcelable.Creator<PrintJobInfo>(){

        @Override
        public PrintJobInfo createFromParcel(Parcel parcel) {
            return new PrintJobInfo(parcel);
        }

        public PrintJobInfo[] newArray(int n) {
            return new PrintJobInfo[n];
        }
    };
    public static final int STATE_ANY = -1;
    public static final int STATE_ANY_ACTIVE = -3;
    public static final int STATE_ANY_SCHEDULED = -4;
    public static final int STATE_ANY_VISIBLE_TO_CLIENTS = -2;
    public static final int STATE_BLOCKED = 4;
    public static final int STATE_CANCELED = 7;
    public static final int STATE_COMPLETED = 5;
    public static final int STATE_CREATED = 1;
    public static final int STATE_FAILED = 6;
    public static final int STATE_QUEUED = 2;
    public static final int STATE_STARTED = 3;
    private Bundle mAdvancedOptions;
    private int mAppId;
    private PrintAttributes mAttributes;
    private boolean mCanceling;
    private int mCopies;
    private long mCreationTime;
    private PrintDocumentInfo mDocumentInfo;
    private PrintJobId mId;
    private String mLabel;
    private PageRange[] mPageRanges;
    private PrinterId mPrinterId;
    private String mPrinterName;
    private int mState;
    private String mStateReason;
    private String mTag;

    public PrintJobInfo() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private PrintJobInfo(Parcel parcel) {
        this.mId = (PrintJobId)parcel.readParcelable(null);
        this.mLabel = parcel.readString();
        this.mPrinterId = (PrinterId)parcel.readParcelable(null);
        this.mPrinterName = parcel.readString();
        this.mState = parcel.readInt();
        this.mAppId = parcel.readInt();
        this.mTag = parcel.readString();
        this.mCreationTime = parcel.readLong();
        this.mCopies = parcel.readInt();
        this.mStateReason = parcel.readString();
        Parcelable[] parcelableArray = parcel.readParcelableArray(null);
        if (parcelableArray != null) {
            this.mPageRanges = new PageRange[parcelableArray.length];
            for (int i = 0; i < parcelableArray.length; ++i) {
                this.mPageRanges[i] = (PageRange)parcelableArray[i];
            }
        }
        this.mAttributes = (PrintAttributes)parcel.readParcelable(null);
        this.mDocumentInfo = (PrintDocumentInfo)parcel.readParcelable(null);
        boolean bl = parcel.readInt() == 1;
        this.mCanceling = bl;
        this.mAdvancedOptions = parcel.readBundle();
    }

    public PrintJobInfo(PrintJobInfo printJobInfo) {
        this.mId = printJobInfo.mId;
        this.mLabel = printJobInfo.mLabel;
        this.mPrinterId = printJobInfo.mPrinterId;
        this.mPrinterName = printJobInfo.mPrinterName;
        this.mState = printJobInfo.mState;
        this.mAppId = printJobInfo.mAppId;
        this.mTag = printJobInfo.mTag;
        this.mCreationTime = printJobInfo.mCreationTime;
        this.mCopies = printJobInfo.mCopies;
        this.mStateReason = printJobInfo.mStateReason;
        this.mPageRanges = printJobInfo.mPageRanges;
        this.mAttributes = printJobInfo.mAttributes;
        this.mDocumentInfo = printJobInfo.mDocumentInfo;
        this.mCanceling = printJobInfo.mCanceling;
        this.mAdvancedOptions = printJobInfo.mAdvancedOptions;
    }

    static /* synthetic */ int access$002(PrintJobInfo printJobInfo, int n) {
        printJobInfo.mCopies = n;
        return n;
    }

    static /* synthetic */ PrintAttributes access$102(PrintJobInfo printJobInfo, PrintAttributes printAttributes) {
        printJobInfo.mAttributes = printAttributes;
        return printAttributes;
    }

    static /* synthetic */ PageRange[] access$202(PrintJobInfo printJobInfo, PageRange[] pageRangeArray) {
        printJobInfo.mPageRanges = pageRangeArray;
        return pageRangeArray;
    }

    static /* synthetic */ Bundle access$302(PrintJobInfo printJobInfo, Bundle bundle) {
        printJobInfo.mAdvancedOptions = bundle;
        return bundle;
    }

    public static String stateToString(int n) {
        switch (n) {
            default: {
                return "STATE_UNKNOWN";
            }
            case 1: {
                return "STATE_CREATED";
            }
            case 2: {
                return "STATE_QUEUED";
            }
            case 3: {
                return "STATE_STARTED";
            }
            case 4: {
                return "STATE_BLOCKED";
            }
            case 6: {
                return "STATE_FAILED";
            }
            case 5: {
                return "STATE_COMPLETED";
            }
            case 7: 
        }
        return "STATE_CANCELED";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getAdvancedIntOption(String string2) {
        if (this.mAdvancedOptions != null) {
            return this.mAdvancedOptions.getInt(string2);
        }
        return 0;
    }

    public Bundle getAdvancedOptions() {
        return this.mAdvancedOptions;
    }

    public String getAdvancedStringOption(String string2) {
        if (this.mAdvancedOptions != null) {
            return this.mAdvancedOptions.getString(string2);
        }
        return null;
    }

    public int getAppId() {
        return this.mAppId;
    }

    public PrintAttributes getAttributes() {
        return this.mAttributes;
    }

    public int getCopies() {
        return this.mCopies;
    }

    public long getCreationTime() {
        return this.mCreationTime;
    }

    public PrintDocumentInfo getDocumentInfo() {
        return this.mDocumentInfo;
    }

    public PrintJobId getId() {
        return this.mId;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public PageRange[] getPages() {
        return this.mPageRanges;
    }

    public PrinterId getPrinterId() {
        return this.mPrinterId;
    }

    public String getPrinterName() {
        return this.mPrinterName;
    }

    public int getState() {
        return this.mState;
    }

    public String getStateReason() {
        return this.mStateReason;
    }

    public String getTag() {
        return this.mTag;
    }

    public boolean hasAdvancedOption(String string2) {
        return this.mAdvancedOptions != null && this.mAdvancedOptions.containsKey(string2);
    }

    public boolean isCancelling() {
        return this.mCanceling;
    }

    public void setAdvancedOptions(Bundle bundle) {
        this.mAdvancedOptions = bundle;
    }

    public void setAppId(int n) {
        this.mAppId = n;
    }

    public void setAttributes(PrintAttributes printAttributes) {
        this.mAttributes = printAttributes;
    }

    public void setCancelling(boolean bl) {
        this.mCanceling = bl;
    }

    public void setCopies(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Copies must be more than one.");
        }
        this.mCopies = n;
    }

    public void setCreationTime(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("creationTime must be non-negative.");
        }
        this.mCreationTime = l;
    }

    public void setDocumentInfo(PrintDocumentInfo printDocumentInfo) {
        this.mDocumentInfo = printDocumentInfo;
    }

    public void setId(PrintJobId printJobId) {
        this.mId = printJobId;
    }

    public void setLabel(String string2) {
        this.mLabel = string2;
    }

    public void setPages(PageRange[] pageRangeArray) {
        this.mPageRanges = pageRangeArray;
    }

    public void setPrinterId(PrinterId printerId) {
        this.mPrinterId = printerId;
    }

    public void setPrinterName(String string2) {
        this.mPrinterName = string2;
    }

    public void setState(int n) {
        this.mState = n;
    }

    public void setStateReason(String string2) {
        this.mStateReason = string2;
    }

    public void setTag(String string2) {
        this.mTag = string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PrintJobInfo{");
        stringBuilder.append("label: ").append(this.mLabel);
        stringBuilder.append(", id: ").append(this.mId);
        stringBuilder.append(", state: ").append(PrintJobInfo.stateToString(this.mState));
        stringBuilder.append(", printer: " + this.mPrinterId);
        stringBuilder.append(", tag: ").append(this.mTag);
        stringBuilder.append(", creationTime: " + this.mCreationTime);
        stringBuilder.append(", copies: ").append(this.mCopies);
        StringBuilder stringBuilder2 = new StringBuilder().append(", attributes: ");
        String string2 = this.mAttributes != null ? this.mAttributes.toString() : null;
        stringBuilder.append(stringBuilder2.append(string2).toString());
        StringBuilder stringBuilder3 = new StringBuilder().append(", documentInfo: ");
        String string3 = this.mDocumentInfo != null ? this.mDocumentInfo.toString() : null;
        stringBuilder.append(stringBuilder3.append(string3).toString());
        stringBuilder.append(", cancelling: " + this.mCanceling);
        StringBuilder stringBuilder4 = new StringBuilder().append(", pages: ");
        PageRange[] pageRangeArray = this.mPageRanges;
        String string4 = null;
        if (pageRangeArray != null) {
            string4 = Arrays.toString(this.mPageRanges);
        }
        stringBuilder.append(stringBuilder4.append(string4).toString());
        StringBuilder stringBuilder5 = new StringBuilder().append(", hasAdvancedOptions: ");
        boolean bl = this.mAdvancedOptions != null;
        stringBuilder.append(stringBuilder5.append(bl).toString());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeParcelable(this.mId, n);
        parcel.writeString(this.mLabel);
        parcel.writeParcelable(this.mPrinterId, n);
        parcel.writeString(this.mPrinterName);
        parcel.writeInt(this.mState);
        parcel.writeInt(this.mAppId);
        parcel.writeString(this.mTag);
        parcel.writeLong(this.mCreationTime);
        parcel.writeInt(this.mCopies);
        parcel.writeString(this.mStateReason);
        parcel.writeParcelableArray(this.mPageRanges, n);
        parcel.writeParcelable(this.mAttributes, n);
        parcel.writeParcelable(this.mDocumentInfo, 0);
        boolean bl = this.mCanceling;
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        parcel.writeInt(n2);
        parcel.writeBundle(this.mAdvancedOptions);
    }

    public static final class Builder {
        private final PrintJobInfo mPrototype;

        /*
         * Enabled aggressive block sorting
         */
        public Builder(PrintJobInfo printJobInfo) {
            PrintJobInfo printJobInfo2 = printJobInfo != null ? new PrintJobInfo(printJobInfo) : new PrintJobInfo();
            this.mPrototype = printJobInfo2;
        }

        public PrintJobInfo build() {
            return this.mPrototype;
        }

        public void putAdvancedOption(String string2, int n) {
            if (this.mPrototype.mAdvancedOptions == null) {
                PrintJobInfo.access$302(this.mPrototype, new Bundle());
            }
            this.mPrototype.mAdvancedOptions.putInt(string2, n);
        }

        public void putAdvancedOption(String string2, String string3) {
            if (this.mPrototype.mAdvancedOptions == null) {
                PrintJobInfo.access$302(this.mPrototype, new Bundle());
            }
            this.mPrototype.mAdvancedOptions.putString(string2, string3);
        }

        public void setAttributes(PrintAttributes printAttributes) {
            PrintJobInfo.access$102(this.mPrototype, printAttributes);
        }

        public void setCopies(int n) {
            PrintJobInfo.access$002(this.mPrototype, n);
        }

        public void setPages(PageRange[] pageRangeArray) {
            PrintJobInfo.access$202(this.mPrototype, pageRangeArray);
        }
    }
}

