/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.os.Parcel;
import android.os.Parcelable;

public final class PageRange
implements Parcelable {
    public static final PageRange ALL_PAGES = new PageRange(0, Integer.MAX_VALUE);
    public static final Parcelable.Creator<PageRange> CREATOR = new Parcelable.Creator<PageRange>(){

        @Override
        public PageRange createFromParcel(Parcel parcel) {
            return new PageRange(parcel);
        }

        public PageRange[] newArray(int n) {
            return new PageRange[n];
        }
    };
    private final int mEnd;
    private final int mStart;

    public PageRange(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("start cannot be less than zero.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("end cannot be less than zero.");
        }
        if (n > n2) {
            throw new IllegalArgumentException("start must be lesser than end.");
        }
        this.mStart = n;
        this.mEnd = n2;
    }

    private PageRange(Parcel parcel) {
        this(parcel.readInt(), parcel.readInt());
    }

    public boolean contains(int n) {
        return n >= this.mStart && n <= this.mEnd;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block7: {
            block6: {
                if (this == object) break block6;
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                PageRange pageRange = (PageRange)object;
                if (this.mEnd != pageRange.mEnd) {
                    return false;
                }
                if (this.mStart != pageRange.mStart) break block7;
            }
            return true;
        }
        return false;
    }

    public int getEnd() {
        return this.mEnd;
    }

    public int getSize() {
        return 1 + (this.mEnd - this.mStart);
    }

    public int getStart() {
        return this.mStart;
    }

    public int hashCode() {
        return 31 * (31 + this.mEnd) + this.mStart;
    }

    public String toString() {
        if (this.mStart == 0 && this.mEnd == Integer.MAX_VALUE) {
            return "PageRange[<all pages>]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PageRange[").append(this.mStart).append(" - ").append(this.mEnd).append("]");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mStart);
        parcel.writeInt(this.mEnd);
    }
}

