/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.Dialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.preference.SeekBarDialogPreference;
import android.preference.SeekBarVolumizer;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.SeekBar;
import com.android.internal.R;

public class VolumePreference
extends SeekBarDialogPreference
implements PreferenceManager.OnActivityStopListener,
View.OnKeyListener,
SeekBarVolumizer.Callback {
    static final String TAG = "VolumePreference";
    private SeekBarVolumizer mSeekBarVolumizer;
    private int mStreamType;

    public VolumePreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010091);
    }

    public VolumePreference(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public VolumePreference(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.VolumePreference, n, n2);
        this.mStreamType = typedArray.getInt(0, 0);
        typedArray.recycle();
    }

    private void cleanup() {
        this.getPreferenceManager().unregisterOnActivityStopListener(this);
        if (this.mSeekBarVolumizer != null) {
            Dialog dialog = this.getDialog();
            if (dialog != null && dialog.isShowing()) {
                View view = dialog.getWindow().getDecorView().findViewById(16909075);
                if (view != null) {
                    view.setOnKeyListener(null);
                }
                this.mSeekBarVolumizer.revertVolume();
            }
            this.mSeekBarVolumizer.stop();
            this.mSeekBarVolumizer = null;
        }
    }

    @Override
    public void onActivityStop() {
        if (this.mSeekBarVolumizer != null) {
            this.mSeekBarVolumizer.postStopSample();
        }
    }

    @Override
    protected void onBindDialogView(View view) {
        super.onBindDialogView(view);
        SeekBar seekBar = (SeekBar)view.findViewById(16909075);
        this.mSeekBarVolumizer = new SeekBarVolumizer(this.getContext(), this.mStreamType, null, this);
        this.mSeekBarVolumizer.setSeekBar(seekBar);
        this.getPreferenceManager().registerOnActivityStopListener(this);
        view.setOnKeyListener(this);
        view.setFocusableInTouchMode(true);
        view.requestFocus();
    }

    @Override
    protected void onDialogClosed(boolean bl) {
        super.onDialogClosed(bl);
        if (!bl && this.mSeekBarVolumizer != null) {
            this.mSeekBarVolumizer.revertVolume();
        }
        this.cleanup();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onKey(View view, int n, KeyEvent keyEvent) {
        block6: {
            block5: {
                if (this.mSeekBarVolumizer == null) break block5;
                boolean bl = keyEvent.getAction() == 0;
                switch (n) {
                    default: {
                        return false;
                    }
                    case 25: {
                        if (!bl) break;
                        this.mSeekBarVolumizer.changeVolumeBy(-1);
                        return true;
                    }
                    case 24: {
                        if (!bl) break;
                        this.mSeekBarVolumizer.changeVolumeBy(1);
                        return true;
                    }
                    case 164: {
                        if (bl) break block6;
                    }
                }
            }
            return true;
        }
        this.mSeekBarVolumizer.muteVolume();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable == null || !parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        } else {
            SavedState savedState = (SavedState)parcelable;
            super.onRestoreInstanceState(savedState.getSuperState());
            if (this.mSeekBarVolumizer == null) return;
            this.mSeekBarVolumizer.onRestoreInstanceState(savedState.getVolumeStore());
            return;
        }
    }

    @Override
    public void onRingerModeChanged() {
    }

    @Override
    public void onSampleStarting(SeekBarVolumizer seekBarVolumizer) {
        if (this.mSeekBarVolumizer != null && seekBarVolumizer != this.mSeekBarVolumizer) {
            this.mSeekBarVolumizer.stopSample();
        }
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        if (this.mSeekBarVolumizer != null) {
            this.mSeekBarVolumizer.onSaveInstanceState(savedState.getVolumeStore());
        }
        return savedState;
    }

    public void setStreamType(int n) {
        this.mStreamType = n;
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        VolumeStore mVolumeStore = new VolumeStore();

        public SavedState(Parcel parcel) {
            super(parcel);
            this.mVolumeStore.volume = parcel.readInt();
            this.mVolumeStore.originalVolume = parcel.readInt();
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        VolumeStore getVolumeStore() {
            return this.mVolumeStore;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.mVolumeStore.volume);
            parcel.writeInt(this.mVolumeStore.originalVolume);
        }
    }

    public static class VolumeStore {
        public int originalVolume = -1;
        public int volume = -1;
    }
}

