/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.preference.TwoStatePreference;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Checkable;
import android.widget.CompoundButton;
import android.widget.Switch;
import com.android.internal.R;

public class SwitchPreference
extends TwoStatePreference {
    private final Listener mListener = new Listener();
    private CharSequence mSwitchOff;
    private CharSequence mSwitchOn;

    public SwitchPreference(Context context) {
        this(context, null);
    }

    public SwitchPreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843629);
    }

    public SwitchPreference(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public SwitchPreference(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SwitchPreference, n, n2);
        this.setSummaryOn(typedArray.getString(0));
        this.setSummaryOff(typedArray.getString(1));
        this.setSwitchTextOn(typedArray.getString(3));
        this.setSwitchTextOff(typedArray.getString(4));
        this.setDisableDependentsState(typedArray.getBoolean(2, false));
        typedArray.recycle();
    }

    public CharSequence getSwitchTextOff() {
        return this.mSwitchOff;
    }

    public CharSequence getSwitchTextOn() {
        return this.mSwitchOn;
    }

    @Override
    protected void onBindView(View view) {
        super.onBindView(view);
        View view2 = view.findViewById(16909209);
        if (view2 != null && view2 instanceof Checkable) {
            if (view2 instanceof Switch) {
                ((Switch)view2).setOnCheckedChangeListener(null);
            }
            ((Checkable)((Object)view2)).setChecked(this.mChecked);
            if (view2 instanceof Switch) {
                Switch switch_ = (Switch)view2;
                switch_.setTextOn(this.mSwitchOn);
                switch_.setTextOff(this.mSwitchOff);
                switch_.setOnCheckedChangeListener(this.mListener);
            }
        }
        this.syncSummaryView(view);
    }

    public void setSwitchTextOff(int n) {
        this.setSwitchTextOff(this.getContext().getString(n));
    }

    public void setSwitchTextOff(CharSequence charSequence) {
        this.mSwitchOff = charSequence;
        this.notifyChanged();
    }

    public void setSwitchTextOn(int n) {
        this.setSwitchTextOn(this.getContext().getString(n));
    }

    public void setSwitchTextOn(CharSequence charSequence) {
        this.mSwitchOn = charSequence;
        this.notifyChanged();
    }

    private class Listener
    implements CompoundButton.OnCheckedChangeListener {
        private Listener() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
            if (SwitchPreference.this.callChangeListener(bl)) {
                SwitchPreference.this.setChecked(bl);
                return;
            }
            boolean bl2 = !bl;
            compoundButton.setChecked(bl2);
        }
    }
}

