/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.SeekBar;
import com.android.internal.R;

public class SeekBarPreference
extends Preference
implements SeekBar.OnSeekBarChangeListener {
    private int mMax;
    private int mProgress;
    private boolean mTrackingTouch;

    public SeekBarPreference(Context context) {
        this(context, null);
    }

    public SeekBarPreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16844036);
    }

    public SeekBarPreference(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public SeekBarPreference(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ProgressBar, n, n2);
        this.setMax(typedArray.getInt(2, this.mMax));
        typedArray.recycle();
        TypedArray typedArray2 = context.obtainStyledAttributes(attributeSet, R.styleable.SeekBarPreference, n, n2);
        int n3 = typedArray2.getResourceId(0, 17367229);
        typedArray2.recycle();
        this.setLayoutResource(n3);
    }

    private void setProgress(int n, boolean bl) {
        if (n > this.mMax) {
            n = this.mMax;
        }
        if (n < 0) {
            n = 0;
        }
        if (n != this.mProgress) {
            this.mProgress = n;
            this.persistInt(n);
            if (bl) {
                this.notifyChanged();
            }
        }
    }

    public int getProgress() {
        return this.mProgress;
    }

    @Override
    public CharSequence getSummary() {
        return null;
    }

    @Override
    protected void onBindView(View view) {
        super.onBindView(view);
        SeekBar seekBar = (SeekBar)view.findViewById(16909075);
        seekBar.setOnSeekBarChangeListener(this);
        seekBar.setMax(this.mMax);
        seekBar.setProgress(this.mProgress);
        seekBar.setEnabled(this.isEnabled());
    }

    @Override
    protected Object onGetDefaultValue(TypedArray typedArray, int n) {
        return typedArray.getInt(n, 0);
    }

    @Override
    public boolean onKey(View view, int n, KeyEvent keyEvent) {
        if (keyEvent.getAction() != 1) {
            if (n == 81 || n == 70) {
                this.setProgress(1 + this.getProgress());
                return true;
            }
            if (n == 69) {
                this.setProgress(-1 + this.getProgress());
                return true;
            }
        }
        return false;
    }

    @Override
    public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
        if (bl && !this.mTrackingTouch) {
            this.syncProgress(seekBar);
        }
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (!parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mProgress = savedState.progress;
        this.mMax = savedState.max;
        this.notifyChanged();
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        savedState.progress = this.mProgress;
        savedState.max = this.mMax;
        return savedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSetInitialValue(boolean bl, Object object) {
        int n = bl ? this.getPersistedInt(this.mProgress) : ((Integer)object).intValue();
        this.setProgress(n);
    }

    @Override
    public void onStartTrackingTouch(SeekBar seekBar) {
        this.mTrackingTouch = true;
    }

    @Override
    public void onStopTrackingTouch(SeekBar seekBar) {
        this.mTrackingTouch = false;
        if (seekBar.getProgress() != this.mProgress) {
            this.syncProgress(seekBar);
        }
    }

    public void setMax(int n) {
        if (n != this.mMax) {
            this.mMax = n;
            this.notifyChanged();
        }
    }

    public void setProgress(int n) {
        this.setProgress(n, true);
    }

    void syncProgress(SeekBar seekBar) {
        block3: {
            block2: {
                int n = seekBar.getProgress();
                if (n == this.mProgress) break block2;
                if (!this.callChangeListener(n)) break block3;
                this.setProgress(n, false);
            }
            return;
        }
        seekBar.setProgress(this.mProgress);
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        int max;
        int progress;

        public SavedState(Parcel parcel) {
            super(parcel);
            this.progress = parcel.readInt();
            this.max = parcel.readInt();
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.progress);
            parcel.writeInt(this.max);
        }
    }
}

