/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.preference.PreferenceGroup;
import android.preference.PreferenceGroupAdapter;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;

public final class PreferenceScreen
extends PreferenceGroup
implements AdapterView.OnItemClickListener,
DialogInterface.OnDismissListener {
    private Dialog mDialog;
    private ListView mListView;
    private ListAdapter mRootAdapter;

    public PreferenceScreen(Context context, AttributeSet attributeSet) {
        super(context, attributeSet, 16842891);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showDialog(Bundle bundle) {
        Dialog dialog;
        Context context = this.getContext();
        if (this.mListView != null) {
            this.mListView.setAdapter((ListAdapter)null);
        }
        View view = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(17367225, null);
        this.mListView = (ListView)view.findViewById(16908298);
        this.bind(this.mListView);
        CharSequence charSequence = this.getTitle();
        this.mDialog = dialog = new Dialog(context, context.getThemeResId());
        if (TextUtils.isEmpty(charSequence)) {
            dialog.getWindow().requestFeature(1);
        } else {
            dialog.setTitle(charSequence);
        }
        dialog.setContentView(view);
        dialog.setOnDismissListener(this);
        if (bundle != null) {
            dialog.onRestoreInstanceState(bundle);
        }
        this.getPreferenceManager().addPreferencesScreen(dialog);
        dialog.show();
    }

    public void bind(ListView listView) {
        listView.setOnItemClickListener(this);
        listView.setAdapter(this.getRootAdapter());
        this.onAttachedToActivity();
    }

    public Dialog getDialog() {
        return this.mDialog;
    }

    public ListAdapter getRootAdapter() {
        if (this.mRootAdapter == null) {
            this.mRootAdapter = this.onCreateRootAdapter();
        }
        return this.mRootAdapter;
    }

    @Override
    protected boolean isOnSameScreenAsChildren() {
        return false;
    }

    @Override
    protected void onClick() {
        if (this.getIntent() != null || this.getFragment() != null || this.getPreferenceCount() == 0) {
            return;
        }
        this.showDialog(null);
    }

    protected ListAdapter onCreateRootAdapter() {
        return new PreferenceGroupAdapter(this);
    }

    @Override
    public void onDismiss(DialogInterface dialogInterface) {
        this.mDialog = null;
        this.getPreferenceManager().removePreferencesScreen(dialogInterface);
    }

    public void onItemClick(AdapterView adapterView, View view, int n, long l) {
        Object object;
        if (adapterView instanceof ListView) {
            n -= ((ListView)adapterView).getHeaderViewsCount();
        }
        if (!((object = this.getRootAdapter().getItem(n)) instanceof Preference)) {
            return;
        }
        ((Preference)object).performClick(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable == null || !parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        } else {
            SavedState savedState = (SavedState)parcelable;
            super.onRestoreInstanceState(savedState.getSuperState());
            if (!savedState.isDialogShowing) return;
            this.showDialog(savedState.dialogBundle);
            return;
        }
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        Dialog dialog = this.mDialog;
        if (dialog == null || !dialog.isShowing()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        savedState.isDialogShowing = true;
        savedState.dialogBundle = dialog.onSaveInstanceState();
        return savedState;
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        Bundle dialogBundle;
        boolean isDialogShowing;

        /*
         * Enabled aggressive block sorting
         */
        public SavedState(Parcel parcel) {
            int n = 1;
            super(parcel);
            if (parcel.readInt() != n) {
                n = 0;
            }
            this.isDialogShowing = n;
            this.dialogBundle = parcel.readBundle();
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            int n2 = this.isDialogShowing ? 1 : 0;
            parcel.writeInt(n2);
            parcel.writeBundle(this.dialogBundle);
        }
    }
}

