/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.DialogPreference;
import android.preference.Preference;
import android.util.AttributeSet;
import com.android.internal.R;
import java.util.HashSet;
import java.util.Set;

public class MultiSelectListPreference
extends DialogPreference {
    private CharSequence[] mEntries;
    private CharSequence[] mEntryValues;
    private Set<String> mNewValues;
    private boolean mPreferenceChanged;
    private Set<String> mValues = new HashSet<String>();

    public MultiSelectListPreference(Context context) {
        this(context, null);
    }

    public MultiSelectListPreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010091);
    }

    public MultiSelectListPreference(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public MultiSelectListPreference(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mNewValues = new HashSet<String>();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.MultiSelectListPreference, n, n2);
        this.mEntries = typedArray.getTextArray(0);
        this.mEntryValues = typedArray.getTextArray(1);
        typedArray.recycle();
    }

    static /* synthetic */ boolean access$076(MultiSelectListPreference multiSelectListPreference, int n) {
        boolean bl;
        multiSelectListPreference.mPreferenceChanged = bl = (byte)(n | multiSelectListPreference.mPreferenceChanged);
        return bl;
    }

    private boolean[] getSelectedItems() {
        CharSequence[] charSequenceArray = this.mEntryValues;
        int n = charSequenceArray.length;
        Set<String> set = this.mValues;
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = set.contains(charSequenceArray[i].toString());
        }
        return blArray;
    }

    public int findIndexOfValue(String string2) {
        if (string2 != null && this.mEntryValues != null) {
            for (int i = -1 + this.mEntryValues.length; i >= 0; --i) {
                if (!this.mEntryValues[i].equals(string2)) continue;
                return i;
            }
        }
        return -1;
    }

    public CharSequence[] getEntries() {
        return this.mEntries;
    }

    public CharSequence[] getEntryValues() {
        return this.mEntryValues;
    }

    public Set<String> getValues() {
        return this.mValues;
    }

    @Override
    protected void onDialogClosed(boolean bl) {
        Set<String> set;
        super.onDialogClosed(bl);
        if (bl && this.mPreferenceChanged && this.callChangeListener(set = this.mNewValues)) {
            this.setValues(set);
        }
        this.mPreferenceChanged = false;
    }

    @Override
    protected Object onGetDefaultValue(TypedArray typedArray, int n) {
        CharSequence[] charSequenceArray = typedArray.getTextArray(n);
        int n2 = charSequenceArray.length;
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < n2; ++i) {
            hashSet.add(charSequenceArray[i].toString());
        }
        return hashSet;
    }

    @Override
    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        super.onPrepareDialogBuilder(builder);
        if (this.mEntries == null || this.mEntryValues == null) {
            throw new IllegalStateException("MultiSelectListPreference requires an entries array and an entryValues array.");
        }
        boolean[] blArray = this.getSelectedItems();
        builder.setMultiChoiceItems(this.mEntries, blArray, new DialogInterface.OnMultiChoiceClickListener(){

            @Override
            public void onClick(DialogInterface dialogInterface, int n, boolean bl) {
                if (bl) {
                    MultiSelectListPreference.access$076(MultiSelectListPreference.this, MultiSelectListPreference.this.mNewValues.add(MultiSelectListPreference.this.mEntryValues[n].toString()) ? 1 : 0);
                    return;
                }
                MultiSelectListPreference.access$076(MultiSelectListPreference.this, MultiSelectListPreference.this.mNewValues.remove(MultiSelectListPreference.this.mEntryValues[n].toString()) ? 1 : 0);
            }
        });
        this.mNewValues.clear();
        this.mNewValues.addAll(this.mValues);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable == null || !parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mNewValues.addAll(savedState.values);
        this.mPreferenceChanged = savedState.preferenceChanged;
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        savedState.values = this.mNewValues;
        savedState.preferenceChanged = this.mPreferenceChanged;
        return savedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSetInitialValue(boolean bl, Object object) {
        Set<String> set = bl ? this.getPersistedStringSet(this.mValues) : (Set<String>)object;
        this.setValues(set);
    }

    public void setEntries(int n) {
        this.setEntries(this.getContext().getResources().getTextArray(n));
    }

    public void setEntries(CharSequence[] charSequenceArray) {
        this.mEntries = charSequenceArray;
    }

    public void setEntryValues(int n) {
        this.setEntryValues(this.getContext().getResources().getTextArray(n));
    }

    public void setEntryValues(CharSequence[] charSequenceArray) {
        this.mEntryValues = charSequenceArray;
    }

    public void setValues(Set<String> set) {
        this.mValues.clear();
        this.mValues.addAll(set);
        this.persistStringSet(set);
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        boolean preferenceChanged = false;
        Set<String> values;

        public SavedState(Parcel parcel) {
            super(parcel);
            this.values = new HashSet<String>();
            String[] stringArray = parcel.readStringArray();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.values.add(stringArray[i]);
            }
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeStringArray(this.values.toArray(new String[0]));
        }
    }
}

