/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.InflateException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

abstract class GenericInflater<T, P extends Parent> {
    private static final Class[] mConstructorSignature = new Class[]{Context.class, AttributeSet.class};
    private static final HashMap sConstructorMap = new HashMap();
    private final boolean DEBUG;
    private final Object[] mConstructorArgs = new Object[2];
    protected final Context mContext;
    private String mDefaultPackage;
    private Factory<T> mFactory;
    private boolean mFactorySet;

    protected GenericInflater(Context context) {
        this.DEBUG = false;
        this.mContext = context;
    }

    protected GenericInflater(GenericInflater<T, P> genericInflater, Context context) {
        this.DEBUG = false;
        this.mContext = context;
        this.mFactory = genericInflater.mFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final T createItemFromTag(XmlPullParser xmlPullParser, String string2, AttributeSet attributeSet) {
        T t;
        block6: {
            T t2;
            try {
                Factory<T> factory = this.mFactory;
                t = null;
                if (factory != null) {
                    t = this.mFactory.onCreateItem(string2, this.mContext, attributeSet);
                }
                if (t != null) break block6;
                if (-1 == string2.indexOf(46)) {
                    return this.onCreateItem(string2, attributeSet);
                }
                t2 = this.createItem(string2, null, attributeSet);
            }
            catch (InflateException inflateException) {
                throw inflateException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                InflateException inflateException = new InflateException(attributeSet.getPositionDescription() + ": Error inflating class " + string2);
                inflateException.initCause(classNotFoundException);
                throw inflateException;
            }
            catch (Exception exception) {
                InflateException inflateException = new InflateException(attributeSet.getPositionDescription() + ": Error inflating class " + string2);
                inflateException.initCause(exception);
                throw inflateException;
            }
            return t2;
        }
        return t;
    }

    private void rInflate(XmlPullParser xmlPullParser, T t, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        int n;
        int n2 = xmlPullParser.getDepth();
        while (((n = xmlPullParser.next()) != 3 || xmlPullParser.getDepth() > n2) && n != 1) {
            if (n != 2 || this.onCreateCustomFromTag(xmlPullParser, t, attributeSet)) continue;
            T t2 = this.createItemFromTag(xmlPullParser, xmlPullParser.getName(), attributeSet);
            ((Parent)t).addItemFromInflater(t2);
            this.rInflate(xmlPullParser, t2, attributeSet);
        }
    }

    public abstract GenericInflater cloneInContext(Context var1);

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final T createItem(String var1_1, String var2_2, AttributeSet var3_3) throws ClassNotFoundException, InflateException {
        var4_4 = (Constructor<?>)GenericInflater.sConstructorMap.get(var1_1);
        if (var4_4 != null) ** GOTO lbl9
        try {
            var15_5 = this.mContext.getClassLoader();
            var16_6 = var2_2 != null ? var2_2 + var1_1 : var1_1;
            var4_4 = var15_5.loadClass(var16_6).getConstructor(GenericInflater.mConstructorSignature);
            GenericInflater.sConstructorMap.put(var1_1, var4_4);
lbl9:
            // 2 sources

            var13_7 = this.mConstructorArgs;
            var13_7[1] = var3_3;
            var14_8 = var4_4.newInstance(var13_7);
            return var14_8;
        }
        catch (NoSuchMethodException var9_9) {
            var10_10 = new StringBuilder().append(var3_3.getPositionDescription()).append(": Error inflating class ");
            if (var2_2 != null) {
                var1_1 = var2_2 + var1_1;
            }
            var11_11 = new InflateException(var10_10.append(var1_1).toString());
            var11_11.initCause(var9_9);
            throw var11_11;
        }
        catch (ClassNotFoundException var8_12) {
            throw var8_12;
        }
        catch (Exception var5_13) {
            var6_14 = new InflateException(var3_3.getPositionDescription() + ": Error inflating class " + var4_4.getClass().getName());
            var6_14.initCause(var5_13);
            throw var6_14;
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public String getDefaultPackage() {
        return this.mDefaultPackage;
    }

    public final Factory<T> getFactory() {
        return this.mFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T inflate(int n, P p) {
        boolean bl;
        if (p != null) {
            bl = true;
            return this.inflate(n, p, bl);
        }
        bl = false;
        return this.inflate(n, p, bl);
    }

    public T inflate(int n, P p, boolean bl) {
        XmlResourceParser xmlResourceParser = this.getContext().getResources().getXml(n);
        try {
            T t = this.inflate(xmlResourceParser, p, bl);
            return t;
        }
        finally {
            xmlResourceParser.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T inflate(XmlPullParser xmlPullParser, P p) {
        boolean bl;
        if (p != null) {
            bl = true;
            return this.inflate(xmlPullParser, p, bl);
        }
        bl = false;
        return this.inflate(xmlPullParser, p, bl);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T inflate(XmlPullParser xmlPullParser, P p, boolean bl) {
        Object[] objectArray = this.mConstructorArgs;
        synchronized (objectArray) {
            Parent parent;
            AttributeSet attributeSet = Xml.asAttributeSet(xmlPullParser);
            this.mConstructorArgs[0] = this.mContext;
            try {
                int n;
                while ((n = xmlPullParser.next()) != 2 && n != 1) {
                }
                if (n != 2) {
                    throw new InflateException(xmlPullParser.getPositionDescription() + ": No start tag found!");
                }
            }
            catch (InflateException inflateException) {
                throw inflateException;
            }
            catch (XmlPullParserException xmlPullParserException) {
                InflateException inflateException = new InflateException(xmlPullParserException.getMessage());
                inflateException.initCause(xmlPullParserException);
                throw inflateException;
            }
            catch (IOException iOException) {
                InflateException inflateException = new InflateException(xmlPullParser.getPositionDescription() + ": " + iOException.getMessage());
                inflateException.initCause(iOException);
                throw inflateException;
            }
            {
                parent = this.onMergeRoots(p, bl, (Parent)this.createItemFromTag(xmlPullParser, xmlPullParser.getName(), attributeSet));
                this.rInflate(xmlPullParser, parent, attributeSet);
            }
            return (T)parent;
        }
    }

    protected boolean onCreateCustomFromTag(XmlPullParser xmlPullParser, T t, AttributeSet attributeSet) throws XmlPullParserException {
        return false;
    }

    protected T onCreateItem(String string2, AttributeSet attributeSet) throws ClassNotFoundException {
        return this.createItem(string2, this.mDefaultPackage, attributeSet);
    }

    protected P onMergeRoots(P p, boolean bl, P p2) {
        return p2;
    }

    public void setDefaultPackage(String string2) {
        this.mDefaultPackage = string2;
    }

    public void setFactory(Factory<T> factory) {
        if (this.mFactorySet) {
            throw new IllegalStateException("A factory has already been set on this inflater");
        }
        if (factory == null) {
            throw new NullPointerException("Given factory can not be null");
        }
        this.mFactorySet = true;
        if (this.mFactory == null) {
            this.mFactory = factory;
            return;
        }
        this.mFactory = new FactoryMerger<T>(factory, this.mFactory);
    }

    public static interface Factory<T> {
        public T onCreateItem(String var1, Context var2, AttributeSet var3);
    }

    private static class FactoryMerger<T>
    implements Factory<T> {
        private final Factory<T> mF1;
        private final Factory<T> mF2;

        FactoryMerger(Factory<T> factory, Factory<T> factory2) {
            this.mF1 = factory;
            this.mF2 = factory2;
        }

        @Override
        public T onCreateItem(String string2, Context context, AttributeSet attributeSet) {
            T t = this.mF1.onCreateItem(string2, context, attributeSet);
            if (t != null) {
                return t;
            }
            return this.mF2.onCreateItem(string2, context, attributeSet);
        }
    }

    public static interface Parent<T> {
        public void addItemFromInflater(T var1);
    }
}

