/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import com.android.internal.util.IndentingPrintWriter;
import java.io.CharArrayWriter;
import java.io.File;

public class StorageVolume
implements Parcelable {
    public static final Parcelable.Creator<StorageVolume> CREATOR = new Parcelable.Creator<StorageVolume>(){

        @Override
        public StorageVolume createFromParcel(Parcel parcel) {
            return new StorageVolume(parcel);
        }

        public StorageVolume[] newArray(int n) {
            return new StorageVolume[n];
        }
    };
    public static final String EXTRA_STORAGE_VOLUME = "storage_volume";
    private final boolean mAllowMassStorage;
    private final int mDescriptionId;
    private final boolean mEmulated;
    private final long mMaxFileSize;
    private final int mMtpReserveSpace;
    private final UserHandle mOwner;
    private final File mPath;
    private final boolean mPrimary;
    private final boolean mRemovable;
    private String mState;
    private int mStorageId;
    private String mUserLabel;
    private String mUuid;

    /*
     * Enabled aggressive block sorting
     */
    private StorageVolume(Parcel parcel) {
        boolean bl = true;
        this.mStorageId = parcel.readInt();
        this.mPath = new File(parcel.readString());
        this.mDescriptionId = parcel.readInt();
        boolean bl2 = parcel.readInt() != 0 ? bl : false;
        this.mPrimary = bl2;
        boolean bl3 = parcel.readInt() != 0 ? bl : false;
        this.mRemovable = bl3;
        boolean bl4 = parcel.readInt() != 0 ? bl : false;
        this.mEmulated = bl4;
        this.mMtpReserveSpace = parcel.readInt();
        if (parcel.readInt() == 0) {
            bl = false;
        }
        this.mAllowMassStorage = bl;
        this.mMaxFileSize = parcel.readLong();
        this.mOwner = (UserHandle)parcel.readParcelable(null);
        this.mUuid = parcel.readString();
        this.mUserLabel = parcel.readString();
        this.mState = parcel.readString();
    }

    public StorageVolume(File file, int n, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4, long l, UserHandle userHandle) {
        this.mPath = file;
        this.mDescriptionId = n;
        this.mPrimary = bl;
        this.mRemovable = bl2;
        this.mEmulated = bl3;
        this.mMtpReserveSpace = n2;
        this.mAllowMassStorage = bl4;
        this.mMaxFileSize = l;
        this.mOwner = userHandle;
    }

    public static StorageVolume fromTemplate(StorageVolume storageVolume, File file, UserHandle userHandle) {
        return new StorageVolume(file, storageVolume.mDescriptionId, storageVolume.mPrimary, storageVolume.mRemovable, storageVolume.mEmulated, storageVolume.mMtpReserveSpace, storageVolume.mAllowMassStorage, storageVolume.mMaxFileSize, userHandle);
    }

    public boolean allowMassStorage() {
        return this.mAllowMassStorage;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void dump(IndentingPrintWriter indentingPrintWriter) {
        indentingPrintWriter.println("StorageVolume:");
        indentingPrintWriter.increaseIndent();
        indentingPrintWriter.printPair("mStorageId", this.mStorageId);
        indentingPrintWriter.printPair("mPath", this.mPath);
        indentingPrintWriter.printPair("mDescriptionId", this.mDescriptionId);
        indentingPrintWriter.printPair("mPrimary", this.mPrimary);
        indentingPrintWriter.printPair("mRemovable", this.mRemovable);
        indentingPrintWriter.printPair("mEmulated", this.mEmulated);
        indentingPrintWriter.printPair("mMtpReserveSpace", this.mMtpReserveSpace);
        indentingPrintWriter.printPair("mAllowMassStorage", this.mAllowMassStorage);
        indentingPrintWriter.printPair("mMaxFileSize", this.mMaxFileSize);
        indentingPrintWriter.printPair("mOwner", this.mOwner);
        indentingPrintWriter.printPair("mUuid", this.mUuid);
        indentingPrintWriter.printPair("mUserLabel", this.mUserLabel);
        indentingPrintWriter.printPair("mState", this.mState);
        indentingPrintWriter.decreaseIndent();
    }

    public boolean equals(Object object) {
        if (object instanceof StorageVolume && this.mPath != null) {
            StorageVolume storageVolume = (StorageVolume)object;
            return this.mPath.equals(storageVolume.mPath);
        }
        return false;
    }

    public String getDescription(Context context) {
        return context.getResources().getString(this.mDescriptionId);
    }

    public int getDescriptionId() {
        return this.mDescriptionId;
    }

    public int getFatVolumeId() {
        long l;
        if (this.mUuid == null || this.mUuid.length() != 9) {
            return -1;
        }
        try {
            l = Long.parseLong(this.mUuid.replace("-", ""), 16);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return (int)l;
    }

    public long getMaxFileSize() {
        return this.mMaxFileSize;
    }

    public int getMtpReserveSpace() {
        return this.mMtpReserveSpace;
    }

    public UserHandle getOwner() {
        return this.mOwner;
    }

    public String getPath() {
        return this.mPath.toString();
    }

    public File getPathFile() {
        return this.mPath;
    }

    public String getState() {
        return this.mState;
    }

    public int getStorageId() {
        return this.mStorageId;
    }

    public String getUserLabel() {
        return this.mUserLabel;
    }

    public String getUuid() {
        return this.mUuid;
    }

    public int hashCode() {
        return this.mPath.hashCode();
    }

    public boolean isEmulated() {
        return this.mEmulated;
    }

    public boolean isPrimary() {
        return this.mPrimary;
    }

    public boolean isRemovable() {
        return this.mRemovable;
    }

    public void setState(String string2) {
        this.mState = string2;
    }

    public void setStorageId(int n) {
        this.mStorageId = 1 + (n + 1 << 16);
    }

    public void setUserLabel(String string2) {
        this.mUserLabel = string2;
    }

    public void setUuid(String string2) {
        this.mUuid = string2;
    }

    public String toString() {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        this.dump(new IndentingPrintWriter(charArrayWriter, "    ", 80));
        return charArrayWriter.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeInt(this.mStorageId);
        parcel.writeString(this.mPath.toString());
        parcel.writeInt(this.mDescriptionId);
        int n3 = this.mPrimary ? n2 : 0;
        parcel.writeInt(n3);
        int n4 = this.mRemovable ? n2 : 0;
        parcel.writeInt(n4);
        int n5 = this.mEmulated ? n2 : 0;
        parcel.writeInt(n5);
        parcel.writeInt(this.mMtpReserveSpace);
        if (!this.mAllowMassStorage) {
            n2 = 0;
        }
        parcel.writeInt(n2);
        parcel.writeLong(this.mMaxFileSize);
        parcel.writeParcelable(this.mOwner, n);
        parcel.writeString(this.mUuid);
        parcel.writeString(this.mUserLabel);
        parcel.writeString(this.mState);
    }
}

