/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import java.util.ArrayList;
import java.util.HashMap;

public abstract class UEventObserver {
    private static final boolean DEBUG = false;
    private static final String TAG = "UEventObserver";
    private static UEventThread sThread;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static UEventThread getThread() {
        synchronized (UEventObserver.class) {
            if (sThread != null) return sThread;
            sThread = new UEventThread();
            sThread.start();
            return sThread;
        }
    }

    private static native void nativeAddMatch(String var0);

    private static native void nativeRemoveMatch(String var0);

    private static native void nativeSetup();

    private static native String nativeWaitForNextEvent();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static UEventThread peekThread() {
        synchronized (UEventObserver.class) {
            return sThread;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.stopObserving();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public abstract void onUEvent(UEvent var1);

    public final void startObserving(String string2) {
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("match substring must be non-empty");
        }
        UEventObserver.getThread().addObserver(string2, this);
    }

    public final void stopObserving() {
        UEventThread uEventThread = UEventObserver.getThread();
        if (uEventThread != null) {
            uEventThread.removeObserver(this);
        }
    }

    public static final class UEvent {
        private final HashMap<String, String> mMap = new HashMap();

        public UEvent(String string2) {
            int n = 0;
            int n2 = string2.length();
            while (true) {
                int n3;
                int n4;
                block6: {
                    block5: {
                        if (n >= n2) break block5;
                        n4 = string2.indexOf(61, n);
                        n3 = string2.indexOf(0, n);
                        if (n3 >= 0) break block6;
                    }
                    return;
                }
                if (n4 > n && n4 < n3) {
                    this.mMap.put(string2.substring(n, n4), string2.substring(n4 + 1, n3));
                }
                n = n3 + 1;
            }
        }

        public String get(String string2) {
            return this.mMap.get(string2);
        }

        public String get(String string2, String string3) {
            String string4 = this.mMap.get(string2);
            if (string4 == null) {
                return string3;
            }
            return string4;
        }

        public String toString() {
            return this.mMap.toString();
        }
    }

    private static final class UEventThread
    extends Thread {
        private final ArrayList<Object> mKeysAndObservers = new ArrayList();
        private final ArrayList<UEventObserver> mTempObserversToSignal = new ArrayList();

        public UEventThread() {
            super(UEventObserver.TAG);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendEvent(String string2) {
            ArrayList<Object> arrayList = this.mKeysAndObservers;
            synchronized (arrayList) {
                int n = this.mKeysAndObservers.size();
                int n2 = 0;
                while (true) {
                    if (n2 < n) {
                        if (string2.contains((String)this.mKeysAndObservers.get(n2))) {
                            UEventObserver uEventObserver = (UEventObserver)this.mKeysAndObservers.get(n2 + 1);
                            this.mTempObserversToSignal.add(uEventObserver);
                        }
                    } else {
                        // MONITOREXIT @DISABLED, blocks:[2, 3, 7] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (!this.mTempObserversToSignal.isEmpty()) {
                            UEvent uEvent = new UEvent(string2);
                            int n3 = this.mTempObserversToSignal.size();
                            for (int i = 0; i < n3; ++i) {
                                this.mTempObserversToSignal.get(i).onUEvent(uEvent);
                            }
                            this.mTempObserversToSignal.clear();
                        }
                        return;
                    }
                    n2 += 2;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void addObserver(String string2, UEventObserver uEventObserver) {
            ArrayList<Object> arrayList = this.mKeysAndObservers;
            synchronized (arrayList) {
                this.mKeysAndObservers.add(string2);
                this.mKeysAndObservers.add(uEventObserver);
                UEventObserver.nativeAddMatch(string2);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void removeObserver(UEventObserver uEventObserver) {
            ArrayList<Object> arrayList = this.mKeysAndObservers;
            synchronized (arrayList) {
                int n = 0;
                while (n < this.mKeysAndObservers.size()) {
                    if (this.mKeysAndObservers.get(n + 1) == uEventObserver) {
                        this.mKeysAndObservers.remove(n + 1);
                        UEventObserver.nativeRemoveMatch((String)this.mKeysAndObservers.remove(n));
                        continue;
                    }
                    n += 2;
                }
                return;
            }
        }

        @Override
        public void run() {
            UEventObserver.nativeSetup();
            while (true) {
                String string2;
                if ((string2 = UEventObserver.nativeWaitForNextEvent()) == null) {
                    continue;
                }
                this.sendEvent(string2);
            }
        }
    }
}

