/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class TokenWatcher {
    private volatile boolean mAcquired = false;
    private Handler mHandler;
    private int mNotificationQueue = -1;
    private Runnable mNotificationTask = new Runnable(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            WeakHashMap weakHashMap = TokenWatcher.this.mTokens;
            // MONITORENTER : weakHashMap
            int n = TokenWatcher.this.mNotificationQueue;
            TokenWatcher.access$102(TokenWatcher.this, -1);
            // MONITOREXIT : weakHashMap
            if (n == 1) {
                TokenWatcher.this.acquired();
                return;
            }
            if (n != 0) return;
            TokenWatcher.this.released();
        }
    };
    private String mTag;
    private WeakHashMap<IBinder, Death> mTokens = new WeakHashMap();

    /*
     * Enabled aggressive block sorting
     */
    public TokenWatcher(Handler handler, String string2) {
        this.mHandler = handler;
        if (string2 == null) {
            string2 = "TokenWatcher";
        }
        this.mTag = string2;
    }

    static /* synthetic */ int access$102(TokenWatcher tokenWatcher, int n) {
        tokenWatcher.mNotificationQueue = n;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList<String> dumpInternal() {
        ArrayList<String> arrayList = new ArrayList<String>();
        WeakHashMap<IBinder, Death> weakHashMap = this.mTokens;
        synchronized (weakHashMap) {
            Set<IBinder> set = this.mTokens.keySet();
            arrayList.add("Token count: " + this.mTokens.size());
            int n = 0;
            Iterator<IBinder> iterator = set.iterator();
            while (iterator.hasNext()) {
                IBinder iBinder = iterator.next();
                arrayList.add("[" + n + "] " + this.mTokens.get((Object)iBinder).tag + " - " + iBinder);
                ++n;
            }
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendNotificationLocked(boolean bl) {
        int n = bl ? 1 : 0;
        if (this.mNotificationQueue == -1) {
            this.mNotificationQueue = n;
            this.mHandler.post(this.mNotificationTask);
            return;
        } else {
            if (this.mNotificationQueue == n) return;
            this.mNotificationQueue = -1;
            this.mHandler.removeCallbacks(this.mNotificationTask);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acquire(IBinder iBinder, String string2) {
        WeakHashMap<IBinder, Death> weakHashMap = this.mTokens;
        synchronized (weakHashMap) {
            int n = this.mTokens.size();
            Death death = new Death(iBinder, string2);
            try {
                iBinder.linkToDeath(death, 0);
                this.mTokens.put(iBinder, death);
            }
            catch (RemoteException remoteException) {
                return;
            }
            if (n == 0 && !this.mAcquired) {
                this.sendNotificationLocked(true);
                this.mAcquired = true;
            }
            return;
        }
    }

    public abstract void acquired();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanup(IBinder iBinder, boolean bl) {
        WeakHashMap<IBinder, Death> weakHashMap = this.mTokens;
        synchronized (weakHashMap) {
            Death death = this.mTokens.remove(iBinder);
            if (bl && death != null) {
                death.token.unlinkToDeath(death, 0);
                death.token = null;
            }
            if (this.mTokens.size() == 0 && this.mAcquired) {
                this.sendNotificationLocked(false);
                this.mAcquired = false;
            }
            return;
        }
    }

    public void dump() {
        for (String string2 : this.dumpInternal()) {
            Log.i(this.mTag, string2);
        }
    }

    public void dump(PrintWriter printWriter) {
        Iterator<String> iterator = this.dumpInternal().iterator();
        while (iterator.hasNext()) {
            printWriter.println(iterator.next());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAcquired() {
        WeakHashMap<IBinder, Death> weakHashMap = this.mTokens;
        synchronized (weakHashMap) {
            return this.mAcquired;
        }
    }

    public void release(IBinder iBinder) {
        this.cleanup(iBinder, true);
    }

    public abstract void released();

    private class Death
    implements IBinder.DeathRecipient {
        String tag;
        IBinder token;

        Death(IBinder iBinder, String string2) {
            this.token = iBinder;
            this.tag = string2;
        }

        @Override
        public void binderDied() {
            TokenWatcher.this.cleanup(this.token, false);
        }

        protected void finalize() throws Throwable {
            try {
                if (this.token != null) {
                    Log.w(TokenWatcher.this.mTag, "cleaning up leaked reference: " + this.tag);
                    TokenWatcher.this.release(this.token);
                }
                return;
            }
            finally {
                super.finalize();
            }
        }
    }
}

