/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.Context;
import android.media.AudioAttributes;
import android.os.Binder;
import android.os.IVibratorService;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.Vibrator;
import android.util.Log;

public class SystemVibrator
extends Vibrator {
    private static final String TAG = "Vibrator";
    private final IVibratorService mService;
    private final Binder mToken = new Binder();

    public SystemVibrator() {
        this.mService = IVibratorService.Stub.asInterface(ServiceManager.getService("vibrator"));
    }

    public SystemVibrator(Context context) {
        super(context);
        this.mService = IVibratorService.Stub.asInterface(ServiceManager.getService("vibrator"));
    }

    private static int usageForAttributes(AudioAttributes audioAttributes) {
        if (audioAttributes != null) {
            return audioAttributes.getUsage();
        }
        return 0;
    }

    @Override
    public void cancel() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.cancelVibrate(this.mToken);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed to cancel vibration.", remoteException);
            return;
        }
    }

    @Override
    public boolean hasVibrator() {
        if (this.mService == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator service.");
            return false;
        }
        try {
            boolean bl = this.mService.hasVibrator();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public void vibrate(int n, String string2, long l, AudioAttributes audioAttributes) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator service.");
            return;
        }
        try {
            this.mService.vibrate(n, string2, l, SystemVibrator.usageForAttributes(audioAttributes), this.mToken);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed to vibrate.", remoteException);
            return;
        }
    }

    @Override
    public void vibrate(int n, String string2, long[] lArray, int n2, AudioAttributes audioAttributes) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator service.");
            return;
        }
        if (n2 < lArray.length) {
            try {
                this.mService.vibratePattern(n, string2, lArray, n2, SystemVibrator.usageForAttributes(audioAttributes), this.mToken);
                return;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed to vibrate.", remoteException);
                return;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }
}

