/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Registrant;
import java.util.ArrayList;

public class RegistrantList {
    ArrayList registrants = new ArrayList();

    private void internalNotifyRegistrants(Object object, Throwable throwable) {
        synchronized (this) {
            int n = this.registrants.size();
            for (int i = 0; i < n; ++i) {
                ((Registrant)this.registrants.get(i)).internalNotifyRegistrant(object, throwable);
                continue;
            }
            return;
        }
    }

    public void add(Handler handler, int n, Object object) {
        synchronized (this) {
            this.add(new Registrant(handler, n, object));
            return;
        }
    }

    public void add(Registrant registrant) {
        synchronized (this) {
            this.removeCleared();
            this.registrants.add(registrant);
            return;
        }
    }

    public void addUnique(Handler handler, int n, Object object) {
        synchronized (this) {
            this.remove(handler);
            this.add(new Registrant(handler, n, object));
            return;
        }
    }

    public Object get(int n) {
        synchronized (this) {
            Object e = this.registrants.get(n);
            return e;
        }
    }

    public void notifyException(Throwable throwable) {
        this.internalNotifyRegistrants(null, throwable);
    }

    public void notifyRegistrants() {
        this.internalNotifyRegistrants(null, null);
    }

    public void notifyRegistrants(AsyncResult asyncResult) {
        this.internalNotifyRegistrants(asyncResult.result, asyncResult.exception);
    }

    public void notifyResult(Object object) {
        this.internalNotifyRegistrants(object, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(Handler handler) {
        synchronized (this) {
            int n = 0;
            int n2 = this.registrants.size();
            while (true) {
                if (n >= n2) {
                    this.removeCleared();
                    return;
                }
                Registrant registrant = (Registrant)this.registrants.get(n);
                Handler handler2 = registrant.getHandler();
                if (handler2 == null || handler2 == handler) {
                    registrant.clear();
                }
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeCleared() {
        synchronized (this) {
            int n = -1 + this.registrants.size();
            while (n >= 0) {
                if (((Registrant)this.registrants.get((int)n)).refH == null) {
                    this.registrants.remove(n);
                }
                --n;
            }
            return;
        }
    }

    public int size() {
        synchronized (this) {
            int n = this.registrants.size();
            return n;
        }
    }
}

