/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import java.lang.ref.WeakReference;

public class Registrant {
    WeakReference refH;
    Object userObj;
    int what;

    public Registrant(Handler handler, int n, Object object) {
        this.refH = new WeakReference<Handler>(handler);
        this.what = n;
        this.userObj = object;
    }

    public void clear() {
        this.refH = null;
        this.userObj = null;
    }

    public Handler getHandler() {
        if (this.refH == null) {
            return null;
        }
        return (Handler)this.refH.get();
    }

    void internalNotifyRegistrant(Object object, Throwable throwable) {
        Handler handler = this.getHandler();
        if (handler == null) {
            this.clear();
            return;
        }
        Message message = Message.obtain();
        message.what = this.what;
        message.obj = new AsyncResult(this.userObj, object, throwable);
        handler.sendMessage(message);
    }

    public Message messageForRegistrant() {
        Handler handler = this.getHandler();
        if (handler == null) {
            this.clear();
            return null;
        }
        Message message = handler.obtainMessage();
        message.what = this.what;
        message.obj = this.userObj;
        return message;
    }

    public void notifyException(Throwable throwable) {
        this.internalNotifyRegistrant(null, throwable);
    }

    public void notifyRegistrant() {
        this.internalNotifyRegistrant(null, null);
    }

    public void notifyRegistrant(AsyncResult asyncResult) {
        this.internalNotifyRegistrant(asyncResult.result, asyncResult.exception);
    }

    public void notifyResult(Object object) {
        this.internalNotifyRegistrant(object, null);
    }
}

