/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.UserHandle;
import android.os.ZygoteStartFailedEx;
import android.system.Os;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Process {
    public static final int BLUETOOTH_UID = 1002;
    public static final int DRM_UID = 1019;
    public static final int FIRST_APPLICATION_UID = 10000;
    public static final int FIRST_ISOLATED_UID = 99000;
    public static final int FIRST_SHARED_APPLICATION_GID = 50000;
    public static final int LAST_APPLICATION_UID = 19999;
    public static final int LAST_ISOLATED_UID = 99999;
    public static final int LAST_SHARED_APPLICATION_GID = 59999;
    private static final String LOG_TAG = "Process";
    public static final int LOG_UID = 1007;
    public static final int MEDIA_RW_GID = 1023;
    public static final int MEDIA_UID = 1013;
    public static final int NFC_UID = 1027;
    public static final int PACKAGE_INFO_GID = 1032;
    public static final int PHONE_UID = 1001;
    public static final int PROC_COMBINE = 256;
    public static final int PROC_OUT_FLOAT = 16384;
    public static final int PROC_OUT_LONG = 8192;
    public static final int PROC_OUT_STRING = 4096;
    public static final int PROC_PARENS = 512;
    public static final int PROC_QUOTES = 1024;
    public static final int PROC_SPACE_TERM = 32;
    public static final int PROC_TAB_TERM = 9;
    public static final int PROC_TERM_MASK = 255;
    public static final int PROC_ZERO_TERM = 0;
    public static final int ROOT_UID = 0;
    public static final int SCHED_BATCH = 3;
    public static final int SCHED_FIFO = 1;
    public static final int SCHED_IDLE = 5;
    public static final int SCHED_OTHER = 0;
    public static final int SCHED_RR = 2;
    public static final String SECONDARY_ZYGOTE_SOCKET = "zygote_secondary";
    public static final int SHARED_RELRO_UID = 1037;
    public static final int SHARED_USER_GID = 9997;
    public static final int SHELL_UID = 2000;
    public static final int SIGNAL_KILL = 9;
    public static final int SIGNAL_QUIT = 3;
    public static final int SIGNAL_USR1 = 10;
    public static final int SYSTEM_UID = 1000;
    public static final int THREAD_GROUP_AUDIO_APP = 3;
    public static final int THREAD_GROUP_AUDIO_SYS = 4;
    public static final int THREAD_GROUP_BG_NONINTERACTIVE = 0;
    public static final int THREAD_GROUP_DEFAULT = -1;
    private static final int THREAD_GROUP_FOREGROUND = 1;
    public static final int THREAD_GROUP_SYSTEM = 2;
    public static final int THREAD_PRIORITY_AUDIO = -16;
    public static final int THREAD_PRIORITY_BACKGROUND = 10;
    public static final int THREAD_PRIORITY_DEFAULT = 0;
    public static final int THREAD_PRIORITY_DISPLAY = -4;
    public static final int THREAD_PRIORITY_FOREGROUND = -2;
    public static final int THREAD_PRIORITY_LESS_FAVORABLE = 1;
    public static final int THREAD_PRIORITY_LOWEST = 19;
    public static final int THREAD_PRIORITY_MORE_FAVORABLE = -1;
    public static final int THREAD_PRIORITY_URGENT_AUDIO = -19;
    public static final int THREAD_PRIORITY_URGENT_DISPLAY = -8;
    public static final int VPN_UID = 1016;
    public static final int WIFI_UID = 1010;
    static final int ZYGOTE_RETRY_MILLIS = 500;
    public static final String ZYGOTE_SOCKET = "zygote";
    static ZygoteState primaryZygoteState;
    static ZygoteState secondaryZygoteState;

    private static String getAbiList(BufferedWriter bufferedWriter, DataInputStream dataInputStream) throws IOException {
        bufferedWriter.write("1");
        bufferedWriter.newLine();
        bufferedWriter.write("--query-abi-list");
        bufferedWriter.newLine();
        bufferedWriter.flush();
        byte[] byArray = new byte[dataInputStream.readInt()];
        dataInputStream.readFully(byArray);
        return new String(byArray, StandardCharsets.US_ASCII);
    }

    public static final native long getElapsedCpuTime();

    public static final native long getFreeMemory();

    public static final native int getGidForName(String var0);

    public static final int getParentPid(int n) {
        String[] stringArray = new String[]{"PPid:"};
        long[] lArray = new long[]{-1L};
        Process.readProcLines("/proc/" + n + "/status", stringArray, lArray);
        return (int)lArray[0];
    }

    public static final native int[] getPids(String var0, int[] var1);

    public static final native int[] getPidsForCommands(String[] var0);

    public static final native int getProcessGroup(int var0) throws IllegalArgumentException, SecurityException;

    public static final native long getPss(int var0);

    public static final int getThreadGroupLeader(int n) {
        String[] stringArray = new String[]{"Tgid:"};
        long[] lArray = new long[]{-1L};
        Process.readProcLines("/proc/" + n + "/status", stringArray, lArray);
        return (int)lArray[0];
    }

    public static final native int getThreadPriority(int var0) throws IllegalArgumentException;

    public static final native long getTotalMemory();

    public static final native int getUidForName(String var0);

    public static final int getUidForPid(int n) {
        String[] stringArray = new String[]{"Uid:"};
        long[] lArray = new long[]{-1L};
        Process.readProcLines("/proc/" + n + "/status", stringArray, lArray);
        return (int)lArray[0];
    }

    public static final boolean isIsolated() {
        int n = UserHandle.getAppId(Process.myUid());
        return n >= 99000 && n <= 99999;
    }

    public static final void killProcess(int n) {
        Process.sendSignal(n, 9);
    }

    public static final native int killProcessGroup(int var0, int var1);

    public static final void killProcessQuiet(int n) {
        Process.sendSignalQuiet(n, 9);
    }

    public static final int myPid() {
        return Os.getpid();
    }

    public static final int myPpid() {
        return Os.getppid();
    }

    public static final int myTid() {
        return Os.gettid();
    }

    public static final int myUid() {
        return Os.getuid();
    }

    public static final UserHandle myUserHandle() {
        return new UserHandle(UserHandle.getUserId(Process.myUid()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ZygoteState openZygoteSocketIfNeeded(String string2) throws ZygoteStartFailedEx {
        if (primaryZygoteState == null || primaryZygoteState.isClosed()) {
            try {
                primaryZygoteState = ZygoteState.connect(ZYGOTE_SOCKET);
            }
            catch (IOException iOException) {
                throw new ZygoteStartFailedEx("Error connecting to primary zygote", iOException);
            }
        }
        if (primaryZygoteState.matches(string2)) {
            return primaryZygoteState;
        }
        if (secondaryZygoteState == null || secondaryZygoteState.isClosed()) {
            try {
                secondaryZygoteState = ZygoteState.connect(SECONDARY_ZYGOTE_SOCKET);
            }
            catch (IOException iOException) {
                throw new ZygoteStartFailedEx("Error connecting to secondary zygote", iOException);
            }
        }
        if (secondaryZygoteState.matches(string2)) {
            return secondaryZygoteState;
        }
        throw new ZygoteStartFailedEx("Unsupported zygote ABI: " + string2);
    }

    public static final native boolean parseProcLine(byte[] var0, int var1, int var2, int[] var3, String[] var4, long[] var5, float[] var6);

    public static final native boolean readProcFile(String var0, int[] var1, String[] var2, long[] var3, float[] var4);

    public static final native void readProcLines(String var0, String[] var1, long[] var2);

    public static final native void removeAllProcessGroups();

    public static final native void sendSignal(int var0, int var1);

    public static final native void sendSignalQuiet(int var0, int var1);

    public static final native void setArgV0(String var0);

    public static final native void setCanSelfBackground(boolean var0);

    public static final native int setGid(int var0);

    public static final native void setProcessGroup(int var0, int var1) throws IllegalArgumentException, SecurityException;

    public static final native boolean setSwappiness(int var0, boolean var1);

    public static final native void setThreadGroup(int var0, int var1) throws IllegalArgumentException, SecurityException;

    public static final native void setThreadPriority(int var0) throws IllegalArgumentException, SecurityException;

    public static final native void setThreadPriority(int var0, int var1) throws IllegalArgumentException, SecurityException;

    public static final native void setThreadScheduler(int var0, int var1, int var2) throws IllegalArgumentException;

    public static final native int setUid(int var0);

    public static final ProcessStartResult start(String string2, String string3, int n, int n2, int[] nArray, int n3, int n4, int n5, String string4, String string5, String string6, String string7, String[] stringArray) {
        try {
            ProcessStartResult processStartResult = Process.startViaZygote(string2, string3, n, n2, nArray, n3, n4, n5, string4, string5, string6, string7, stringArray);
            return processStartResult;
        }
        catch (ZygoteStartFailedEx zygoteStartFailedEx) {
            Log.e(LOG_TAG, "Starting VM process through Zygote failed");
            throw new RuntimeException("Starting VM process through Zygote failed", zygoteStartFailedEx);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ProcessStartResult startViaZygote(String string2, String string3, int n, int n2, int[] nArray, int n3, int n4, int n5, String string4, String string5, String string6, String string7, String[] stringArray) throws ZygoteStartFailedEx {
        synchronized (Process.class) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("--runtime-init");
            arrayList.add("--setuid=" + n);
            arrayList.add("--setgid=" + n2);
            if ((n3 & 0x10) != 0) {
                arrayList.add("--enable-jni-logging");
            }
            if ((n3 & 8) != 0) {
                arrayList.add("--enable-safemode");
            }
            if ((n3 & 1) != 0) {
                arrayList.add("--enable-debugger");
            }
            if ((n3 & 2) != 0) {
                arrayList.add("--enable-checkjni");
            }
            if ((n3 & 4) != 0) {
                arrayList.add("--enable-assert");
            }
            if (n4 == 2) {
                arrayList.add("--mount-external-multiuser");
            } else if (n4 == 3) {
                arrayList.add("--mount-external-multiuser-all");
            }
            arrayList.add("--target-sdk-version=" + n5);
            if (nArray != null && nArray.length > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("--setgroups=");
                int n6 = nArray.length;
                for (int i = 0; i < n6; ++i) {
                    if (i != 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(nArray[i]);
                }
                arrayList.add(stringBuilder.toString());
            }
            if (string3 != null) {
                arrayList.add("--nice-name=" + string3);
            }
            if (string4 != null) {
                arrayList.add("--seinfo=" + string4);
            }
            if (string6 != null) {
                arrayList.add("--instruction-set=" + string6);
            }
            if (string7 != null) {
                arrayList.add("--app-data-dir=" + string7);
            }
            arrayList.add(string2);
            if (stringArray == null) return Process.zygoteSendArgsAndGetResult(Process.openZygoteSocketIfNeeded(string5), arrayList);
            int n7 = stringArray.length;
            int n8 = 0;
            while (n8 < n7) {
                arrayList.add(stringArray[n8]);
                ++n8;
            }
            return Process.zygoteSendArgsAndGetResult(Process.openZygoteSocketIfNeeded(string5), arrayList);
        }
    }

    @Deprecated
    public static final boolean supportsProcesses() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ProcessStartResult zygoteSendArgsAndGetResult(ZygoteState zygoteState, ArrayList<String> arrayList) throws ZygoteStartFailedEx {
        ProcessStartResult processStartResult;
        DataInputStream dataInputStream;
        try {
            BufferedWriter bufferedWriter = zygoteState.writer;
            dataInputStream = zygoteState.inputStream;
            bufferedWriter.write(Integer.toString(arrayList.size()));
            bufferedWriter.newLine();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string2 = arrayList.get(i);
                if (string2.indexOf(10) >= 0) {
                    throw new ZygoteStartFailedEx("embedded newlines not allowed");
                }
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            processStartResult = new ProcessStartResult();
            processStartResult.pid = dataInputStream.readInt();
            if (processStartResult.pid < 0) {
                throw new ZygoteStartFailedEx("fork() failed");
            }
        }
        catch (IOException iOException) {
            zygoteState.close();
            throw new ZygoteStartFailedEx(iOException);
        }
        processStartResult.usingWrapper = dataInputStream.readBoolean();
        return processStartResult;
    }

    public static final class ProcessStartResult {
        public int pid;
        public boolean usingWrapper;
    }

    public static class ZygoteState {
        final List<String> abiList;
        final DataInputStream inputStream;
        boolean mClosed;
        final LocalSocket socket;
        final BufferedWriter writer;

        private ZygoteState(LocalSocket localSocket, DataInputStream dataInputStream, BufferedWriter bufferedWriter, List<String> list) {
            this.socket = localSocket;
            this.inputStream = dataInputStream;
            this.writer = bufferedWriter;
            this.abiList = list;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static ZygoteState connect(String string2) throws IOException {
            BufferedWriter bufferedWriter;
            DataInputStream dataInputStream;
            LocalSocket localSocket = new LocalSocket();
            try {
                localSocket.connect(new LocalSocketAddress(string2, LocalSocketAddress.Namespace.RESERVED));
                dataInputStream = new DataInputStream(localSocket.getInputStream());
            }
            catch (IOException iOException) {}
            try {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(localSocket.getOutputStream()), 256);
            }
            catch (IOException iOException) {}
            String string3 = Process.getAbiList(bufferedWriter, dataInputStream);
            Log.i("Zygote", "Process: zygote socket opened, supported ABIS: " + string3);
            return new ZygoteState(localSocket, dataInputStream, bufferedWriter, Arrays.asList(string3.split(",")));
            {
                void var2_6;
                try {
                    localSocket.close();
                }
                catch (IOException iOException) {
                    throw var2_6;
                }
                throw var2_6;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close() {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                Log.e(Process.LOG_TAG, "I/O exception on routine close", iOException);
            }
            this.mClosed = true;
        }

        boolean isClosed() {
            return this.mClosed;
        }

        boolean matches(String string2) {
            return this.abiList.contains(string2);
        }
    }
}

