/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BaseBundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.util.ArrayMap;
import android.util.Size;
import android.util.SizeF;
import android.util.SparseArray;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class Bundle
extends BaseBundle
implements Cloneable,
Parcelable {
    public static final Parcelable.Creator<Bundle> CREATOR;
    public static final Bundle EMPTY;
    static final Parcel EMPTY_PARCEL;
    private boolean mAllowFds = true;
    private boolean mFdsKnown = true;
    private boolean mHasFds = false;

    static {
        EMPTY = new Bundle();
        Bundle.EMPTY.mMap = ArrayMap.EMPTY;
        EMPTY_PARCEL = BaseBundle.EMPTY_PARCEL;
        CREATOR = new Parcelable.Creator<Bundle>(){

            @Override
            public Bundle createFromParcel(Parcel parcel) {
                return parcel.readBundle();
            }

            public Bundle[] newArray(int n) {
                return new Bundle[n];
            }
        };
    }

    public Bundle() {
    }

    public Bundle(int n) {
        super(n);
    }

    public Bundle(Bundle bundle) {
        super(bundle);
        this.mHasFds = bundle.mHasFds;
        this.mFdsKnown = bundle.mFdsKnown;
    }

    Bundle(Parcel parcel) {
        super(parcel);
        this.mHasFds = this.mParcelledData.hasFileDescriptors();
        this.mFdsKnown = true;
    }

    Bundle(Parcel parcel, int n) {
        super(parcel, n);
        this.mHasFds = this.mParcelledData.hasFileDescriptors();
        this.mFdsKnown = true;
    }

    public Bundle(PersistableBundle persistableBundle) {
        super(persistableBundle);
    }

    public Bundle(ClassLoader classLoader) {
        super(classLoader);
    }

    public static Bundle forPair(String string2, String string3) {
        Bundle bundle = new Bundle(1);
        bundle.putString(string2, string3);
        return bundle;
    }

    @Override
    public void clear() {
        super.clear();
        this.mHasFds = false;
        this.mFdsKnown = true;
    }

    public Object clone() {
        return new Bundle(this);
    }

    @Override
    public int describeContents() {
        boolean bl = this.hasFileDescriptors();
        int n = 0;
        if (bl) {
            n = 0 | 1;
        }
        return n;
    }

    public IBinder getBinder(String string2) {
        this.unparcel();
        Object v = this.mMap.get(string2);
        if (v == null) {
            return null;
        }
        try {
            IBinder iBinder = (IBinder)v;
            return iBinder;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, v, "IBinder", classCastException);
            return null;
        }
    }

    @Override
    public boolean getBoolean(String string2) {
        return super.getBoolean(string2);
    }

    @Override
    public boolean getBoolean(String string2, boolean bl) {
        return super.getBoolean(string2, bl);
    }

    @Override
    public boolean[] getBooleanArray(String string2) {
        return super.getBooleanArray(string2);
    }

    public Bundle getBundle(String string2) {
        this.unparcel();
        Object v = this.mMap.get(string2);
        if (v == null) {
            return null;
        }
        try {
            Bundle bundle = (Bundle)v;
            return bundle;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, v, "Bundle", classCastException);
            return null;
        }
    }

    @Override
    public byte getByte(String string2) {
        return super.getByte(string2);
    }

    @Override
    public Byte getByte(String string2, byte by) {
        return super.getByte(string2, by);
    }

    @Override
    public byte[] getByteArray(String string2) {
        return super.getByteArray(string2);
    }

    @Override
    public char getChar(String string2) {
        return super.getChar(string2);
    }

    @Override
    public char getChar(String string2, char c) {
        return super.getChar(string2, c);
    }

    @Override
    public char[] getCharArray(String string2) {
        return super.getCharArray(string2);
    }

    @Override
    public CharSequence getCharSequence(String string2) {
        return super.getCharSequence(string2);
    }

    @Override
    public CharSequence getCharSequence(String string2, CharSequence charSequence) {
        return super.getCharSequence(string2, charSequence);
    }

    @Override
    public CharSequence[] getCharSequenceArray(String string2) {
        return super.getCharSequenceArray(string2);
    }

    @Override
    public ArrayList<CharSequence> getCharSequenceArrayList(String string2) {
        return super.getCharSequenceArrayList(string2);
    }

    @Override
    public ClassLoader getClassLoader() {
        return super.getClassLoader();
    }

    @Override
    public float getFloat(String string2) {
        return super.getFloat(string2);
    }

    @Override
    public float getFloat(String string2, float f) {
        return super.getFloat(string2, f);
    }

    @Override
    public float[] getFloatArray(String string2) {
        return super.getFloatArray(string2);
    }

    @Deprecated
    public IBinder getIBinder(String string2) {
        this.unparcel();
        Object v = this.mMap.get(string2);
        if (v == null) {
            return null;
        }
        try {
            IBinder iBinder = (IBinder)v;
            return iBinder;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, v, "IBinder", classCastException);
            return null;
        }
    }

    @Override
    public ArrayList<Integer> getIntegerArrayList(String string2) {
        return super.getIntegerArrayList(string2);
    }

    public <T extends Parcelable> T getParcelable(String string2) {
        Parcelable parcelable;
        this.unparcel();
        Object v = this.mMap.get(string2);
        if (v == null) {
            return null;
        }
        try {
            parcelable = (Parcelable)v;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, v, "Parcelable", classCastException);
            return null;
        }
        return (T)parcelable;
    }

    public Parcelable[] getParcelableArray(String string2) {
        this.unparcel();
        Object v = this.mMap.get(string2);
        if (v == null) {
            return null;
        }
        try {
            Parcelable[] parcelableArray = (Parcelable[])v;
            return parcelableArray;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, v, "Parcelable[]", classCastException);
            return null;
        }
    }

    public <T extends Parcelable> ArrayList<T> getParcelableArrayList(String string2) {
        this.unparcel();
        Object v = this.mMap.get(string2);
        if (v == null) {
            return null;
        }
        try {
            ArrayList arrayList = (ArrayList)v;
            return arrayList;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, v, "ArrayList", classCastException);
            return null;
        }
    }

    @Override
    public Serializable getSerializable(String string2) {
        return super.getSerializable(string2);
    }

    @Override
    public short getShort(String string2) {
        return super.getShort(string2);
    }

    @Override
    public short getShort(String string2, short s) {
        return super.getShort(string2, s);
    }

    @Override
    public short[] getShortArray(String string2) {
        return super.getShortArray(string2);
    }

    public Size getSize(String string2) {
        this.unparcel();
        Object v = this.mMap.get(string2);
        try {
            Size size = (Size)v;
            return size;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, v, "Size", classCastException);
            return null;
        }
    }

    public SizeF getSizeF(String string2) {
        this.unparcel();
        Object v = this.mMap.get(string2);
        try {
            SizeF sizeF = (SizeF)v;
            return sizeF;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, v, "SizeF", classCastException);
            return null;
        }
    }

    public <T extends Parcelable> SparseArray<T> getSparseParcelableArray(String string2) {
        this.unparcel();
        Object v = this.mMap.get(string2);
        if (v == null) {
            return null;
        }
        try {
            SparseArray sparseArray = (SparseArray)v;
            return sparseArray;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, v, "SparseArray", classCastException);
            return null;
        }
    }

    @Override
    public ArrayList<String> getStringArrayList(String string2) {
        return super.getStringArrayList(string2);
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasFileDescriptors() {
        block21: {
            block17: {
                if (this.mFdsKnown) ** GOTO lbl11
                var1_1 = false;
                if (this.mParcelledData == null) break block17;
                var11_2 = this.mParcelledData.hasFileDescriptors();
                var1_1 = false;
                if (var11_2) {
                    var1_1 = true;
                }
lbl8:
                // 5 sources

                while (true) {
                    this.mHasFds = var1_1;
                    this.mFdsKnown = true;
lbl11:
                    // 2 sources

                    return this.mHasFds;
                }
            }
            var2_3 = -1 + this.mMap.size();
            block1: while (true) {
                block18: {
                    if (var2_3 < 0) ** GOTO lbl8
                    var3_4 = this.mMap.valueAt(var2_3);
                    if (!(var3_4 instanceof Parcelable)) break block18;
                    if ((1 & ((Parcelable)var3_4).describeContents()) != 0) {
                        var1_1 = true;
                        ** continue;
                    }
                    ** GOTO lbl30
                }
                if (!(var3_4 instanceof Parcelable[])) break;
                var9_10 = (Parcelable[])var3_4;
                var10_11 = -1 + var9_10.length;
                while (true) {
                    block20: {
                        block19: {
                            if (var10_11 < 0) break block19;
                            if ((1 & var9_10[var10_11].describeContents()) == 0) break block20;
                            var1_1 = true;
                        }
lbl31:
                        // 6 sources

                        while (true) {
                            --var2_3;
                            continue block1;
                            break;
                        }
                    }
                    --var10_11;
                }
                break;
            }
            if (!(var3_4 instanceof SparseArray)) break block21;
            var7_8 = (SparseArray)var3_4;
            var8_9 = -1 + var7_8.size();
            while (true) {
                block22: {
                    if (var8_9 < 0) ** GOTO lbl31
                    if ((1 & ((Parcelable)var7_8.valueAt(var8_9)).describeContents()) == 0) break block22;
                    var1_1 = true;
                    ** GOTO lbl31
                }
                --var8_9;
            }
        }
        if (!(var3_4 instanceof ArrayList) || (var4_5 = (ArrayList)var3_4).isEmpty() || !(var4_5.get(0) instanceof Parcelable)) ** GOTO lbl31
        var5_6 = -1 + var4_5.size();
        while (true) {
            if (var5_6 < 0) ** GOTO lbl31
            var6_7 = (Parcelable)var4_5.get(var5_6);
            if (var6_7 != null && (1 & var6_7.describeContents()) != 0) {
                var1_1 = true;
                ** continue;
            }
            --var5_6;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void putAll(Bundle bundle) {
        this.unparcel();
        bundle.unparcel();
        this.mMap.putAll(bundle.mMap);
        this.mHasFds |= bundle.mHasFds;
        boolean bl = this.mFdsKnown && bundle.mFdsKnown;
        this.mFdsKnown = bl;
    }

    public void putBinder(String string2, IBinder iBinder) {
        this.unparcel();
        this.mMap.put(string2, iBinder);
    }

    @Override
    public void putBoolean(String string2, boolean bl) {
        super.putBoolean(string2, bl);
    }

    @Override
    public void putBooleanArray(String string2, boolean[] blArray) {
        super.putBooleanArray(string2, blArray);
    }

    public void putBundle(String string2, Bundle bundle) {
        this.unparcel();
        this.mMap.put(string2, bundle);
    }

    @Override
    public void putByte(String string2, byte by) {
        super.putByte(string2, by);
    }

    @Override
    public void putByteArray(String string2, byte[] byArray) {
        super.putByteArray(string2, byArray);
    }

    @Override
    public void putChar(String string2, char c) {
        super.putChar(string2, c);
    }

    @Override
    public void putCharArray(String string2, char[] cArray) {
        super.putCharArray(string2, cArray);
    }

    @Override
    public void putCharSequence(String string2, CharSequence charSequence) {
        super.putCharSequence(string2, charSequence);
    }

    @Override
    public void putCharSequenceArray(String string2, CharSequence[] charSequenceArray) {
        super.putCharSequenceArray(string2, charSequenceArray);
    }

    @Override
    public void putCharSequenceArrayList(String string2, ArrayList<CharSequence> arrayList) {
        super.putCharSequenceArrayList(string2, arrayList);
    }

    @Override
    public void putFloat(String string2, float f) {
        super.putFloat(string2, f);
    }

    @Override
    public void putFloatArray(String string2, float[] fArray) {
        super.putFloatArray(string2, fArray);
    }

    @Deprecated
    public void putIBinder(String string2, IBinder iBinder) {
        this.unparcel();
        this.mMap.put(string2, iBinder);
    }

    @Override
    public void putIntegerArrayList(String string2, ArrayList<Integer> arrayList) {
        super.putIntegerArrayList(string2, arrayList);
    }

    public void putParcelable(String string2, Parcelable parcelable) {
        this.unparcel();
        this.mMap.put(string2, parcelable);
        this.mFdsKnown = false;
    }

    public void putParcelableArray(String string2, Parcelable[] parcelableArray) {
        this.unparcel();
        this.mMap.put(string2, parcelableArray);
        this.mFdsKnown = false;
    }

    public void putParcelableArrayList(String string2, ArrayList<? extends Parcelable> arrayList) {
        this.unparcel();
        this.mMap.put(string2, arrayList);
        this.mFdsKnown = false;
    }

    public void putParcelableList(String string2, List<? extends Parcelable> list) {
        this.unparcel();
        this.mMap.put(string2, list);
        this.mFdsKnown = false;
    }

    @Override
    public void putSerializable(String string2, Serializable serializable) {
        super.putSerializable(string2, serializable);
    }

    @Override
    public void putShort(String string2, short s) {
        super.putShort(string2, s);
    }

    @Override
    public void putShortArray(String string2, short[] sArray) {
        super.putShortArray(string2, sArray);
    }

    public void putSize(String string2, Size size) {
        this.unparcel();
        this.mMap.put(string2, size);
    }

    public void putSizeF(String string2, SizeF sizeF) {
        this.unparcel();
        this.mMap.put(string2, sizeF);
    }

    public void putSparseParcelableArray(String string2, SparseArray<? extends Parcelable> sparseArray) {
        this.unparcel();
        this.mMap.put(string2, sparseArray);
        this.mFdsKnown = false;
    }

    @Override
    public void putStringArrayList(String string2, ArrayList<String> arrayList) {
        super.putStringArrayList(string2, arrayList);
    }

    public void readFromParcel(Parcel parcel) {
        super.readFromParcelInner(parcel);
        this.mHasFds = this.mParcelledData.hasFileDescriptors();
        this.mFdsKnown = true;
    }

    public boolean setAllowFds(boolean bl) {
        boolean bl2 = this.mAllowFds;
        this.mAllowFds = bl;
        return bl2;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        super.setClassLoader(classLoader);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        synchronized (this) {
            block4: {
                String string2 = "Bundle[" + this.mMap.toString() + "]";
                if (this.mParcelledData == null) return string2;
                if (this.mParcelledData != EMPTY_PARCEL) break block4;
                return "Bundle[EMPTY_PARCEL]";
            }
            return "Bundle[mParcelledData.dataSize=" + this.mParcelledData.dataSize() + "]";
        }
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        boolean bl = parcel.pushAllowFds(this.mAllowFds);
        try {
            super.writeToParcelInner(parcel, n);
            return;
        }
        finally {
            parcel.restoreAllowFds(bl);
        }
    }
}

