/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.PersistableBundle;
import android.util.ArrayMap;
import android.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class BaseBundle {
    static final int BUNDLE_MAGIC = 1279544898;
    static final boolean DEBUG = false;
    static final Parcel EMPTY_PARCEL = Parcel.obtain();
    private static final String TAG = "Bundle";
    private ClassLoader mClassLoader;
    ArrayMap<String, Object> mMap = null;
    Parcel mParcelledData = null;

    BaseBundle() {
        this((ClassLoader)null, 0);
    }

    BaseBundle(int n) {
        this((ClassLoader)null, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    BaseBundle(BaseBundle baseBundle) {
        if (baseBundle.mParcelledData != null) {
            if (baseBundle.mParcelledData == EMPTY_PARCEL) {
                this.mParcelledData = EMPTY_PARCEL;
            } else {
                this.mParcelledData = Parcel.obtain();
                this.mParcelledData.appendFrom(baseBundle.mParcelledData, 0, baseBundle.mParcelledData.dataSize());
                this.mParcelledData.setDataPosition(0);
            }
        } else {
            this.mParcelledData = null;
        }
        this.mMap = baseBundle.mMap != null ? new ArrayMap(baseBundle.mMap) : null;
        this.mClassLoader = baseBundle.mClassLoader;
    }

    BaseBundle(Parcel parcel) {
        this.readFromParcelInner(parcel);
    }

    BaseBundle(Parcel parcel, int n) {
        this.readFromParcelInner(parcel, n);
    }

    BaseBundle(ClassLoader classLoader) {
        this(classLoader, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    BaseBundle(ClassLoader classLoader, int n) {
        ArrayMap arrayMap = n > 0 ? new ArrayMap(n) : new ArrayMap();
        this.mMap = arrayMap;
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.mClassLoader = classLoader;
    }

    private void readFromParcelInner(Parcel parcel, int n) {
        if (n == 0) {
            this.mParcelledData = EMPTY_PARCEL;
            return;
        }
        int n2 = parcel.readInt();
        if (n2 != 1279544898) {
            throw new IllegalStateException("Bad magic number for Bundle: 0x" + Integer.toHexString(n2));
        }
        int n3 = parcel.dataPosition();
        parcel.setDataPosition(n3 + n);
        Parcel parcel2 = Parcel.obtain();
        parcel2.setDataPosition(0);
        parcel2.appendFrom(parcel, n3, n);
        parcel2.setDataPosition(0);
        this.mParcelledData = parcel2;
    }

    public void clear() {
        this.unparcel();
        this.mMap.clear();
    }

    public boolean containsKey(String string2) {
        this.unparcel();
        return this.mMap.containsKey(string2);
    }

    public Object get(String string2) {
        this.unparcel();
        return this.mMap.get(string2);
    }

    boolean getBoolean(String string2) {
        this.unparcel();
        return this.getBoolean(string2, false);
    }

    boolean getBoolean(String string2, boolean bl) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return bl;
        }
        try {
            boolean bl2 = (Boolean)object;
            return bl2;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "Boolean", bl, classCastException);
            return bl;
        }
    }

    boolean[] getBooleanArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            boolean[] blArray = (boolean[])object;
            return blArray;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "byte[]", classCastException);
            return null;
        }
    }

    byte getByte(String string2) {
        this.unparcel();
        return this.getByte(string2, (byte)0);
    }

    Byte getByte(String string2, byte by) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return by;
        }
        try {
            Byte by2 = (Byte)object;
            return by2;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "Byte", by, classCastException);
            return by;
        }
    }

    byte[] getByteArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            byte[] byArray = (byte[])object;
            return byArray;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "byte[]", classCastException);
            return null;
        }
    }

    char getChar(String string2) {
        this.unparcel();
        return this.getChar(string2, '\u0000');
    }

    char getChar(String string2, char c) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return c;
        }
        try {
            char c2 = ((Character)object).charValue();
            return c2;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "Character", Character.valueOf(c), classCastException);
            return c;
        }
    }

    char[] getCharArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            char[] cArray = (char[])object;
            return cArray;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "char[]", classCastException);
            return null;
        }
    }

    CharSequence getCharSequence(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        try {
            CharSequence charSequence = (CharSequence)object;
            return charSequence;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "CharSequence", classCastException);
            return null;
        }
    }

    CharSequence getCharSequence(String string2, CharSequence charSequence) {
        CharSequence charSequence2 = this.getCharSequence(string2);
        if (charSequence2 == null) {
            return charSequence;
        }
        return charSequence2;
    }

    CharSequence[] getCharSequenceArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            CharSequence[] charSequenceArray = (CharSequence[])object;
            return charSequenceArray;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "CharSequence[]", classCastException);
            return null;
        }
    }

    ArrayList<CharSequence> getCharSequenceArrayList(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            ArrayList arrayList = (ArrayList)object;
            return arrayList;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "ArrayList<CharSequence>", classCastException);
            return null;
        }
    }

    ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public double getDouble(String string2) {
        this.unparcel();
        return this.getDouble(string2, 0.0);
    }

    public double getDouble(String string2, double d) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return d;
        }
        try {
            double d2 = (Double)object;
            return d2;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "Double", d, classCastException);
            return d;
        }
    }

    public double[] getDoubleArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            double[] dArray = (double[])object;
            return dArray;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "double[]", classCastException);
            return null;
        }
    }

    float getFloat(String string2) {
        this.unparcel();
        return this.getFloat(string2, 0.0f);
    }

    float getFloat(String string2, float f) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return f;
        }
        try {
            float f2 = ((Float)object).floatValue();
            return f2;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "Float", Float.valueOf(f), classCastException);
            return f;
        }
    }

    float[] getFloatArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            float[] fArray = (float[])object;
            return fArray;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "float[]", classCastException);
            return null;
        }
    }

    public int getInt(String string2) {
        this.unparcel();
        return this.getInt(string2, 0);
    }

    public int getInt(String string2, int n) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return n;
        }
        try {
            int n2 = (Integer)object;
            return n2;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "Integer", n, classCastException);
            return n;
        }
    }

    public int[] getIntArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            int[] nArray = (int[])object;
            return nArray;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "int[]", classCastException);
            return null;
        }
    }

    ArrayList<Integer> getIntegerArrayList(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            ArrayList arrayList = (ArrayList)object;
            return arrayList;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "ArrayList<Integer>", classCastException);
            return null;
        }
    }

    public long getLong(String string2) {
        this.unparcel();
        return this.getLong(string2, 0L);
    }

    public long getLong(String string2, long l) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return l;
        }
        try {
            long l2 = (Long)object;
            return l2;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "Long", l, classCastException);
            return l;
        }
    }

    public long[] getLongArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            long[] lArray = (long[])object;
            return lArray;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "long[]", classCastException);
            return null;
        }
    }

    public String getPairValue() {
        this.unparcel();
        int n = this.mMap.size();
        if (n > 1) {
            Log.w(TAG, "getPairValue() used on Bundle with multiple pairs.");
        }
        if (n == 0) {
            return null;
        }
        Object object = this.mMap.valueAt(0);
        try {
            String string2 = (String)object;
            return string2;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning("getPairValue()", object, "String", classCastException);
            return null;
        }
    }

    Serializable getSerializable(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            Serializable serializable = (Serializable)object;
            return serializable;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "Serializable", classCastException);
            return null;
        }
    }

    short getShort(String string2) {
        this.unparcel();
        return this.getShort(string2, (short)0);
    }

    short getShort(String string2, short s) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return s;
        }
        try {
            short s2 = (Short)object;
            return s2;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "Short", s, classCastException);
            return s;
        }
    }

    short[] getShortArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            short[] sArray = (short[])object;
            return sArray;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "short[]", classCastException);
            return null;
        }
    }

    public String getString(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        try {
            String string3 = (String)object;
            return string3;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "String", classCastException);
            return null;
        }
    }

    public String getString(String string2, String string3) {
        String string4 = this.getString(string2);
        if (string4 == null) {
            return string3;
        }
        return string4;
    }

    public String[] getStringArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            String[] stringArray = (String[])object;
            return stringArray;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "String[]", classCastException);
            return null;
        }
    }

    ArrayList<String> getStringArrayList(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            ArrayList arrayList = (ArrayList)object;
            return arrayList;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "ArrayList<String>", classCastException);
            return null;
        }
    }

    public boolean isEmpty() {
        this.unparcel();
        return this.mMap.isEmpty();
    }

    public boolean isParcelled() {
        return this.mParcelledData != null;
    }

    public Set<String> keySet() {
        this.unparcel();
        return this.mMap.keySet();
    }

    public void putAll(PersistableBundle persistableBundle) {
        this.unparcel();
        persistableBundle.unparcel();
        this.mMap.putAll(persistableBundle.mMap);
    }

    void putAll(Map map) {
        this.unparcel();
        this.mMap.putAll(map);
    }

    void putBoolean(String string2, boolean bl) {
        this.unparcel();
        this.mMap.put(string2, bl);
    }

    void putBooleanArray(String string2, boolean[] blArray) {
        this.unparcel();
        this.mMap.put(string2, blArray);
    }

    void putByte(String string2, byte by) {
        this.unparcel();
        this.mMap.put(string2, by);
    }

    void putByteArray(String string2, byte[] byArray) {
        this.unparcel();
        this.mMap.put(string2, byArray);
    }

    void putChar(String string2, char c) {
        this.unparcel();
        this.mMap.put(string2, Character.valueOf(c));
    }

    void putCharArray(String string2, char[] cArray) {
        this.unparcel();
        this.mMap.put(string2, cArray);
    }

    void putCharSequence(String string2, CharSequence charSequence) {
        this.unparcel();
        this.mMap.put(string2, charSequence);
    }

    void putCharSequenceArray(String string2, CharSequence[] charSequenceArray) {
        this.unparcel();
        this.mMap.put(string2, charSequenceArray);
    }

    void putCharSequenceArrayList(String string2, ArrayList<CharSequence> arrayList) {
        this.unparcel();
        this.mMap.put(string2, arrayList);
    }

    public void putDouble(String string2, double d) {
        this.unparcel();
        this.mMap.put(string2, d);
    }

    public void putDoubleArray(String string2, double[] dArray) {
        this.unparcel();
        this.mMap.put(string2, dArray);
    }

    void putFloat(String string2, float f) {
        this.unparcel();
        this.mMap.put(string2, Float.valueOf(f));
    }

    void putFloatArray(String string2, float[] fArray) {
        this.unparcel();
        this.mMap.put(string2, fArray);
    }

    public void putInt(String string2, int n) {
        this.unparcel();
        this.mMap.put(string2, n);
    }

    public void putIntArray(String string2, int[] nArray) {
        this.unparcel();
        this.mMap.put(string2, nArray);
    }

    void putIntegerArrayList(String string2, ArrayList<Integer> arrayList) {
        this.unparcel();
        this.mMap.put(string2, arrayList);
    }

    public void putLong(String string2, long l) {
        this.unparcel();
        this.mMap.put(string2, l);
    }

    public void putLongArray(String string2, long[] lArray) {
        this.unparcel();
        this.mMap.put(string2, lArray);
    }

    void putSerializable(String string2, Serializable serializable) {
        this.unparcel();
        this.mMap.put(string2, serializable);
    }

    void putShort(String string2, short s) {
        this.unparcel();
        this.mMap.put(string2, s);
    }

    void putShortArray(String string2, short[] sArray) {
        this.unparcel();
        this.mMap.put(string2, sArray);
    }

    public void putString(String string2, String string3) {
        this.unparcel();
        this.mMap.put(string2, string3);
    }

    public void putStringArray(String string2, String[] stringArray) {
        this.unparcel();
        this.mMap.put(string2, stringArray);
    }

    void putStringArrayList(String string2, ArrayList<String> arrayList) {
        this.unparcel();
        this.mMap.put(string2, arrayList);
    }

    void readFromParcelInner(Parcel parcel) {
        int n = parcel.readInt();
        if (n < 0) {
            throw new RuntimeException("Bad length in parcel: " + n);
        }
        this.readFromParcelInner(parcel, n);
    }

    public void remove(String string2) {
        this.unparcel();
        this.mMap.remove(string2);
    }

    void setClassLoader(ClassLoader classLoader) {
        this.mClassLoader = classLoader;
    }

    public int size() {
        this.unparcel();
        return this.mMap.size();
    }

    void typeWarning(String string2, Object object, String string3, ClassCastException classCastException) {
        this.typeWarning(string2, object, string3, "<null>", classCastException);
    }

    void typeWarning(String string2, Object object, String string3, Object object2, ClassCastException classCastException) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Key ");
        stringBuilder.append(string2);
        stringBuilder.append(" expected ");
        stringBuilder.append(string3);
        stringBuilder.append(" but value was a ");
        stringBuilder.append(object.getClass().getName());
        stringBuilder.append(".  The default value ");
        stringBuilder.append(object2);
        stringBuilder.append(" was returned.");
        Log.w(TAG, stringBuilder.toString());
        Log.w(TAG, "Attempt to cast generated internal exception:", classCastException);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void unparcel() {
        synchronized (this) {
            Parcel parcel = this.mParcelledData;
            if (parcel != null) {
                if (this.mParcelledData == EMPTY_PARCEL) {
                    if (this.mMap == null) {
                        this.mMap = new ArrayMap(1);
                    } else {
                        this.mMap.erase();
                    }
                    this.mParcelledData = null;
                } else {
                    int n = this.mParcelledData.readInt();
                    if (n >= 0) {
                        if (this.mMap == null) {
                            this.mMap = new ArrayMap(n);
                        } else {
                            this.mMap.erase();
                            this.mMap.ensureCapacity(n);
                        }
                        this.mParcelledData.readArrayMapInternal(this.mMap, n, this.mClassLoader);
                        this.mParcelledData.recycle();
                        this.mParcelledData = null;
                    }
                }
            }
            return;
        }
    }

    void writeToParcelInner(Parcel parcel, int n) {
        if (this.mParcelledData != null) {
            if (this.mParcelledData == EMPTY_PARCEL) {
                parcel.writeInt(0);
                return;
            }
            int n2 = this.mParcelledData.dataSize();
            parcel.writeInt(n2);
            parcel.writeInt(1279544898);
            parcel.appendFrom(this.mParcelledData, 0, n2);
            return;
        }
        if (this.mMap == null || this.mMap.size() <= 0) {
            parcel.writeInt(0);
            return;
        }
        int n3 = parcel.dataPosition();
        parcel.writeInt(-1);
        parcel.writeInt(1279544898);
        int n4 = parcel.dataPosition();
        parcel.writeArrayMapInternal(this.mMap);
        int n5 = parcel.dataPosition();
        parcel.setDataPosition(n3);
        parcel.writeInt(n5 - n4);
        parcel.setDataPosition(n5);
    }
}

