/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.Matrix;
import javax.microedition.khronos.opengles.GL10;

public class GLU {
    private static final float[] sScratch = new float[32];

    public static String gluErrorString(int n) {
        switch (n) {
            default: {
                return null;
            }
            case 0: {
                return "no error";
            }
            case 1280: {
                return "invalid enum";
            }
            case 1281: {
                return "invalid value";
            }
            case 1282: {
                return "invalid operation";
            }
            case 1283: {
                return "stack overflow";
            }
            case 1284: {
                return "stack underflow";
            }
            case 1285: 
        }
        return "out of memory";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void gluLookAt(GL10 gL10, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float[] fArray = sScratch;
        synchronized (fArray) {
            Matrix.setLookAtM(fArray, 0, f, f2, f3, f4, f5, f6, f7, f8, f9);
            gL10.glMultMatrixf(fArray, 0);
            return;
        }
    }

    public static void gluOrtho2D(GL10 gL10, float f, float f2, float f3, float f4) {
        gL10.glOrthof(f, f2, f3, f4, -1.0f, 1.0f);
    }

    public static void gluPerspective(GL10 gL10, float f, float f2, float f3, float f4) {
        float f5 = f3 * (float)Math.tan(Math.PI / 360 * (double)f);
        float f6 = -f5;
        gL10.glFrustumf(f6 * f2, f5 * f2, f6, f5, f3, f4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int gluProject(float f, float f2, float f3, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float[] fArray3, int n4) {
        float[] fArray4 = sScratch;
        synchronized (fArray4) {
            Matrix.multiplyMM(fArray4, 0, fArray2, n2, fArray, n);
            fArray4[16] = f;
            fArray4[17] = f2;
            fArray4[18] = f3;
            fArray4[19] = 1.0f;
            Matrix.multiplyMV(fArray4, 20, fArray4, 0, fArray4, 16);
            float f4 = fArray4[23];
            if (f4 == 0.0f) {
                return 0;
            }
            float f5 = 1.0f / f4;
            fArray3[n4] = (float)nArray[n3] + 0.5f * ((float)nArray[n3 + 2] * (1.0f + f5 * fArray4[20]));
            fArray3[n4 + 1] = (float)nArray[n3 + 1] + 0.5f * ((float)nArray[n3 + 3] * (1.0f + f5 * fArray4[21]));
            fArray3[n4 + 2] = 0.5f * (1.0f + f5 * fArray4[22]);
            return 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int gluUnProject(float f, float f2, float f3, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float[] fArray3, int n4) {
        float[] fArray4 = sScratch;
        synchronized (fArray4) {
            Matrix.multiplyMM(fArray4, 0, fArray2, n2, fArray, n);
            if (!Matrix.invertM(fArray4, 16, fArray4, 0)) {
                return 0;
            }
            fArray4[0] = 2.0f * (f - (float)nArray[n3 + 0]) / (float)nArray[n3 + 2] - 1.0f;
            fArray4[1] = 2.0f * (f2 - (float)nArray[n3 + 1]) / (float)nArray[n3 + 3] - 1.0f;
            fArray4[2] = 2.0f * f3 - 1.0f;
            fArray4[3] = 1.0f;
            Matrix.multiplyMV(fArray3, n4, fArray4, 16, fArray4, 0);
            return 1;
        }
    }
}

