/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.tech.BasicTagTechnology;
import android.nfc.tech.NfcA;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public final class MifareUltralight
extends BasicTagTechnology {
    public static final String EXTRA_IS_UL_C = "isulc";
    private static final int MAX_PAGE_COUNT = 256;
    private static final int NXP_MANUFACTURER_ID = 4;
    public static final int PAGE_SIZE = 4;
    private static final String TAG = "NFC";
    public static final int TYPE_ULTRALIGHT = 1;
    public static final int TYPE_ULTRALIGHT_C = 2;
    public static final int TYPE_UNKNOWN = -1;
    private int mType;

    public MifareUltralight(Tag tag) throws RemoteException {
        block3: {
            block2: {
                super(tag, 9);
                NfcA nfcA = NfcA.get(tag);
                this.mType = -1;
                if (nfcA.getSak() != 0 || tag.getId()[0] != 4) break block2;
                if (!tag.getTechExtras(9).getBoolean(EXTRA_IS_UL_C)) break block3;
                this.mType = 2;
            }
            return;
        }
        this.mType = 1;
    }

    public static MifareUltralight get(Tag tag) {
        if (!tag.hasTech(9)) {
            return null;
        }
        try {
            MifareUltralight mifareUltralight = new MifareUltralight(tag);
            return mifareUltralight;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    private static void validatePageIndex(int n) {
        if (n < 0 || n >= 256) {
            throw new IndexOutOfBoundsException("page out of bounds: " + n);
        }
    }

    public int getMaxTransceiveLength() {
        return this.getMaxTransceiveLengthInternal();
    }

    public int getTimeout() {
        try {
            int n = this.mTag.getTagService().getTimeout(9);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "NFC service dead", remoteException);
            return 0;
        }
    }

    public int getType() {
        return this.mType;
    }

    public byte[] readPages(int n) throws IOException {
        MifareUltralight.validatePageIndex(n);
        this.checkConnected();
        byte[] byArray = new byte[]{48, (byte)n};
        return this.transceive(byArray, false);
    }

    public void setTimeout(int n) {
        try {
            if (this.mTag.getTagService().setTimeout(9, n) != 0) {
                throw new IllegalArgumentException("The supplied timeout is not valid");
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "NFC service dead", remoteException);
        }
    }

    public byte[] transceive(byte[] byArray) throws IOException {
        return this.transceive(byArray, true);
    }

    public void writePage(int n, byte[] byArray) throws IOException {
        MifareUltralight.validatePageIndex(n);
        this.checkConnected();
        byte[] byArray2 = new byte[2 + byArray.length];
        byArray2[0] = -94;
        byArray2[1] = (byte)n;
        System.arraycopy((byte[])byArray, (int)0, (byte[])byArray2, (int)2, (int)byArray.length);
        this.transceive(byArray2, false);
    }
}

