/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.cardemulation;

import android.nfc.cardemulation.CardEmulation;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public final class AidGroup
implements Parcelable {
    public static final Parcelable.Creator<AidGroup> CREATOR = new Parcelable.Creator<AidGroup>(){

        @Override
        public AidGroup createFromParcel(Parcel parcel) {
            String string2 = parcel.readString();
            int n = parcel.readInt();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (n > 0) {
                parcel.readStringList(arrayList);
            }
            return new AidGroup(arrayList, string2);
        }

        public AidGroup[] newArray(int n) {
            return new AidGroup[n];
        }
    };
    public static final int MAX_NUM_AIDS = 256;
    static final String TAG = "AidGroup";
    final List<String> aids;
    final String category;
    final String description;

    AidGroup(String string2, String string3) {
        this.aids = new ArrayList<String>();
        this.category = string2;
        this.description = string3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public AidGroup(List<String> list, String string2) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("No AIDS in AID group.");
        }
        if (list.size() > 256) {
            throw new IllegalArgumentException("Too many AIDs in AID group.");
        }
        for (String string3 : list) {
            if (CardEmulation.isValidAid(string3)) continue;
            throw new IllegalArgumentException("AID " + string3 + " is not a valid AID.");
        }
        this.category = AidGroup.isValidCategory(string2) ? string2 : "other";
        this.aids = new ArrayList<String>(list.size());
        Iterator<String> iterator = list.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.description = null;
                return;
            }
            String string4 = iterator.next();
            this.aids.add(string4.toUpperCase());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static AidGroup createFromXml(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        int n = xmlPullParser.getEventType();
        int n2 = xmlPullParser.getDepth();
        while (true) {
            block8: {
                String string3;
                block9: {
                    block10: {
                        AidGroup aidGroup = null;
                        if (n == 1) return aidGroup;
                        int n3 = xmlPullParser.getDepth();
                        aidGroup = null;
                        if (n3 < n2) return aidGroup;
                        string3 = xmlPullParser.getName();
                        if (n != 2) break block9;
                        if (!string3.equals("aid")) break block10;
                        if (bl) {
                            String string4 = xmlPullParser.getAttributeValue(null, "value");
                            if (string4 != null) {
                                arrayList.add(string4.toUpperCase());
                            }
                            break block8;
                        } else {
                            Log.d(TAG, "Ignoring <aid> tag while not in group");
                        }
                        break block8;
                    }
                    if (string3.equals("aid-group")) {
                        string2 = xmlPullParser.getAttributeValue(null, "category");
                        if (string2 == null) {
                            Log.e(TAG, "<aid-group> tag without valid category");
                            return null;
                        }
                        bl = true;
                        break block8;
                    } else {
                        Log.d(TAG, "Ignoring unexpected tag: " + string3);
                    }
                    break block8;
                }
                if (n == 3 && string3.equals("aid-group") && bl && arrayList.size() > 0) {
                    return new AidGroup(arrayList, string2);
                }
            }
            n = xmlPullParser.next();
        }
    }

    static boolean isValidCategory(String string2) {
        return "payment".equals(string2) || "other".equals(string2);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public List<String> getAids() {
        return this.aids;
    }

    public String getCategory() {
        return this.category;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Category: " + this.category + ", AIDs:");
        Iterator<String> iterator = this.aids.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public void writeAsXml(XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.startTag(null, "aid-group");
        xmlSerializer.attribute(null, "category", this.category);
        for (String string2 : this.aids) {
            xmlSerializer.startTag(null, "aid");
            xmlSerializer.attribute(null, "value", string2);
            xmlSerializer.endTag(null, "aid");
        }
        xmlSerializer.endTag(null, "aid-group");
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.category);
        parcel.writeInt(this.aids.size());
        if (this.aids.size() > 0) {
            parcel.writeStringList(this.aids);
        }
    }
}

