/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.app.Activity;
import android.app.ActivityThread;
import android.app.OnActivityPausedListener;
import android.app.PendingIntent;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.IPackageManager;
import android.net.Uri;
import android.nfc.BeamShareData;
import android.nfc.INfcAdapter;
import android.nfc.INfcAdapterExtras;
import android.nfc.INfcCardEmulation;
import android.nfc.INfcTag;
import android.nfc.INfcUnlockHandler;
import android.nfc.NdefMessage;
import android.nfc.NfcActivityManager;
import android.nfc.NfcEvent;
import android.nfc.NfcManager;
import android.nfc.Tag;
import android.nfc.TechListParcel;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.asus.cta.CtaChecker;
import java.util.HashMap;

public final class NfcAdapter {
    public static final String ACTION_ADAPTER_STATE_CHANGED = "android.nfc.action.ADAPTER_STATE_CHANGED";
    public static final String ACTION_HANDOVER_TRANSFER_DONE = "android.nfc.action.HANDOVER_TRANSFER_DONE";
    public static final String ACTION_HANDOVER_TRANSFER_STARTED = "android.nfc.action.HANDOVER_TRANSFER_STARTED";
    public static final String ACTION_NDEF_DISCOVERED = "android.nfc.action.NDEF_DISCOVERED";
    public static final String ACTION_TAG_DISCOVERED = "android.nfc.action.TAG_DISCOVERED";
    public static final String ACTION_TAG_LEFT_FIELD = "android.nfc.action.TAG_LOST";
    public static final String ACTION_TECH_DISCOVERED = "android.nfc.action.TECH_DISCOVERED";
    public static final String EXTRA_ADAPTER_STATE = "android.nfc.extra.ADAPTER_STATE";
    public static final String EXTRA_HANDOVER_TRANSFER_STATUS = "android.nfc.extra.HANDOVER_TRANSFER_STATUS";
    public static final String EXTRA_HANDOVER_TRANSFER_URI = "android.nfc.extra.HANDOVER_TRANSFER_URI";
    public static final String EXTRA_ID = "android.nfc.extra.ID";
    public static final String EXTRA_NDEF_MESSAGES = "android.nfc.extra.NDEF_MESSAGES";
    public static final String EXTRA_READER_PRESENCE_CHECK_DELAY = "presence";
    public static final String EXTRA_TAG = "android.nfc.extra.TAG";
    public static final int FLAG_NDEF_PUSH_NO_CONFIRM = 1;
    public static final int FLAG_READER_NFC_A = 1;
    public static final int FLAG_READER_NFC_B = 2;
    public static final int FLAG_READER_NFC_BARCODE = 16;
    public static final int FLAG_READER_NFC_F = 4;
    public static final int FLAG_READER_NFC_V = 8;
    public static final int FLAG_READER_NO_PLATFORM_SOUNDS = 256;
    public static final int FLAG_READER_SKIP_NDEF_CHECK = 128;
    public static final int HANDOVER_TRANSFER_STATUS_FAILURE = 1;
    public static final int HANDOVER_TRANSFER_STATUS_SUCCESS = 0;
    public static final int STATE_OFF = 1;
    public static final int STATE_ON = 3;
    public static final int STATE_TURNING_OFF = 4;
    public static final int STATE_TURNING_ON = 2;
    static final String TAG = "NFC";
    static INfcCardEmulation sCardEmulationService;
    static boolean sIsInitialized;
    static HashMap<Context, NfcAdapter> sNfcAdapters;
    static NfcAdapter sNullContextNfcAdapter;
    static INfcAdapter sService;
    static INfcTag sTagService;
    final Context mContext;
    OnActivityPausedListener mForegroundDispatchListener = new OnActivityPausedListener(){

        @Override
        public void onPaused(Activity activity) {
            NfcAdapter.this.disableForegroundDispatchInternal(activity, true);
        }
    };
    final Object mLock;
    final NfcActivityManager mNfcActivityManager;
    final HashMap<NfcUnlockHandler, INfcUnlockHandler> mNfcUnlockHandlers;

    static {
        sIsInitialized = false;
        sNfcAdapters = new HashMap();
    }

    NfcAdapter(Context context) {
        this.mContext = context;
        this.mNfcActivityManager = new NfcActivityManager(this);
        this.mNfcUnlockHandlers = new HashMap();
        this.mLock = new Object();
    }

    @Deprecated
    public static NfcAdapter getDefaultAdapter() {
        Log.w(TAG, "WARNING: NfcAdapter.getDefaultAdapter() is deprecated, use NfcAdapter.getDefaultAdapter(Context) instead", new Exception());
        return NfcAdapter.getNfcAdapter(null);
    }

    public static NfcAdapter getDefaultAdapter(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        Context context2 = context.getApplicationContext();
        if (context2 == null) {
            throw new IllegalArgumentException("context not associated with any application (using a mock context?)");
        }
        NfcManager nfcManager = (NfcManager)context2.getSystemService("nfc");
        if (nfcManager == null) {
            return null;
        }
        return nfcManager.getDefaultAdapter();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NfcAdapter getNfcAdapter(Context context) {
        synchronized (NfcAdapter.class) {
            block12: {
                if (!sIsInitialized) {
                    if (!NfcAdapter.hasNfcFeature()) {
                        Log.v(TAG, "this device does not have NFC support");
                        throw new UnsupportedOperationException();
                    }
                    sService = NfcAdapter.getServiceInterface();
                    if (sService == null) {
                        Log.e(TAG, "could not retrieve NFC service");
                        throw new UnsupportedOperationException();
                    }
                    sTagService = sService.getNfcTagInterface();
                    sCardEmulationService = sService.getNfcCardEmulationInterface();
                    sIsInitialized = true;
                }
                if (context == null) {
                    if (sNullContextNfcAdapter != null) return sNullContextNfcAdapter;
                    sNullContextNfcAdapter = new NfcAdapter(null);
                    return sNullContextNfcAdapter;
                }
                break block12;
                catch (RemoteException remoteException) {
                    Log.e(TAG, "could not retrieve NFC Tag service");
                    throw new UnsupportedOperationException();
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "could not retrieve card emulation service");
                    throw new UnsupportedOperationException();
                }
            }
            NfcAdapter nfcAdapter = sNfcAdapters.get(context);
            if (nfcAdapter != null) return nfcAdapter;
            nfcAdapter = new NfcAdapter(context);
            sNfcAdapters.put(context, nfcAdapter);
            return nfcAdapter;
        }
    }

    private static INfcAdapter getServiceInterface() {
        IBinder iBinder = ServiceManager.getService("nfc");
        if (iBinder == null) {
            return null;
        }
        return INfcAdapter.Stub.asInterface(iBinder);
    }

    private static boolean hasNfcFeature() {
        IPackageManager iPackageManager = ActivityThread.getPackageManager();
        if (iPackageManager == null) {
            Log.e(TAG, "Cannot get package manager, assuming no NFC feature");
            return false;
        }
        try {
            boolean bl = iPackageManager.hasSystemFeature("android.hardware.nfc");
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Package manager query failed, assuming no NFC feature", remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addNfcUnlockHandler(final NfcUnlockHandler nfcUnlockHandler, String[] stringArray) {
        if (stringArray.length == 0) {
            return false;
        }
        try {
            Object object = this.mLock;
            synchronized (object) {
            }
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e(TAG, "Unable to register LockscreenDispatch", illegalArgumentException);
            return false;
        }
        {
            if (this.mNfcUnlockHandlers.containsKey(nfcUnlockHandler)) {
                sService.removeNfcUnlockHandler(this.mNfcUnlockHandlers.get(nfcUnlockHandler));
                this.mNfcUnlockHandlers.remove(nfcUnlockHandler);
            }
            INfcUnlockHandler.Stub stub = new INfcUnlockHandler.Stub(){

                @Override
                public boolean onUnlockAttempted(Tag tag) throws RemoteException {
                    return nfcUnlockHandler.onUnlockAttempted(tag);
                }
            };
            sService.addNfcUnlockHandler(stub, Tag.getTechCodesFromStrings(stringArray));
            this.mNfcUnlockHandlers.put(nfcUnlockHandler, stub);
            return true;
        }
    }

    public void attemptDeadServiceRecovery(Exception exception) {
        Log.e(TAG, "NFC service dead - attempting to recover", exception);
        INfcAdapter iNfcAdapter = NfcAdapter.getServiceInterface();
        if (iNfcAdapter == null) {
            Log.e(TAG, "could not retrieve NFC service during service recovery");
            return;
        }
        sService = iNfcAdapter;
        try {
            sTagService = iNfcAdapter.getNfcTagInterface();
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "could not retrieve NFC tag service during service recovery");
            return;
        }
        try {
            sCardEmulationService = iNfcAdapter.getNfcCardEmulationInterface();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "could not retrieve NFC card emulation service during service recovery");
            return;
        }
    }

    public boolean disable() {
        try {
            boolean bl = sService.disable(true);
            return bl;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return false;
        }
    }

    public boolean disable(boolean bl) {
        try {
            boolean bl2 = sService.disable(bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return false;
        }
    }

    public void disableForegroundDispatch(Activity activity) {
        ActivityThread.currentActivityThread().unregisterOnActivityPausedListener(activity, this.mForegroundDispatchListener);
        this.disableForegroundDispatchInternal(activity, false);
    }

    void disableForegroundDispatchInternal(Activity activity, boolean bl) {
        block4: {
            sService.setForegroundDispatch(null, null, null);
            if (bl) break block4;
            try {
                if (!activity.isResumed()) {
                    throw new IllegalStateException("You must disable foreground dispatching while your activity is still resumed");
                }
            }
            catch (RemoteException remoteException) {
                this.attemptDeadServiceRecovery(remoteException);
            }
        }
    }

    @Deprecated
    public void disableForegroundNdefPush(Activity activity) {
        if (activity == null) {
            throw new NullPointerException();
        }
        this.enforceResumed(activity);
        this.mNfcActivityManager.setNdefPushMessage(activity, null, 0);
        this.mNfcActivityManager.setNdefPushMessageCallback(activity, null, 0);
        this.mNfcActivityManager.setOnNdefPushCompleteCallback(activity, null);
    }

    public boolean disableNdefPush() {
        try {
            boolean bl = sService.disableNdefPush();
            return bl;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return false;
        }
    }

    public void disableReaderMode(Activity activity) {
        this.mNfcActivityManager.disableReaderMode(activity);
    }

    public void dispatch(Tag tag) {
        if (tag == null) {
            throw new NullPointerException("tag cannot be null");
        }
        try {
            sService.dispatch(tag);
            return;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return;
        }
    }

    public boolean enable() {
        int n;
        if (Build.CTA && (n = this.getAdapterState()) != 3 && n != 2 && !new CtaChecker(null).checkPermission(21, this.mContext.getPackageName())) {
            try {
                sService.disable(true);
                return false;
            }
            catch (RemoteException remoteException) {
                this.attemptDeadServiceRecovery(remoteException);
                return false;
            }
        }
        try {
            boolean bl = sService.enable();
            return bl;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void enableForegroundDispatch(Activity var1_1, PendingIntent var2_2, IntentFilter[] var3_3, String[][] var4_4) {
        if (var1_1 == null || var2_2 == null) {
            throw new NullPointerException();
        }
        if (!var1_1.isResumed()) {
            throw new IllegalStateException("Foreground dispatch can only be enabled when your activity is resumed");
        }
        var5_5 = null;
        if (var4_4 == null) ** GOTO lbl16
        try {
            var7_6 = var4_4.length;
            var5_5 = null;
            if (var7_6 <= 0) ** GOTO lbl16
        }
        catch (RemoteException var6_7) {
            this.attemptDeadServiceRecovery(var6_7);
            return;
        }
        var5_5 = new TechListParcel(var4_4);
lbl16:
        // 3 sources

        ActivityThread.currentActivityThread().registerOnActivityPausedListener(var1_1, this.mForegroundDispatchListener);
        NfcAdapter.sService.setForegroundDispatch(var2_2, var3_3, var5_5);
    }

    @Deprecated
    public void enableForegroundNdefPush(Activity activity, NdefMessage ndefMessage) {
        if (activity == null || ndefMessage == null) {
            throw new NullPointerException();
        }
        this.enforceResumed(activity);
        this.mNfcActivityManager.setNdefPushMessage(activity, ndefMessage, 0);
    }

    public boolean enableNdefPush() {
        try {
            boolean bl = sService.enableNdefPush();
            return bl;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return false;
        }
    }

    public void enableReaderMode(Activity activity, ReaderCallback readerCallback, int n, Bundle bundle) {
        this.mNfcActivityManager.enableReaderMode(activity, readerCallback, n, bundle);
    }

    void enforceResumed(Activity activity) {
        if (!activity.isResumed()) {
            throw new IllegalStateException("API cannot be called while activity is paused");
        }
    }

    public int getAdapterState() {
        try {
            int n = sService.getState();
            return n;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return 1;
        }
    }

    public INfcCardEmulation getCardEmulationService() {
        this.isEnabled();
        return sCardEmulationService;
    }

    public Context getContext() {
        return this.mContext;
    }

    public INfcAdapterExtras getNfcAdapterExtrasInterface() {
        if (this.mContext == null) {
            throw new UnsupportedOperationException("You need a context on NfcAdapter to use the  NFC extras APIs");
        }
        try {
            INfcAdapterExtras iNfcAdapterExtras = sService.getNfcAdapterExtrasInterface(this.mContext.getPackageName());
            return iNfcAdapterExtras;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return null;
        }
    }

    int getSdkVersion() {
        if (this.mContext == null) {
            return 9;
        }
        return this.mContext.getApplicationInfo().targetSdkVersion;
    }

    public INfcAdapter getService() {
        this.isEnabled();
        return sService;
    }

    public INfcTag getTagService() {
        this.isEnabled();
        return sTagService;
    }

    public boolean invokeBeam(Activity activity) {
        if (activity == null) {
            throw new NullPointerException("activity may not be null.");
        }
        this.enforceResumed(activity);
        try {
            sService.invokeBeam();
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "invokeBeam: NFC process has died.");
            this.attemptDeadServiceRecovery(remoteException);
            return false;
        }
    }

    public boolean invokeBeam(BeamShareData beamShareData) {
        try {
            Log.e(TAG, "invokeBeamInternal()");
            sService.invokeBeamInternal(beamShareData);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "invokeBeam: NFC process has died.");
            this.attemptDeadServiceRecovery(remoteException);
            return false;
        }
    }

    public boolean isEnabled() {
        try {
            int n = sService.getState();
            boolean bl = false;
            if (n == 3) {
                bl = true;
            }
            return bl;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return false;
        }
    }

    public boolean isNdefPushEnabled() {
        try {
            boolean bl = sService.isNdefPushEnabled();
            return bl;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return false;
        }
    }

    public void pausePolling(int n) {
        try {
            sService.pausePolling(n);
            return;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeNfcUnlockHandler(NfcUnlockHandler nfcUnlockHandler) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mNfcUnlockHandlers.containsKey(nfcUnlockHandler)) break block5;
            }
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return false;
        }
        {
            block5: {
                sService.removeNfcUnlockHandler(this.mNfcUnlockHandlers.remove(nfcUnlockHandler));
            }
            return true;
        }
    }

    public void resumePolling() {
        try {
            sService.resumePolling();
            return;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return;
        }
    }

    public void setBeamPushUris(Uri[] uriArray, Activity activity) {
        if (activity == null) {
            throw new NullPointerException("activity cannot be null");
        }
        if (uriArray != null) {
            int n = uriArray.length;
            for (int i = 0; i < n; ++i) {
                Uri uri = uriArray[i];
                if (uri == null) {
                    throw new NullPointerException("Uri not allowed to be null");
                }
                String string2 = uri.getScheme();
                if (string2 != null && (string2.equalsIgnoreCase("file") || string2.equalsIgnoreCase("content"))) continue;
                throw new IllegalArgumentException("URI needs to have either scheme file or scheme content");
            }
        }
        this.mNfcActivityManager.setNdefPushContentUri(activity, uriArray);
    }

    public void setBeamPushUrisCallback(CreateBeamUrisCallback createBeamUrisCallback, Activity activity) {
        if (activity == null) {
            throw new NullPointerException("activity cannot be null");
        }
        this.mNfcActivityManager.setNdefPushContentUriCallback(activity, createBeamUrisCallback);
    }

    public void setNdefPushMessage(NdefMessage ndefMessage, Activity activity, int n) {
        if (activity == null) {
            throw new NullPointerException("activity cannot be null");
        }
        this.mNfcActivityManager.setNdefPushMessage(activity, ndefMessage, n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setNdefPushMessage(NdefMessage var1_1, Activity var2_2, Activity ... var3_3) {
        var4_4 = this.getSdkVersion();
        if (var2_2 != null) ** GOTO lbl-1000
        try {
            throw new NullPointerException("activity cannot be null");
        }
        catch (IllegalStateException var8_5) {
            if (var4_4 >= 16) throw var8_5;
            Log.e("NFC", "Cannot call API with Activity that has already been destroyed", var8_5);
            return;
            return;
        }
lbl-1000:
        // 1 sources

        {
            this.mNfcActivityManager.setNdefPushMessage(var2_2, var1_1, 0);
            var5_6 = var3_3.length;
            var6_7 = 0;
            while (true) {
                if (var6_7 >= var5_6) ** continue;
                var7_8 = var3_3[var6_7];
                if (var7_8 == null) {
                    throw new NullPointerException("activities cannot contain null");
                }
                this.mNfcActivityManager.setNdefPushMessage(var7_8, var1_1, 0);
                ++var6_7;
            }
        }
    }

    public void setNdefPushMessageCallback(CreateNdefMessageCallback createNdefMessageCallback, Activity activity, int n) {
        if (activity == null) {
            throw new NullPointerException("activity cannot be null");
        }
        this.mNfcActivityManager.setNdefPushMessageCallback(activity, createNdefMessageCallback, n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setNdefPushMessageCallback(CreateNdefMessageCallback var1_1, Activity var2_2, Activity ... var3_3) {
        var4_4 = this.getSdkVersion();
        if (var2_2 != null) ** GOTO lbl-1000
        try {
            throw new NullPointerException("activity cannot be null");
        }
        catch (IllegalStateException var8_5) {
            if (var4_4 >= 16) throw var8_5;
            Log.e("NFC", "Cannot call API with Activity that has already been destroyed", var8_5);
            return;
            return;
        }
lbl-1000:
        // 1 sources

        {
            this.mNfcActivityManager.setNdefPushMessageCallback(var2_2, var1_1, 0);
            var5_6 = var3_3.length;
            var6_7 = 0;
            while (true) {
                if (var6_7 >= var5_6) ** continue;
                var7_8 = var3_3[var6_7];
                if (var7_8 == null) {
                    throw new NullPointerException("activities cannot contain null");
                }
                this.mNfcActivityManager.setNdefPushMessageCallback(var7_8, var1_1, 0);
                ++var6_7;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setOnNdefPushCompleteCallback(OnNdefPushCompleteCallback var1_1, Activity var2_2, Activity ... var3_3) {
        var4_4 = this.getSdkVersion();
        if (var2_2 != null) ** GOTO lbl-1000
        try {
            throw new NullPointerException("activity cannot be null");
        }
        catch (IllegalStateException var8_5) {
            if (var4_4 >= 16) throw var8_5;
            Log.e("NFC", "Cannot call API with Activity that has already been destroyed", var8_5);
            return;
            return;
        }
lbl-1000:
        // 1 sources

        {
            this.mNfcActivityManager.setOnNdefPushCompleteCallback(var2_2, var1_1);
            var5_6 = var3_3.length;
            var6_7 = 0;
            while (true) {
                if (var6_7 >= var5_6) ** continue;
                var7_8 = var3_3[var6_7];
                if (var7_8 == null) {
                    throw new NullPointerException("activities cannot contain null");
                }
                this.mNfcActivityManager.setOnNdefPushCompleteCallback(var7_8, var1_1);
                ++var6_7;
            }
        }
    }

    public void setP2pModes(int n, int n2) {
        try {
            sService.setP2pModes(n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return;
        }
    }

    public static interface CreateBeamUrisCallback {
        public Uri[] createBeamUris(NfcEvent var1);
    }

    public static interface CreateNdefMessageCallback {
        public NdefMessage createNdefMessage(NfcEvent var1);
    }

    public static interface NfcUnlockHandler {
        public boolean onUnlockAttempted(Tag var1);
    }

    public static interface OnNdefPushCompleteCallback {
        public void onNdefPushComplete(NfcEvent var1);
    }

    public static interface ReaderCallback {
        public void onTagDiscovered(Tag var1);
    }
}

