/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Locale;

public class WifiP2pServiceRequest
implements Parcelable {
    public static final Parcelable.Creator<WifiP2pServiceRequest> CREATOR = new Parcelable.Creator<WifiP2pServiceRequest>(){

        @Override
        public WifiP2pServiceRequest createFromParcel(Parcel parcel) {
            return new WifiP2pServiceRequest(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readString());
        }

        public WifiP2pServiceRequest[] newArray(int n) {
            return new WifiP2pServiceRequest[n];
        }
    };
    private int mLength;
    private int mProtocolType;
    private String mQuery;
    private int mTransId;

    private WifiP2pServiceRequest(int n, int n2, int n3, String string2) {
        this.mProtocolType = n;
        this.mLength = n2;
        this.mTransId = n3;
        this.mQuery = string2;
    }

    protected WifiP2pServiceRequest(int n, String string2) {
        this.validateQuery(string2);
        this.mProtocolType = n;
        this.mQuery = string2;
        if (string2 != null) {
            this.mLength = 2 + string2.length() / 2;
            return;
        }
        this.mLength = 2;
    }

    public static WifiP2pServiceRequest newInstance(int n) {
        return new WifiP2pServiceRequest(n, null);
    }

    public static WifiP2pServiceRequest newInstance(int n, String string2) {
        return new WifiP2pServiceRequest(n, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateQuery(String string2) {
        if (string2 != null) {
            if (string2.length() % 2 == 1) {
                throw new IllegalArgumentException("query size is invalid. query=" + string2);
            }
            if (string2.length() / 2 > 65535) {
                throw new IllegalArgumentException("query size is too large. len=" + string2.length());
            }
            String string3 = string2.toLowerCase(Locale.ROOT);
            for (char c : string3.toCharArray()) {
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') continue;
                throw new IllegalArgumentException("query should be hex string. query=" + string3);
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        WifiP2pServiceRequest wifiP2pServiceRequest;
        block7: {
            block6: {
                if (object == this) break block6;
                if (!(object instanceof WifiP2pServiceRequest)) {
                    return false;
                }
                wifiP2pServiceRequest = (WifiP2pServiceRequest)object;
                if (wifiP2pServiceRequest.mProtocolType != this.mProtocolType || wifiP2pServiceRequest.mLength != this.mLength) {
                    return false;
                }
                if (wifiP2pServiceRequest.mQuery != null || this.mQuery != null) break block7;
            }
            return true;
        }
        if (wifiP2pServiceRequest.mQuery != null) {
            return wifiP2pServiceRequest.mQuery.equals(this.mQuery);
        }
        return false;
    }

    public String getSupplicantQuery() {
        StringBuffer stringBuffer = new StringBuffer();
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{0xFF & this.mLength};
        stringBuffer.append(String.format(locale, "%02x", objectArray));
        Locale locale2 = Locale.US;
        Object[] objectArray2 = new Object[]{0xFF & this.mLength >> 8};
        stringBuffer.append(String.format(locale2, "%02x", objectArray2));
        Locale locale3 = Locale.US;
        Object[] objectArray3 = new Object[]{this.mProtocolType};
        stringBuffer.append(String.format(locale3, "%02x", objectArray3));
        Locale locale4 = Locale.US;
        Object[] objectArray4 = new Object[]{this.mTransId};
        stringBuffer.append(String.format(locale4, "%02x", objectArray4));
        if (this.mQuery != null) {
            stringBuffer.append(this.mQuery);
        }
        return stringBuffer.toString();
    }

    public int getTransactionId() {
        return this.mTransId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        int n;
        int n2 = 31 * (31 * (527 + this.mProtocolType) + this.mLength);
        if (this.mQuery == null) {
            n = 0;
            return n2 + n;
        }
        n = this.mQuery.hashCode();
        return n2 + n;
    }

    public void setTransactionId(int n) {
        this.mTransId = n;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mProtocolType);
        parcel.writeInt(this.mLength);
        parcel.writeInt(this.mTransId);
        parcel.writeString(this.mQuery);
    }
}

