/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.net.wifi.WpsInfo;
import android.os.Parcel;
import android.os.Parcelable;

public class WifiP2pConfig
implements Parcelable {
    public static final Parcelable.Creator<WifiP2pConfig> CREATOR = new Parcelable.Creator<WifiP2pConfig>(){

        @Override
        public WifiP2pConfig createFromParcel(Parcel parcel) {
            WifiP2pConfig wifiP2pConfig = new WifiP2pConfig();
            wifiP2pConfig.deviceAddress = parcel.readString();
            wifiP2pConfig.wps = (WpsInfo)parcel.readParcelable(null);
            wifiP2pConfig.groupOwnerIntent = parcel.readInt();
            wifiP2pConfig.netId = parcel.readInt();
            return wifiP2pConfig;
        }

        public WifiP2pConfig[] newArray(int n) {
            return new WifiP2pConfig[n];
        }
    };
    public static final int MAX_GROUP_OWNER_INTENT = 15;
    public static final int MIN_GROUP_OWNER_INTENT;
    public String deviceAddress = "";
    public int groupOwnerIntent = -1;
    public int netId = -2;
    public WpsInfo wps;

    public WifiP2pConfig() {
        this.wps = new WpsInfo();
        this.wps.setup = 0;
    }

    public WifiP2pConfig(WifiP2pConfig wifiP2pConfig) {
        if (wifiP2pConfig != null) {
            this.deviceAddress = wifiP2pConfig.deviceAddress;
            this.wps = new WpsInfo(wifiP2pConfig.wps);
            this.groupOwnerIntent = wifiP2pConfig.groupOwnerIntent;
            this.netId = wifiP2pConfig.netId;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public WifiP2pConfig(String string2) throws IllegalArgumentException {
        int n;
        String[] stringArray = string2.split(" ");
        if (stringArray.length < 2) throw new IllegalArgumentException("Malformed supplicant event");
        if (!stringArray[0].equals("P2P-GO-NEG-REQUEST")) {
            throw new IllegalArgumentException("Malformed supplicant event");
        }
        this.deviceAddress = stringArray[1];
        this.wps = new WpsInfo();
        if (stringArray.length <= 2) return;
        String[] stringArray2 = stringArray[2].split("=");
        try {
            int n2;
            n = n2 = Integer.parseInt(stringArray2[1]);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        switch (n) {
            default: {
                this.wps.setup = 0;
                return;
            }
            case 1: {
                this.wps.setup = 1;
                return;
            }
            case 4: {
                this.wps.setup = 0;
                return;
            }
            case 5: 
        }
        this.wps.setup = 2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void invalidate() {
        this.deviceAddress = "";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n address: ").append(this.deviceAddress);
        stringBuffer.append("\n wps: ").append(this.wps);
        stringBuffer.append("\n groupOwnerIntent: ").append(this.groupOwnerIntent);
        stringBuffer.append("\n persist: ").append(this.netId);
        return stringBuffer.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.deviceAddress);
        parcel.writeParcelable(this.wps, n);
        parcel.writeInt(this.groupOwnerIntent);
        parcel.writeInt(this.netId);
    }
}

