/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.net.wifi.IWifiScanner;
import android.net.wifi.ScanResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class WifiScanner {
    private static final int BASE = 159744;
    public static final int CMD_AP_FOUND = 159753;
    public static final int CMD_AP_LOST = 159754;
    public static final int CMD_CONFIGURE_WIFI_CHANGE = 159757;
    public static final int CMD_FULL_SCAN_RESULT = 159764;
    public static final int CMD_GET_SCAN_RESULTS = 159748;
    public static final int CMD_OP_FAILED = 159762;
    public static final int CMD_OP_SUCCEEDED = 159761;
    public static final int CMD_PERIOD_CHANGED = 159763;
    public static final int CMD_RESET_HOTLIST = 159751;
    public static final int CMD_SCAN = 159744;
    public static final int CMD_SCAN_RESULT = 159749;
    public static final int CMD_SET_HOTLIST = 159750;
    public static final int CMD_START_BACKGROUND_SCAN = 159746;
    public static final int CMD_START_TRACKING_CHANGE = 159755;
    public static final int CMD_STOP_BACKGROUND_SCAN = 159747;
    public static final int CMD_STOP_TRACKING_CHANGE = 159756;
    public static final int CMD_WIFI_CHANGES_STABILIZED = 159760;
    public static final int CMD_WIFI_CHANGE_DETECTED = 159759;
    private static final boolean DBG = true;
    public static final String GET_AVAILABLE_CHANNELS_EXTRA = "Channels";
    private static final int INVALID_KEY = 0;
    public static final int MAX_SCAN_PERIOD_MS = 1024000;
    public static final int MIN_SCAN_PERIOD_MS = 1000;
    public static final int REASON_INVALID_LISTENER = -2;
    public static final int REASON_INVALID_REQUEST = -3;
    public static final int REASON_NOT_AUTHORIZED = -4;
    public static final int REASON_SUCCEEDED = 0;
    public static final int REASON_UNSPECIFIED = -1;
    public static final int REPORT_EVENT_AFTER_BUFFER_FULL = 0;
    public static final int REPORT_EVENT_AFTER_EACH_SCAN = 1;
    public static final int REPORT_EVENT_FULL_SCAN_RESULT = 2;
    private static final String TAG = "WifiScanner";
    public static final int WIFI_BAND_24_GHZ = 1;
    public static final int WIFI_BAND_5_GHZ = 2;
    public static final int WIFI_BAND_5_GHZ_DFS_ONLY = 4;
    public static final int WIFI_BAND_5_GHZ_WITH_DFS = 6;
    public static final int WIFI_BAND_BOTH = 3;
    public static final int WIFI_BAND_BOTH_WITH_DFS = 7;
    public static final int WIFI_BAND_UNSPECIFIED;
    private static AsyncChannel sAsyncChannel;
    private static CountDownLatch sConnected;
    private static HandlerThread sHandlerThread;
    private static int sListenerKey;
    private static final SparseArray sListenerMap;
    private static final Object sListenerMapLock;
    private static int sThreadRefCount;
    private static final Object sThreadRefLock;
    private Context mContext;
    private IWifiScanner mService;

    static {
        sListenerKey = 1;
        sListenerMap = new SparseArray();
        sListenerMapLock = new Object();
        sThreadRefLock = new Object();
    }

    public WifiScanner(Context context, IWifiScanner iWifiScanner) {
        this.mContext = context;
        this.mService = iWifiScanner;
        this.init();
    }

    static /* synthetic */ AsyncChannel access$002(AsyncChannel asyncChannel) {
        sAsyncChannel = asyncChannel;
        return asyncChannel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object getListener(int n) {
        if (n == 0) {
            return null;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            return sListenerMap.get(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getListenerKey(Object object) {
        if (object == null) {
            return 0;
        }
        Object object2 = sListenerMapLock;
        synchronized (object2) {
            int n = sListenerMap.indexOfValue(object);
            if (n != -1) return sListenerMap.keyAt(n);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() {
        Object object = sThreadRefLock;
        synchronized (object) {
            int n;
            sThreadRefCount = n = 1 + sThreadRefCount;
            if (n == 1) {
                Messenger messenger;
                try {
                    Messenger messenger2;
                    messenger = messenger2 = this.mService.getMessenger();
                }
                catch (SecurityException securityException) {
                    messenger = null;
                }
                catch (RemoteException remoteException) {
                    messenger = null;
                }
                if (messenger == null) {
                    sAsyncChannel = null;
                    return;
                }
                sHandlerThread = new HandlerThread(TAG);
                sAsyncChannel = new AsyncChannel();
                sConnected = new CountDownLatch(1);
                sHandlerThread.start();
                ServiceHandler serviceHandler = new ServiceHandler(sHandlerThread.getLooper());
                sAsyncChannel.connect(this.mContext, (Handler)serviceHandler, messenger);
                try {
                    sConnected.await();
                }
                catch (InterruptedException interruptedException) {
                    Log.e(TAG, "interrupted wait at init");
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int putListener(Object object) {
        if (object == null) {
            return 0;
        }
        Object object2 = sListenerMapLock;
        synchronized (object2) {
            int n;
            do {
                n = sListenerKey;
                sListenerKey = n + 1;
            } while (n == 0);
            sListenerMap.put(n, object);
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int removeListener(Object object) {
        int n = WifiScanner.getListenerKey(object);
        if (n == 0) {
            return n;
        }
        Object object2 = sListenerMapLock;
        synchronized (object2) {
            sListenerMap.remove(n);
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object removeListener(int n) {
        if (n == 0) {
            return null;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            Object e = sListenerMap.get(n);
            sListenerMap.remove(n);
            return e;
        }
    }

    private void validateChannel() {
        if (sAsyncChannel == null) {
            throw new IllegalStateException("No permission to access and change wifi or a bad initialization");
        }
    }

    public void configureWifiChange(int n, int n2, int n3, int n4, int n5, BssidInfo[] bssidInfoArray) {
        this.validateChannel();
        WifiChangeSettings wifiChangeSettings = new WifiChangeSettings();
        wifiChangeSettings.rssiSampleSize = n;
        wifiChangeSettings.lostApSampleSize = n2;
        wifiChangeSettings.unchangedSampleSize = n3;
        wifiChangeSettings.minApsBreachingThreshold = n4;
        wifiChangeSettings.periodInMs = n5;
        wifiChangeSettings.bssidInfos = bssidInfoArray;
        this.configureWifiChange(wifiChangeSettings);
    }

    public void configureWifiChange(WifiChangeSettings wifiChangeSettings) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159757, 0, 0, wifiChangeSettings);
    }

    public List<Integer> getAvailableChannels(int n) {
        try {
            ArrayList<Integer> arrayList = this.mService.getAvailableChannels(n).getIntegerArrayList(GET_AVAILABLE_CHANNELS_EXTRA);
            return arrayList;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public ScanResult[] getScanResults() {
        this.validateChannel();
        return (ScanResult[])WifiScanner.sAsyncChannel.sendMessageSynchronously((int)159748, (int)0).obj;
    }

    public void startBackgroundScan(ScanSettings scanSettings, ScanListener scanListener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159746, 0, WifiScanner.putListener(scanListener), scanSettings);
    }

    public void startTrackingBssids(BssidInfo[] bssidInfoArray, int n, BssidListener bssidListener) {
        this.validateChannel();
        HotlistSettings hotlistSettings = new HotlistSettings();
        hotlistSettings.bssidInfos = bssidInfoArray;
        sAsyncChannel.sendMessage(159750, 0, WifiScanner.putListener(bssidListener), hotlistSettings);
    }

    public void startTrackingWifiChange(WifiChangeListener wifiChangeListener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159755, 0, WifiScanner.putListener(wifiChangeListener));
    }

    public void stopBackgroundScan(ScanListener scanListener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159747, 0, WifiScanner.removeListener(scanListener));
    }

    public void stopTrackingBssids(BssidListener bssidListener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159751, 0, WifiScanner.removeListener(bssidListener));
    }

    public void stopTrackingWifiChange(WifiChangeListener wifiChangeListener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159756, 0, WifiScanner.removeListener(wifiChangeListener));
    }

    public static interface ActionListener {
        public void onFailure(int var1, String var2);

        public void onSuccess();
    }

    public static class BssidInfo {
        public String bssid;
        public int frequencyHint;
        public int high;
        public int low;
    }

    public static interface BssidListener
    extends ActionListener {
        public void onFound(ScanResult[] var1);
    }

    public static class ChannelSpec {
        public int dwellTimeMS;
        public int frequency;
        public boolean passive;

        public ChannelSpec(int n) {
            this.frequency = n;
            this.passive = false;
            this.dwellTimeMS = 0;
        }
    }

    public static class HotlistSettings
    implements Parcelable {
        public static final Parcelable.Creator<HotlistSettings> CREATOR = new Parcelable.Creator<HotlistSettings>(){

            @Override
            public HotlistSettings createFromParcel(Parcel parcel) {
                HotlistSettings hotlistSettings = new HotlistSettings();
                hotlistSettings.apLostThreshold = parcel.readInt();
                int n = parcel.readInt();
                hotlistSettings.bssidInfos = new BssidInfo[n];
                for (int i = 0; i < n; ++i) {
                    BssidInfo bssidInfo = new BssidInfo();
                    bssidInfo.bssid = parcel.readString();
                    bssidInfo.low = parcel.readInt();
                    bssidInfo.high = parcel.readInt();
                    bssidInfo.frequencyHint = parcel.readInt();
                    hotlistSettings.bssidInfos[i] = bssidInfo;
                }
                return hotlistSettings;
            }

            public HotlistSettings[] newArray(int n) {
                return new HotlistSettings[n];
            }
        };
        public int apLostThreshold;
        public BssidInfo[] bssidInfos;

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.apLostThreshold);
            if (this.bssidInfos != null) {
                parcel.writeInt(this.bssidInfos.length);
                for (int i = 0; i < this.bssidInfos.length; ++i) {
                    BssidInfo bssidInfo = this.bssidInfos[i];
                    parcel.writeString(bssidInfo.bssid);
                    parcel.writeInt(bssidInfo.low);
                    parcel.writeInt(bssidInfo.high);
                    parcel.writeInt(bssidInfo.frequencyHint);
                }
            } else {
                parcel.writeInt(0);
            }
        }
    }

    public static class OperationResult
    implements Parcelable {
        public static final Parcelable.Creator<OperationResult> CREATOR = new Parcelable.Creator<OperationResult>(){

            @Override
            public OperationResult createFromParcel(Parcel parcel) {
                return new OperationResult(parcel.readInt(), parcel.readString());
            }

            public OperationResult[] newArray(int n) {
                return new OperationResult[n];
            }
        };
        public String description;
        public int reason;

        public OperationResult(int n, String string2) {
            this.reason = n;
            this.description = string2;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.reason);
            parcel.writeString(this.description);
        }
    }

    public static class ParcelableScanResults
    implements Parcelable {
        public static final Parcelable.Creator<ParcelableScanResults> CREATOR = new Parcelable.Creator<ParcelableScanResults>(){

            @Override
            public ParcelableScanResults createFromParcel(Parcel parcel) {
                int n = parcel.readInt();
                ScanResult[] scanResultArray = new ScanResult[n];
                for (int i = 0; i < n; ++i) {
                    scanResultArray[i] = ScanResult.CREATOR.createFromParcel(parcel);
                }
                return new ParcelableScanResults(scanResultArray);
            }

            public ParcelableScanResults[] newArray(int n) {
                return new ParcelableScanResults[n];
            }
        };
        public ScanResult[] mResults;

        public ParcelableScanResults(ScanResult[] scanResultArray) {
            this.mResults = scanResultArray;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public ScanResult[] getResults() {
            return this.mResults;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            if (this.mResults != null) {
                parcel.writeInt(this.mResults.length);
                for (int i = 0; i < this.mResults.length; ++i) {
                    this.mResults[i].writeToParcel(parcel, n);
                }
            } else {
                parcel.writeInt(0);
            }
        }
    }

    public static interface ScanListener
    extends ActionListener {
        public void onFullResult(ScanResult var1);

        public void onPeriodChanged(int var1);

        public void onResults(ScanResult[] var1);
    }

    public static class ScanSettings
    implements Parcelable {
        public static final Parcelable.Creator<ScanSettings> CREATOR = new Parcelable.Creator<ScanSettings>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public ScanSettings createFromParcel(Parcel parcel) {
                ScanSettings scanSettings = new ScanSettings();
                scanSettings.band = parcel.readInt();
                scanSettings.periodInMs = parcel.readInt();
                scanSettings.reportEvents = parcel.readInt();
                scanSettings.numBssidsPerScan = parcel.readInt();
                int n = parcel.readInt();
                scanSettings.channels = new ChannelSpec[n];
                int n2 = 0;
                while (n2 < n) {
                    ChannelSpec channelSpec = new ChannelSpec(parcel.readInt());
                    channelSpec.dwellTimeMS = parcel.readInt();
                    boolean bl = parcel.readInt() == 1;
                    channelSpec.passive = bl;
                    scanSettings.channels[n2] = channelSpec;
                    ++n2;
                }
                return scanSettings;
            }

            public ScanSettings[] newArray(int n) {
                return new ScanSettings[n];
            }
        };
        public int band;
        public ChannelSpec[] channels;
        public int numBssidsPerScan;
        public int periodInMs;
        public int reportEvents;

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.band);
            parcel.writeInt(this.periodInMs);
            parcel.writeInt(this.reportEvents);
            parcel.writeInt(this.numBssidsPerScan);
            if (this.channels == null) {
                parcel.writeInt(0);
                return;
            } else {
                parcel.writeInt(this.channels.length);
                for (int i = 0; i < this.channels.length; ++i) {
                    parcel.writeInt(this.channels[i].frequency);
                    parcel.writeInt(this.channels[i].dwellTimeMS);
                    int n2 = this.channels[i].passive ? 1 : 0;
                    parcel.writeInt(n2);
                }
            }
        }
    }

    private static class ServiceHandler
    extends Handler {
        ServiceHandler(Looper looper) {
            super(looper);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            Object object;
            switch (message.what) {
                default: {
                    object = WifiScanner.getListener(message.arg2);
                    if (object != null) break;
                    Log.d(WifiScanner.TAG, "invalid listener key = " + message.arg2);
                }
                case 69634: {
                    return;
                }
                case 69632: {
                    if (message.arg1 == 0) {
                        sAsyncChannel.sendMessage(69633);
                    } else {
                        Log.e(WifiScanner.TAG, "Failed to set up channel connection");
                        WifiScanner.access$002(null);
                    }
                    sConnected.countDown();
                    return;
                }
                case 69636: {
                    Log.e(WifiScanner.TAG, "Channel connection lost");
                    WifiScanner.access$002(null);
                    this.getLooper().quit();
                    return;
                }
            }
            Log.d(WifiScanner.TAG, "listener key = " + message.arg2);
            switch (message.what) {
                default: {
                    Log.d(WifiScanner.TAG, "Ignoring message " + message.what);
                    return;
                }
                case 159761: {
                    ((ActionListener)object).onSuccess();
                    return;
                }
                case 159762: {
                    OperationResult operationResult = (OperationResult)message.obj;
                    ((ActionListener)object).onFailure(operationResult.reason, operationResult.description);
                    WifiScanner.removeListener(message.arg2);
                    return;
                }
                case 159749: {
                    ((ScanListener)object).onResults(((ParcelableScanResults)message.obj).getResults());
                    return;
                }
                case 159764: {
                    ScanResult scanResult = (ScanResult)message.obj;
                    ((ScanListener)object).onFullResult(scanResult);
                    return;
                }
                case 159763: {
                    ((ScanListener)object).onPeriodChanged(message.arg1);
                    return;
                }
                case 159753: {
                    ((BssidListener)object).onFound(((ParcelableScanResults)message.obj).getResults());
                    return;
                }
                case 159759: {
                    ((WifiChangeListener)object).onChanging(((ParcelableScanResults)message.obj).getResults());
                    return;
                }
                case 159760: 
            }
            ((WifiChangeListener)object).onQuiescence(((ParcelableScanResults)message.obj).getResults());
        }
    }

    public static interface WifiChangeListener
    extends ActionListener {
        public void onChanging(ScanResult[] var1);

        public void onQuiescence(ScanResult[] var1);
    }

    public static class WifiChangeSettings
    implements Parcelable {
        public static final Parcelable.Creator<WifiChangeSettings> CREATOR = new Parcelable.Creator<WifiChangeSettings>(){

            @Override
            public WifiChangeSettings createFromParcel(Parcel parcel) {
                WifiChangeSettings wifiChangeSettings = new WifiChangeSettings();
                wifiChangeSettings.rssiSampleSize = parcel.readInt();
                wifiChangeSettings.lostApSampleSize = parcel.readInt();
                wifiChangeSettings.unchangedSampleSize = parcel.readInt();
                wifiChangeSettings.minApsBreachingThreshold = parcel.readInt();
                wifiChangeSettings.periodInMs = parcel.readInt();
                int n = parcel.readInt();
                wifiChangeSettings.bssidInfos = new BssidInfo[n];
                for (int i = 0; i < n; ++i) {
                    BssidInfo bssidInfo = new BssidInfo();
                    bssidInfo.bssid = parcel.readString();
                    bssidInfo.low = parcel.readInt();
                    bssidInfo.high = parcel.readInt();
                    bssidInfo.frequencyHint = parcel.readInt();
                    wifiChangeSettings.bssidInfos[i] = bssidInfo;
                }
                return wifiChangeSettings;
            }

            public WifiChangeSettings[] newArray(int n) {
                return new WifiChangeSettings[n];
            }
        };
        public BssidInfo[] bssidInfos;
        public int lostApSampleSize;
        public int minApsBreachingThreshold;
        public int periodInMs;
        public int rssiSampleSize;
        public int unchangedSampleSize;

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.rssiSampleSize);
            parcel.writeInt(this.lostApSampleSize);
            parcel.writeInt(this.unchangedSampleSize);
            parcel.writeInt(this.minApsBreachingThreshold);
            parcel.writeInt(this.periodInMs);
            if (this.bssidInfos != null) {
                parcel.writeInt(this.bssidInfos.length);
                for (int i = 0; i < this.bssidInfos.length; ++i) {
                    BssidInfo bssidInfo = this.bssidInfos[i];
                    parcel.writeString(bssidInfo.bssid);
                    parcel.writeInt(bssidInfo.low);
                    parcel.writeInt(bssidInfo.high);
                    parcel.writeInt(bssidInfo.frequencyHint);
                }
            } else {
                parcel.writeInt(0);
            }
        }
    }
}

