/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Parcel;
import android.os.Parcelable;

public class WifiChannel
implements Parcelable {
    public static final Parcelable.Creator<WifiChannel> CREATOR = new Parcelable.Creator<WifiChannel>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public WifiChannel createFromParcel(Parcel parcel) {
            WifiChannel wifiChannel = new WifiChannel();
            wifiChannel.freqMHz = parcel.readInt();
            wifiChannel.channelNum = parcel.readInt();
            boolean bl = parcel.readInt() != 0;
            wifiChannel.isDFS = bl;
            return wifiChannel;
        }

        public WifiChannel[] newArray(int n) {
            return new WifiChannel[n];
        }
    };
    private static final int MAX_CHANNEL_NUM = 196;
    private static final int MAX_FREQ_MHZ = 5825;
    private static final int MIN_CHANNEL_NUM = 1;
    private static final int MIN_FREQ_MHZ = 2412;
    public int channelNum;
    public int freqMHz;
    public boolean isDFS;

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid() {
        int n = 1;
        if (this.freqMHz < 2412) return 0 != 0;
        if (this.freqMHz > 5825) {
            return 0 != 0;
        }
        if (this.channelNum < n) return false;
        if (this.channelNum <= 196) return n != 0;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.freqMHz);
        parcel.writeInt(this.channelNum);
        int n2 = this.isDFS ? 1 : 0;
        parcel.writeInt(n2);
    }
}

